/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.ReportAggregatesBuilder;
import com.aventstack.extentreports.ReportService;
import com.aventstack.extentreports.ReportStatusStats;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.SystemAttribute;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.context.ExceptionTestContextStore;
import com.aventstack.extentreports.model.context.SystemAttributeContext;
import com.aventstack.extentreports.model.context.TestAttributeTestContextStore;
import com.aventstack.extentreports.model.context.helpers.TestRemover;
import com.aventstack.extentreports.model.service.ScreenCaptureService;
import com.aventstack.extentreports.model.service.TestService;
import com.aventstack.extentreports.reporter.ExtentReporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class ReportObservable
implements ReportService {
    private AnalysisStrategy strategy = AnalysisStrategy.TEST;
    private boolean usesManualConfiguration = false;
    private Status reportStatus = Status.PASS;
    private Date reportStartDate = Calendar.getInstance().getTime();
    private Date reportEndDate;
    private TestAttributeTestContextStore<Category> categoryContext = new TestAttributeTestContextStore();
    private TestAttributeTestContextStore<Author> authorContext = new TestAttributeTestContextStore();
    private TestAttributeTestContextStore<Device> deviceContext = new TestAttributeTestContextStore();
    private ExceptionTestContextStore exceptionContext = new ExceptionTestContextStore();
    private SystemAttributeContext systemAttributeContext = new SystemAttributeContext();
    private List<ExtentReporter> reporterList = new ArrayList<ExtentReporter>();
    private List<String> testRunnerLogs = new ArrayList<String>();
    private List<Test> testList = new ArrayList<Test>();
    private ReportStatusStats stats = new ReportStatusStats(this.strategy);
    private Set<Status> statusSet = new HashSet<Status>();
    private String[] imagePathResolveDir;

    protected ReportObservable() {
    }

    protected void register(ExtentReporter reporter) {
        this.reporterList.add(reporter);
        reporter.start();
    }

    protected void deregister(ExtentReporter reporter) {
        if (this.reporterList.contains(reporter)) {
            reporter.stop();
            this.reporterList.remove(reporter);
        }
    }

    protected List<ExtentReporter> getReporterCollection() {
        return this.reporterList;
    }

    protected synchronized void saveTest(Test test) {
        this.testList.add(test);
        this.reporterList.forEach(x -> x.onTestStarted(test));
    }

    protected void removeTest(Test test) {
        this.removeTestTestList(test);
        this.removeTestTestAttributeContext(test);
        this.reporterList.forEach(x -> x.onTestRemoved(test));
    }

    private void removeTestTestList(Test test) {
        TestRemover.remove(this.testList, test);
        this.refreshReportEntities();
    }

    private void removeTestTestAttributeContext(Test test) {
        if (TestService.testHasCategory(test).booleanValue()) {
            this.categoryContext.removeTest(test);
        }
        if (TestService.testHasAuthor(test).booleanValue()) {
            this.authorContext.removeTest(test);
        }
        if (TestService.testHasDevice(test).booleanValue()) {
            this.deviceContext.removeTest(test);
        }
    }

    private void refreshReportEntities() {
        this.refreshReportStats();
        this.refreshStatusList();
    }

    private void refreshReportStats() {
        this.stats.refresh(this.testList);
    }

    private synchronized void refreshStatusList() {
        this.statusSet.clear();
        this.refreshStatusList(this.testList);
    }

    private synchronized void refreshStatusList(List<Test> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        list.forEach(x -> {
            boolean bl = this.statusSet.add(x.getStatus());
        });
        list.forEach(x -> this.refreshStatusList(x.getNodeContext().getAll()));
    }

    void addNode(Test node) {
        this.reporterList.forEach(x -> x.onNodeStarted(node));
    }

    void addLog(Test test, Log log) {
        this.reporterList.forEach(x -> x.onLogAdded(test, log));
    }

    void assignCategory(Test test, Category category) {
        this.reporterList.forEach(x -> x.onCategoryAssigned(test, category));
    }

    void assignAuthor(Test test, Author author) {
        this.reporterList.forEach(x -> x.onAuthorAssigned(test, author));
    }

    void assignDevice(Test test, Device device) {
        this.reporterList.forEach(x -> x.onDeviceAssigned(test, device));
    }

    void addScreenCapture(Test test, ScreenCapture screenCapture) throws IOException {
        ScreenCaptureService.resolvePath(screenCapture, this.imagePathResolveDir);
        for (ExtentReporter r : this.reporterList) {
            r.onScreenCaptureAdded(test, screenCapture);
        }
    }

    void addScreenCapture(Log log, ScreenCapture screenCapture) throws IOException {
        ScreenCaptureService.resolvePath(screenCapture, this.imagePathResolveDir);
        for (ExtentReporter r : this.reporterList) {
            r.onScreenCaptureAdded(log, screenCapture);
        }
    }

    protected TestAttributeTestContextStore<Author> getAuthorContextInfo() {
        return this.authorContext;
    }

    private void updateReportStatus(Status status) {
        int reportStatusIndex;
        int statusIndex = Status.getStatusHierarchy().indexOf(status);
        this.reportStatus = statusIndex < (reportStatusIndex = Status.getStatusHierarchy().indexOf(this.reportStatus)) ? status : this.reportStatus;
    }

    private void endTest(Test test) {
        test.end();
        this.updateReportStatus(test.getStatus());
    }

    protected void flush() {
        this.generateRecentStatus();
        this.notifyReporters();
    }

    @Override
    public synchronized void generateRecentStatus() {
        if (this.testList == null || this.testList.isEmpty()) {
            return;
        }
        this.reportEndDate = Calendar.getInstance().getTime();
        this.refreshReportEntities();
        for (Test test : this.testList) {
            this.endTest(test);
            test.setUsesManualConfiguration(this.getAllowManualConfig());
            if (TestService.testHasCategory(test).booleanValue()) {
                test.getCategoryContext().getAll().forEach(x -> this.categoryContext.setAttributeContext((Category)x, test));
            }
            if (TestService.testHasAuthor(test).booleanValue()) {
                test.getAuthorContext().getAll().forEach(x -> this.authorContext.setAttributeContext((Author)x, test));
            }
            if (TestService.testHasDevice(test).booleanValue()) {
                test.getDeviceContext().getAll().forEach(x -> this.deviceContext.setAttributeContext((Device)x, test));
            }
            if (TestService.testHasException(test).booleanValue()) {
                test.getExceptionInfoContext().getAll().forEach(x -> this.exceptionContext.setExceptionContext((ExceptionInfo)x, test));
            }
            if (!TestService.testHasChildren(test).booleanValue()) continue;
            for (Test node : test.getNodeContext().getAll()) {
                this.copyNodeAttributeAndRunTimeInfoToAttributeContexts(node);
                node.setUsesManualConfiguration(this.getAllowManualConfig());
            }
        }
        this.updateReportStartTimeForManualConfigurationSetting();
    }

    private void updateReportStartTimeForManualConfigurationSetting() {
        if (this.getAllowManualConfig() && !this.testList.isEmpty()) {
            Date minDate = this.testList.stream().map(t -> t.getStartTime()).min(Date::compareTo).get();
            Date maxDate = this.testList.stream().map(t -> t.getEndTime()).max(Date::compareTo).get();
            this.reportStartDate = this.reportStartDate.getTime() > minDate.getTime() ? minDate : this.reportStartDate;
            this.reportEndDate = this.reportEndDate.getTime() < maxDate.getTime() ? maxDate : this.reportEndDate;
        }
    }

    private void copyNodeAttributeAndRunTimeInfoToAttributeContexts(Test node) {
        if (TestService.testHasCategory(node).booleanValue()) {
            node.getCategoryContext().getAll().forEach(x -> this.categoryContext.setAttributeContext((Category)x, node));
        }
        if (TestService.testHasAuthor(node).booleanValue()) {
            node.getAuthorContext().getAll().forEach(x -> this.authorContext.setAttributeContext((Author)x, node));
        }
        if (TestService.testHasDevice(node).booleanValue()) {
            node.getDeviceContext().getAll().forEach(x -> this.deviceContext.setAttributeContext((Device)x, node));
        }
        if (TestService.testHasException(node).booleanValue()) {
            node.getExceptionInfoContext().getAll().forEach(x -> this.exceptionContext.setExceptionContext((ExceptionInfo)x, node));
        }
        if (TestService.testHasChildren(node).booleanValue()) {
            node.getNodeContext().getAll().forEach(this::copyNodeAttributeAndRunTimeInfoToAttributeContexts);
        }
    }

    private synchronized void notifyReporters() {
        if (!this.testList.isEmpty() && TestService.isTestBehaviorDriven(this.testList.get(0)).booleanValue()) {
            this.strategy = AnalysisStrategy.BDD;
        }
        ReportAggregates reportAggregates = new ReportAggregatesBuilder().setAuthorContext(this.authorContext).setCategoryContext(this.categoryContext).setDeviceContext(this.deviceContext).setExceptionContext(this.exceptionContext).setReportStatusStats(this.stats).setStatusCollection(this.statusSet).setSystemAttributeContext(this.systemAttributeContext).setTestList(this.testList).setTestRunnerLogs(this.testRunnerLogs).setStartTime(this.reportStartDate).setEndTime(this.reportEndDate).build();
        this.reporterList.forEach(x -> x.setAnalysisStrategy(this.strategy));
        this.reporterList.forEach(x -> x.flush(reportAggregates));
    }

    protected void end() {
        this.flush();
        this.reporterList.forEach(ExtentReporter::stop);
        this.reporterList.clear();
    }

    protected void setSystemInfo(SystemAttribute sa) {
        this.systemAttributeContext.setSystemAttribute(sa);
    }

    protected void setTestRunnerLogs(String log) {
        this.testRunnerLogs.add(log);
    }

    protected void setAnalysisStrategy(AnalysisStrategy strategy) {
        this.strategy = strategy;
        this.stats = new ReportStatusStats(strategy);
    }

    protected void setImagePathResolveDir(String[] imagePathResolveDir) {
        this.imagePathResolveDir = imagePathResolveDir;
    }

    protected void setAllowManualConfig(boolean useManualConfig) {
        this.usesManualConfiguration = useManualConfig;
    }

    protected boolean getAllowManualConfig() {
        return this.usesManualConfiguration;
    }

    protected ReportStatusStats getStats() {
        this.generateRecentStatus();
        return this.stats;
    }
}

