/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.reporter.ConfigurableReporter;
import com.aventstack.extentreports.templating.FreemarkerTemplate;
import com.aventstack.extentreports.templating.TemplateConfig;
import com.aventstack.extentreports.utils.FileUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

public abstract class BasicFileReporter
extends ConfigurableReporter {
    private static final Logger logger = Logger.getLogger(BasicFileReporter.class.getName());
    private static final String DEFAULT_MEDIA_SAVE_PROPERTY_NAME = "autoCreateRelativePathMedia";
    private static final String TEMPLATE_LOCATION = "view/";
    private static String encoding = "UTF-8";
    private String filePath;
    private String destination;
    private Map<String, Object> templateModel;
    private String source;
    private Configuration freemarkerConfig;

    protected BasicFileReporter(File f) {
        this.filePath = f.getAbsolutePath();
        File parentFile = f.isDirectory() || FileUtil.getExtension(f).isEmpty() ? f : f.getParentFile();
        this.destination = parentFile == null ? "" : String.valueOf(parentFile.getAbsolutePath()) + "/";
        File destinationFile = new File(this.destination);
        if (!destinationFile.exists()) {
            destinationFile.mkdirs();
        }
    }

    protected BasicFileReporter(String path) {
        this(new File(path));
    }

    protected void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public File getFileFile() {
        return new File(this.filePath);
    }

    public String getDestinationPath() {
        return this.destination;
    }

    @Override
    public void start() {
        throw new Error("Unresolved compilation problem: \n\tVERSION_2_3_29 cannot be resolved or is not a field\n");
    }

    @Override
    public synchronized void flush(ReportAggregates reportAggregates) {
        super.flush(reportAggregates);
    }

    @Override
    public void onScreenCaptureAdded(Test test, ScreenCapture screenCapture) throws IOException {
        this.onScreenCaptureAdded(screenCapture);
    }

    @Override
    public void onScreenCaptureAdded(Log log, ScreenCapture screenCapture) throws IOException {
        this.onScreenCaptureAdded(screenCapture);
    }

    private void onScreenCaptureAdded(ScreenCapture screenCapture) throws IOException {
        if (this.getConfigurationStore() == null) {
            return;
        }
        String autoCreateRelativePathMedia = (String)this.getConfigurationStore().getConfig(DEFAULT_MEDIA_SAVE_PROPERTY_NAME);
        if (autoCreateRelativePathMedia != null && Boolean.valueOf(autoCreateRelativePathMedia).booleanValue()) {
            this.autoCreateRelativePathMedia(screenCapture, Boolean.valueOf(autoCreateRelativePathMedia), this.destination);
        }
    }

    public boolean containsStatus(String status) {
        Status s = Status.valueOf(status.toUpperCase());
        return this.containsStatus(s);
    }

    public boolean containsStatus(Status status) {
        return this.getStatusCollection() != null && this.getStatusCollection().contains(status);
    }

    protected void processTemplate(Template template, File outputFile) throws TemplateException, IOException {
        FreemarkerTemplate freemarkerTemplate = new FreemarkerTemplate(this.getFreemarkerConfig());
        freemarkerTemplate.writeTemplate(template, this.templateModel, outputFile);
    }

    protected String getSource() {
        return this.source;
    }

    protected Configuration getFreemarkerConfig() {
        if (this.freemarkerConfig == null) {
            TemplateConfig freemarkerConfig = new TemplateConfig();
            this.freemarkerConfig = freemarkerConfig.getFreemarkerConfig(ExtentReports.class, TEMPLATE_LOCATION, encoding);
        }
        return this.freemarkerConfig;
    }

    protected Boolean enforceOfflineMode() {
        if (this.getConfigurationStore().containsConfig("enableOfflineMode")) {
            String offlineMode = String.valueOf(this.getConfigurationStore().containsConfig("enableOfflineMode"));
            if (!this.getConfigurationStore().containsConfig("offlineDirectory") && offlineMode.equals("true")) {
                return true;
            }
        }
        return false;
    }
}

