/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.AbstractProcessor;
import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.AnalysisTypeConfigurable;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.Writable;
import com.aventstack.extentreports.gherkin.GherkinDialectManager;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.model.ReportStats;
import com.aventstack.extentreports.model.SystemEnvInfo;
import com.aventstack.extentreports.model.service.TestService;
import com.aventstack.extentreports.observer.ExtentObserver;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

public class ExtentReports
extends AbstractProcessor
implements Writable,
AnalysisTypeConfigurable {
    public void attachReporter(ExtentObserver ... observer) {
        this.attachReporter(Arrays.asList(observer));
    }

    public ExtentTest createTest(Class<? extends IGherkinFormatterModel> type, String name, String description) {
        ExtentTest t = new ExtentTest(this, type, name, description);
        this.onTestCreated(t.getModel());
        return t;
    }

    public ExtentTest createTest(Class<? extends IGherkinFormatterModel> type, String name) {
        return this.createTest(type, name, null);
    }

    public ExtentTest createTest(GherkinKeyword gherkinKeyword, String name, String description) {
        Class<?> clazz = gherkinKeyword.getKeyword().getClass();
        return this.createTest(clazz, name, description);
    }

    public ExtentTest createTest(GherkinKeyword gherkinKeyword, String testName) {
        return this.createTest(gherkinKeyword, testName, null);
    }

    public ExtentTest createTest(String name, String description) {
        ExtentTest t = new ExtentTest(this, name, description);
        this.onTestCreated(t.getModel());
        return t;
    }

    public ExtentTest createTest(String name) {
        return this.createTest(name, null);
    }

    public void removeTest(ExtentTest test) {
        this.onTestRemoved(test.getModel());
    }

    public void removeTest(String name) {
        TestService.findTest(this.getReport().getTestList(), name).ifPresent(this::onTestRemoved);
    }

    @Override
    public void flush() {
        this.onFlush();
    }

    public void setSystemInfo(String k, String v) {
        this.onSystemInfoAdded(new SystemEnvInfo(k, v));
    }

    public void addTestRunnerOutput(List<String> log) {
        log.forEach(this::addTestRunnerOutput);
    }

    public void addTestRunnerOutput(String log) {
        this.onReportLogAdded(log);
    }

    public ExtentReports tryResolveMediaPath(String[] path) {
        this.setMediaResolverPath(path);
        return this;
    }

    public void createDomainFromJsonArchive(File jsonFile) throws IOException {
        this.convertRawEntities(this, jsonFile);
    }

    public void createDomainFromJsonArchive(String jsonFilePath) throws IOException {
        this.createDomainFromJsonArchive(new File(jsonFilePath));
    }

    public void setReportUsesManualConfiguration(boolean useManualConfig) {
        this.setUsingNaturalConf(!useManualConfig);
    }

    @Override
    public void setAnalysisStrategy(AnalysisStrategy strategy) {
        this.getReport().getStats().setAnalysisStrategy(strategy);
    }

    public void setGherkinDialect(String language) throws UnsupportedEncodingException {
        GherkinDialectManager.setLanguage(language);
    }

    public ReportStats getStats() {
        return this.getReport().getStats();
    }
}

