/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.RunResult;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.service.ExceptionInfoService;
import java.io.Serializable;
import java.util.Arrays;
import lombok.Generated;

public class ExtentTest
implements RunResult,
Serializable {
    private static final long serialVersionUID = 5846031786305901993L;
    private transient ExtentReports extent;
    private Test model;

    ExtentTest(ExtentReports extent, Class<? extends IGherkinFormatterModel> type, String name, String description) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Test name cannot be null or empty");
        }
        this.model = Test.builder().bddType(type).name(name).description(description).useNaturalConf(extent.isUsingNaturalConf()).build();
        this.extent = extent;
    }

    ExtentTest(ExtentReports extent, String testName, String description) {
        this(extent, null, testName, description);
    }

    public synchronized ExtentTest createNode(Class<? extends IGherkinFormatterModel> type, String name, String description) {
        ExtentTest t = new ExtentTest(this.extent, type, name, description);
        this.model.addChild(t.getModel());
        this.extent.onNodeCreated(t.getModel());
        return t;
    }

    public synchronized ExtentTest createNode(String name, String description) {
        ExtentTest t = new ExtentTest(this.extent, name, description);
        this.model.addChild(t.getModel());
        this.extent.onNodeCreated(t.getModel());
        return t;
    }

    public ExtentTest createNode(Class<? extends IGherkinFormatterModel> type, String name) {
        return this.createNode(type, name, null);
    }

    public ExtentTest createNode(GherkinKeyword gherkinKeyword, String name, String description) {
        return this.createNode(gherkinKeyword.getKeyword().getClass(), name, description);
    }

    public ExtentTest createNode(GherkinKeyword gherkinKeyword, String name) {
        return this.createNode(gherkinKeyword, name, null);
    }

    public ExtentTest createNode(String name) {
        return this.createNode(name, null);
    }

    public ExtentTest generateLog(Status status, String details) {
        Log log = Log.builder().status(status).details(details).build();
        this.model.addGeneratedLog(log);
        return this;
    }

    public ExtentTest generateLog(Status status, Markup markup) {
        return this.generateLog(status, markup.getMarkup());
    }

    public ExtentTest log(Status status, String details, Throwable t, Media media) {
        if (status == null) {
            throw new IllegalArgumentException("Status must not be null");
        }
        Log log = Log.builder().status(status).details(details == null ? "" : details).build();
        ExceptionInfo exceptionInfo = ExceptionInfoService.createExceptionInfo(t);
        log.setException(exceptionInfo);
        log.addMedia(media);
        if (exceptionInfo != null) {
            this.model.getExceptions().add(exceptionInfo);
        }
        this.model.addLog(log);
        this.extent.onLogCreated(log, this.model);
        return this;
    }

    public ExtentTest log(Status status, String details, Media media) {
        return this.log(status, details, null, media);
    }

    public ExtentTest log(Status status, Media media) {
        return this.log(status, null, null, media);
    }

    public ExtentTest log(Status status, String details) {
        return this.log(status, details, null);
    }

    public ExtentTest log(Status status, Markup markup) {
        String details = markup.getMarkup();
        return this.log(status, details);
    }

    public ExtentTest log(Status status, Throwable t, Media media) {
        return this.log(status, null, t, media);
    }

    public ExtentTest log(Status status, Throwable t) {
        return this.log(status, t, null);
    }

    public ExtentTest info(String details, Media media) {
        this.log(Status.INFO, details, media);
        return this;
    }

    public ExtentTest info(String details) {
        return this.info(details, null);
    }

    public ExtentTest info(Throwable t, Media media) {
        this.log(Status.INFO, t, media);
        return this;
    }

    public ExtentTest info(Throwable t) {
        return this.info(t, null);
    }

    public ExtentTest info(Markup m) {
        this.log(Status.INFO, m);
        return this;
    }

    public ExtentTest info(Media media) {
        this.log(Status.INFO, media);
        return this;
    }

    public ExtentTest pass(String details, Media media) {
        this.log(Status.PASS, details, media);
        return this;
    }

    public ExtentTest pass(String details) {
        return this.pass(details, null);
    }

    public ExtentTest pass(Throwable t, Media media) {
        this.log(Status.PASS, t, media);
        return this;
    }

    public ExtentTest pass(Throwable t) {
        return this.pass(t, null);
    }

    public ExtentTest pass(Markup m) {
        this.log(Status.PASS, m);
        return this;
    }

    public ExtentTest pass(Media media) {
        this.log(Status.PASS, media);
        return this;
    }

    public ExtentTest fail(String details, Media media) {
        this.log(Status.FAIL, details, media);
        return this;
    }

    public ExtentTest fail(String details) {
        return this.fail(details, null);
    }

    public ExtentTest fail(Throwable t, Media media) {
        this.log(Status.FAIL, t, media);
        return this;
    }

    public ExtentTest fail(Throwable t) {
        return this.fail(t, null);
    }

    public ExtentTest fail(Markup m) {
        this.log(Status.FAIL, m);
        return this;
    }

    public ExtentTest fail(Media media) {
        this.log(Status.FAIL, media);
        return this;
    }

    public ExtentTest warning(String details, Media media) {
        this.log(Status.WARNING, details, media);
        return this;
    }

    public ExtentTest warning(String details) {
        return this.warning(details, null);
    }

    public ExtentTest warning(Throwable t, Media media) {
        this.log(Status.WARNING, t, media);
        return this;
    }

    public ExtentTest warning(Throwable t) {
        return this.warning(t, null);
    }

    public ExtentTest warning(Markup m) {
        this.log(Status.WARNING, m);
        return this;
    }

    public ExtentTest warning(Media media) {
        this.log(Status.WARNING, media);
        return this;
    }

    public ExtentTest skip(String details, Media media) {
        this.log(Status.SKIP, details, media);
        return this;
    }

    public ExtentTest skip(String details) {
        return this.skip(details, null);
    }

    public ExtentTest skip(Throwable t, Media media) {
        this.log(Status.SKIP, t, media);
        return this;
    }

    public ExtentTest skip(Throwable t) {
        return this.skip(t, null);
    }

    public ExtentTest skip(Markup m) {
        this.log(Status.SKIP, m);
        return this;
    }

    public ExtentTest skip(Media media) {
        this.log(Status.SKIP, media);
        return this;
    }

    public ExtentTest assignCategory(String ... category) {
        if (category == null || category.length == 0) {
            return this;
        }
        Arrays.stream(category).forEach(x -> {
            Category c = new Category(x.replaceAll("\\s+", ""));
            this.model.getCategorySet().add(c);
            this.extent.onCategoryAdded(c, this.model);
        });
        return this;
    }

    public ExtentTest assignAuthor(String ... author) {
        if (author == null || author.length == 0) {
            return this;
        }
        Arrays.stream(author).forEach(x -> {
            Author a = new Author(x.replaceAll("\\s+", ""));
            this.model.getAuthorSet().add(a);
            this.extent.onAuthorAdded(a, this.model);
        });
        return this;
    }

    public ExtentTest assignDevice(String ... device) {
        if (device == null || device.length == 0) {
            return this;
        }
        Arrays.stream(device).forEach(x -> {
            Device d = new Device(x.replaceAll("\\s+", ""));
            this.model.getDeviceSet().add(d);
            this.extent.onDeviceAdded(d, this.model);
        });
        return this;
    }

    @Override
    public Status getStatus() {
        return this.model.getStatus();
    }

    public ExtentTest addScreenCaptureFromPath(String path, String title) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("ScreenCapture path cannot be null or empty");
        }
        ScreenCapture m = ScreenCapture.builder().path(path).title(title).build();
        this.model.addMedia(m);
        this.extent.onMediaAdded((Media)m, this.model);
        return this;
    }

    public ExtentTest addScreenCaptureFromPath(String path) {
        return this.addScreenCaptureFromPath(path, null);
    }

    public ExtentTest addScreenCaptureFromBase64String(String base64, String title) {
        if (base64 == null || base64.isEmpty()) {
            throw new IllegalArgumentException("Base64 string cannot be null or empty");
        }
        if (!base64.startsWith("data:")) {
            base64 = "data:image/png;base64," + base64;
        }
        ScreenCapture m = ScreenCapture.builder().base64(base64).title(title).build();
        this.model.addMedia(m);
        this.extent.onMediaAdded((Media)m, this.model);
        return this;
    }

    public ExtentTest addScreenCaptureFromBase64String(String base64) {
        return this.addScreenCaptureFromBase64String(base64, null);
    }

    @Generated
    public ExtentReports getExtent() {
        return this.extent;
    }

    @Generated
    public Test getModel() {
        return this.model;
    }
}

