/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncBufferedResponse;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncResponse;
import com.azure.core.http.okhttp.implementation.OkHttpFileRequestBody;
import com.azure.core.http.okhttp.implementation.OkHttpFluxRequestBody;
import com.azure.core.http.okhttp.implementation.OkHttpInputStreamRequestBody;
import com.azure.core.http.okhttp.implementation.OkHttpProgressReportingRequestBody;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.ByteArrayContent;
import com.azure.core.implementation.util.FileContent;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.implementation.util.SerializableContent;
import com.azure.core.implementation.util.StringContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class OkHttpAsyncHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpAsyncHttpClient.class);
    private static final RequestBody EMPTY_REQUEST_BODY = RequestBody.create((byte[])new byte[0]);
    final OkHttpClient httpClient;

    OkHttpAsyncHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)"azure-eagerly-read-response").orElse(false);
        ProgressReporter progressReporter = Contexts.with((Context)context).getHttpRequestProgressReporter();
        return Mono.create(sink -> sink.onRequest(value -> Mono.fromCallable(() -> this.toOkHttpRequest(request, progressReporter)).subscribe(okHttpRequest -> {
            try {
                Call call = this.httpClient.newCall(okHttpRequest);
                call.enqueue((Callback)new OkHttpCallback((MonoSink<HttpResponse>)sink, request, eagerlyReadResponse));
                sink.onCancel(() -> ((Call)call).cancel());
            }
            catch (Exception ex) {
                sink.error((Throwable)ex);
            }
        }, arg_0 -> ((MonoSink)sink).error(arg_0))));
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)"azure-eagerly-read-response").orElse(false);
        ProgressReporter progressReporter = Contexts.with((Context)context).getHttpRequestProgressReporter();
        Request okHttpRequest = this.toOkHttpRequest(request, progressReporter);
        try {
            Response okHttpResponse = this.httpClient.newCall(okHttpRequest).execute();
            return OkHttpAsyncHttpClient.toHttpResponse(request, okHttpResponse, eagerlyReadResponse);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    private Request toOkHttpRequest(HttpRequest request, ProgressReporter progressReporter) {
        Request.Builder requestBuilder = new Request.Builder().url(request.getUrl());
        if (request.getHeaders() != null) {
            for (HttpHeader hdr : request.getHeaders()) {
                hdr.getValuesList().forEach(value -> requestBuilder.addHeader(hdr.getName(), value));
            }
        }
        if (request.getHttpMethod() == HttpMethod.GET) {
            return requestBuilder.get().build();
        }
        if (request.getHttpMethod() == HttpMethod.HEAD) {
            return requestBuilder.head().build();
        }
        RequestBody okHttpRequestBody = this.toOkHttpRequestBody(request.getBodyAsBinaryData(), request.getHeaders());
        if (progressReporter != null) {
            okHttpRequestBody = new OkHttpProgressReportingRequestBody(okHttpRequestBody, progressReporter);
        }
        return requestBuilder.method(request.getHttpMethod().toString(), okHttpRequestBody).build();
    }

    private RequestBody toOkHttpRequestBody(BinaryData bodyContent, HttpHeaders headers) {
        if (bodyContent == null) {
            return EMPTY_REQUEST_BODY;
        }
        String contentType = headers.getValue("Content-Type");
        MediaType mediaType = contentType == null ? null : MediaType.parse((String)contentType);
        BinaryDataContent content = BinaryDataHelper.getContent((BinaryData)bodyContent);
        if (content instanceof ByteArrayContent || content instanceof StringContent || content instanceof SerializableContent) {
            return RequestBody.create((byte[])content.toBytes(), (MediaType)mediaType);
        }
        long effectiveContentLength = OkHttpAsyncHttpClient.getRequestContentLength(content, headers);
        if (content instanceof InputStreamContent) {
            return new OkHttpInputStreamRequestBody((InputStreamContent)content, effectiveContentLength, mediaType);
        }
        if (content instanceof FileContent) {
            return new OkHttpFileRequestBody((FileContent)content, effectiveContentLength, mediaType);
        }
        return new OkHttpFluxRequestBody(content, effectiveContentLength, mediaType, this.httpClient.callTimeoutMillis());
    }

    private static long getRequestContentLength(BinaryDataContent content, HttpHeaders headers) {
        Long contentLength = content.getLength();
        if (contentLength == null) {
            String contentLengthHeaderValue = headers.getValue("Content-Length");
            contentLength = contentLengthHeaderValue != null ? Long.valueOf(Long.parseLong(contentLengthHeaderValue)) : Long.valueOf(-1L);
        }
        return contentLength;
    }

    private static HttpResponse toHttpResponse(HttpRequest request, Response response, boolean eagerlyReadResponse) throws IOException {
        if (eagerlyReadResponse) {
            try (ResponseBody body = response.body();){
                if (Objects.nonNull(body)) {
                    byte[] bytes = body.bytes();
                    OkHttpAsyncBufferedResponse okHttpAsyncBufferedResponse = new OkHttpAsyncBufferedResponse(response, request, bytes);
                    return okHttpAsyncBufferedResponse;
                }
                OkHttpAsyncResponse okHttpAsyncResponse = new OkHttpAsyncResponse(response, request);
                return okHttpAsyncResponse;
            }
        }
        return new OkHttpAsyncResponse(response, request);
    }

    private static class OkHttpCallback
    implements Callback {
        private final MonoSink<HttpResponse> sink;
        private final HttpRequest request;
        private final boolean eagerlyReadResponse;

        OkHttpCallback(MonoSink<HttpResponse> sink, HttpRequest request, boolean eagerlyReadResponse) {
            this.sink = sink;
            this.request = request;
            this.eagerlyReadResponse = eagerlyReadResponse;
        }

        public void onFailure(Call call, IOException e) {
            if (e.getSuppressed().length == 1) {
                this.sink.error(e.getSuppressed()[0]);
            } else {
                this.sink.error((Throwable)e);
            }
        }

        public void onResponse(Call call, Response response) {
            try {
                HttpResponse httpResponse = OkHttpAsyncHttpClient.toHttpResponse(this.request, response, this.eagerlyReadResponse);
                this.sink.success((Object)httpResponse);
            }
            catch (IOException ex) {
                this.sink.error((Throwable)ex);
            }
        }
    }
}

