/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.util.Context;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventDataBatch;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsMetricsProvider;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsTracer;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

class EventHubsProducerInstrumentation {
    private final EventHubsTracer tracer;
    private final EventHubsMetricsProvider meter;

    EventHubsProducerInstrumentation(Tracer tracer, Meter meter, String fullyQualifiedName, String entityName) {
        this.tracer = new EventHubsTracer(tracer, fullyQualifiedName, entityName);
        this.meter = new EventHubsMetricsProvider(meter, fullyQualifiedName, entityName, null);
    }

    <T> Mono<T> onSendBatch(Mono<T> publisher, EventDataBatch batch, String spanName) {
        if (!this.tracer.isEnabled() && !this.meter.isSendCountEnabled()) {
            return publisher;
        }
        if (this.tracer.isEnabled()) {
            return publisher.doOnEach(signal -> {
                if (signal.isOnComplete() || signal.isOnError()) {
                    Context span = (Context)signal.getContextView().getOrDefault((Object)"otel-context-key", (Object)Context.NONE);
                    this.meter.reportBatchSend(batch.getCount(), batch.getPartitionId(), signal.getThrowable(), span);
                    this.tracer.endSpan(signal.getThrowable(), span, null);
                }
            }).contextWrite((ContextView)reactor.util.context.Context.of((Object)"otel-context-key", (Object)this.startSpanWithLinks(spanName, batch, Context.NONE)));
        }
        return publisher.doOnEach(signal -> {
            if (signal.isOnComplete() || signal.isOnError()) {
                this.meter.reportBatchSend(batch.getCount(), batch.getPartitionId(), signal.getThrowable(), Context.NONE);
            }
        });
    }

    public EventHubsTracer getTracer() {
        return this.tracer;
    }

    private Context startSpanWithLinks(String name, EventDataBatch batch, Context context) {
        Context spanBuilder = this.tracer.getBuilder(name, context);
        if (batch != null) {
            for (EventData event : batch.getEvents()) {
                this.tracer.addLink(event.getProperties(), null, spanBuilder, event.getContext());
            }
        }
        return this.tracer.startSpan(name, spanBuilder, ProcessKind.SEND);
    }
}

