/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.implementation.AmqpChannelProcessor;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.messaging.eventhubs.implementation.EventHubAmqpConnection;
import com.azure.messaging.eventhubs.implementation.EventHubManagementNode;
import java.util.Collections;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class EventHubConnectionProcessor
extends AmqpChannelProcessor<EventHubAmqpConnection> {
    private final String fullyQualifiedNamespace;
    private final String eventHubName;
    private final AmqpRetryOptions retryOptions;

    public EventHubConnectionProcessor(String fullyQualifiedNamespace, String eventHubName, AmqpRetryOptions retryOptions) {
        super(fullyQualifiedNamespace, channel -> channel.getEndpointStates(), RetryUtil.getRetryPolicy((AmqpRetryOptions)retryOptions), Collections.singletonMap("entityPath", eventHubName));
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.eventHubName = Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
    }

    public String getFullyQualifiedNamespace() {
        return this.fullyQualifiedNamespace;
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    public AmqpRetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public Mono<EventHubManagementNode> getManagementNodeWithRetries() {
        return RetryUtil.withRetry((Mono)this.flatMap(connection -> connection.getManagementNode()), (AmqpRetryOptions)this.retryOptions, (String)"Time out creating management node.");
    }
}

