/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation.instrumentation;

import com.azure.core.util.Context;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsMetricsProvider;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsTracer;
import com.azure.messaging.eventhubs.implementation.instrumentation.InstrumentationUtils;
import java.time.Instant;
import java.util.function.BiConsumer;

public final class InstrumentationScope
implements AutoCloseable {
    private final EventHubsMetricsProvider meter;
    private final EventHubsTracer tracer;
    private final boolean isEnabled;
    private final BiConsumer<EventHubsMetricsProvider, InstrumentationScope> reportMetricsCallback;
    private Instant startTime;
    private Throwable error;
    private String errorType;
    private Context span = Context.NONE;
    private AutoCloseable spanScope;
    private volatile boolean closed = false;

    public InstrumentationScope(EventHubsTracer tracer, EventHubsMetricsProvider meter, BiConsumer<EventHubsMetricsProvider, InstrumentationScope> reportMetricsCallback) {
        this.tracer = tracer;
        this.meter = meter;
        boolean bl = this.isEnabled = tracer != null && tracer.isEnabled() || meter != null && meter.isEnabled();
        if (meter != null && meter.isEnabled()) {
            this.startTime = Instant.now();
        }
        this.reportMetricsCallback = reportMetricsCallback;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public InstrumentationScope setError(Throwable error) {
        if (this.isEnabled) {
            this.error = error;
        }
        return this;
    }

    public InstrumentationScope setSpan(Context span) {
        if (this.isEnabled) {
            this.span = span;
        }
        return this;
    }

    public InstrumentationScope setCancelled() {
        if (this.isEnabled && this.error == null) {
            this.errorType = "cancelled";
        }
        return this;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Context getSpan() {
        return this.span;
    }

    public Throwable getError() {
        return this.error;
    }

    public String getErrorType() {
        if (this.errorType == null) {
            this.errorType = InstrumentationUtils.getErrorType(this.error);
        }
        return this.errorType;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.meter != null && this.reportMetricsCallback != null) {
                this.reportMetricsCallback.accept(this.meter, this);
            }
            if (this.tracer != null) {
                this.tracer.endSpan(this.errorType, this.error, this.span, this.spanScope);
            }
        }
    }

    InstrumentationScope makeSpanCurrent() {
        if (this.tracer != null && this.tracer.isEnabled()) {
            this.spanScope = this.tracer.makeSpanCurrent(this.span);
        }
        return this;
    }
}

