/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.Algorithm;
import com.azure.security.keyvault.keys.cryptography.AlgorithmResolver;
import com.azure.security.keyvault.keys.cryptography.AsymmetricSignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.Ecdsa;
import com.azure.security.keyvault.keys.cryptography.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.ISignatureTransform;
import com.azure.security.keyvault.keys.cryptography.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.SignatureHashResolver;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import reactor.core.publisher.Mono;

class EcKeyCryptographyClient
extends LocalKeyCryptographyClient {
    private static final ClientLogger LOGGER = new ClientLogger(EcKeyCryptographyClient.class);
    private final CryptographyClientImpl serviceClient;
    private final Provider provider;
    private KeyPair keyPair;

    EcKeyCryptographyClient(CryptographyClientImpl serviceClient) {
        super(serviceClient);
        this.serviceClient = serviceClient;
        this.provider = null;
    }

    EcKeyCryptographyClient(JsonWebKey key, CryptographyClientImpl serviceClient) {
        super(serviceClient);
        this.provider = Security.getProvider("SunEC");
        this.keyPair = key.toEc(key.hasPrivateKey(), this.provider);
        this.serviceClient = serviceClient;
    }

    private KeyPair getKeyPair(JsonWebKey key) {
        if (this.keyPair == null) {
            this.keyPair = key.toEc(key.hasPrivateKey());
        }
        return this.keyPair;
    }

    @Override
    Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, JsonWebKey key, Context context) {
        return Mono.error((Throwable)new UnsupportedOperationException("Encrypt operation is not supported for EC key"));
    }

    @Override
    EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, JsonWebKey key, Context context) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Encrypt operation is not supported for EC key"));
    }

    @Override
    Mono<EncryptResult> encryptAsync(EncryptParameters options, JsonWebKey key, Context context) {
        return Mono.error((Throwable)new UnsupportedOperationException("Encrypt operation is not supported for EC key"));
    }

    @Override
    EncryptResult encrypt(EncryptParameters options, JsonWebKey key, Context context) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Encrypt operation is not supported for EC key"));
    }

    @Override
    Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, JsonWebKey key, Context context) {
        return Mono.error((Throwable)new UnsupportedOperationException("Encrypt operation is not supported for EC key"));
    }

    @Override
    DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] plaintext, JsonWebKey key, Context context) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Encrypt operation is not supported for EC key"));
    }

    @Override
    Mono<DecryptResult> decryptAsync(DecryptParameters options, JsonWebKey key, Context context) {
        return Mono.error((Throwable)new UnsupportedOperationException("Decrypt operation is not supported for EC key"));
    }

    @Override
    DecryptResult decrypt(DecryptParameters options, JsonWebKey key, Context context) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Decrypt operation is not supported for EC key"));
    }

    @Override
    Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, JsonWebKey key, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        this.keyPair = this.getKeyPair(key);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.signAsync(algorithm, digest, context);
            }
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.keyPair.getPrivate() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.signAsync(algorithm, digest, context);
            }
            return Mono.error((Throwable)new IllegalArgumentException("Private portion of the key not available to perform sign operation"));
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair, this.provider);
        try {
            return Mono.just((Object)new SignResult(signer.sign(digest), algorithm, key.getId()));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    SignResult sign(SignatureAlgorithm algorithm, byte[] digest, JsonWebKey key, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        this.keyPair = this.getKeyPair(key);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.sign(algorithm, digest, context);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (this.keyPair.getPrivate() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.sign(algorithm, digest, context);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Private portion of the key not available to perform sign operation"));
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair, this.provider);
        try {
            return new SignResult(signer.sign(digest), algorithm, key.getId());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, JsonWebKey key, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        this.keyPair = this.getKeyPair(key);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.verifyAsync(algorithm, digest, signature, context);
            }
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.keyPair.getPublic() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.verifyAsync(algorithm, digest, signature, context);
            }
            return Mono.error((Throwable)new IllegalArgumentException("Public portion of the key not available to perform verify operation"));
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair, this.provider);
        try {
            return Mono.just((Object)new VerifyResult(signer.verify(digest, signature), algorithm, key.getId()));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, JsonWebKey key, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        this.keyPair = this.getKeyPair(key);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.verify(algorithm, digest, signature, context);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (!(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (this.keyPair.getPublic() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.verify(algorithm, digest, signature, context);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Public portion of the key not available to perform verify operation"));
        }
        if (!(baseAlgorithm instanceof Ecdsa)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        Ecdsa algo = (Ecdsa)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair, this.provider);
        try {
            return new VerifyResult(signer.verify(digest, signature), algorithm, key.getId());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] key, JsonWebKey webKey, Context context) {
        return Mono.error((Throwable)new UnsupportedOperationException("Wrap key operation is not supported for EC key"));
    }

    @Override
    WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key, JsonWebKey webKey, Context context) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Wrap key operation is not supported for EC key"));
    }

    @Override
    Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, JsonWebKey key, Context context) {
        return Mono.error((Throwable)new UnsupportedOperationException("Unwrap key operation is not supported for EC key"));
    }

    @Override
    UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, JsonWebKey key, Context context) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Unwrap key operation is not supported for EC key"));
    }

    @Override
    Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, JsonWebKey key, Context context) {
        try {
            return this.signAsync(algorithm, this.calculateDigest(algorithm, data), key, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    SignResult signData(SignatureAlgorithm algorithm, byte[] data, JsonWebKey key, Context context) {
        try {
            return this.sign(algorithm, this.calculateDigest(algorithm, data), key, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, JsonWebKey key, Context context) {
        try {
            return this.verifyAsync(algorithm, this.calculateDigest(algorithm, data), signature, key, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, JsonWebKey key, Context context) {
        try {
            return this.verify(algorithm, this.calculateDigest(algorithm, data), signature, key, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private byte[] calculateDigest(SignatureAlgorithm algorithm, byte[] data) throws NoSuchAlgorithmException {
        HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
        MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
        md.update(data);
        return md.digest();
    }

    private boolean serviceClientAvailable() {
        return this.serviceClient != null;
    }
}

