/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

@JacksonXmlRootElement(localName="null")
public final class SharesGetPropertiesHeaders {
    @JsonProperty(value="x-ms-share-provisioned-iops")
    private Integer xMsShareProvisionedIops;
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType xMsLeaseStatus;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType xMsLeaseState;
    @JsonProperty(value="x-ms-root-squash")
    private ShareRootSquash xMsRootSquash;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-access-tier-change-time")
    private DateTimeRfc1123 xMsAccessTierChangeTime;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> xMsMeta;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-share-provisioned-ingress-mbps")
    private Integer xMsShareProvisionedIngressMbps;
    @JsonProperty(value="x-ms-share-provisioned-bandwidth-mibps")
    private Integer xMsShareProvisionedBandwidthMibps;
    @JsonProperty(value="x-ms-share-quota")
    private Integer xMsShareQuota;
    @JsonProperty(value="x-ms-access-tier")
    private String xMsAccessTier;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="x-ms-enabled-protocols")
    private String xMsEnabledProtocols;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType xMsLeaseDuration;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-access-tier-transition-state")
    private String xMsAccessTierTransitionState;
    @JsonProperty(value="x-ms-share-provisioned-egress-mbps")
    private Integer xMsShareProvisionedEgressMbps;
    @JsonProperty(value="x-ms-share-next-allowed-quota-downgrade-time")
    private DateTimeRfc1123 xMsShareNextAllowedQuotaDowngradeTime;

    public SharesGetPropertiesHeaders(HttpHeaders rawHeaders) {
        if (rawHeaders.getValue("x-ms-share-provisioned-iops") != null) {
            this.xMsShareProvisionedIops = Integer.parseInt(rawHeaders.getValue("x-ms-share-provisioned-iops"));
        }
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        if (rawHeaders.getValue("x-ms-lease-status") != null) {
            this.xMsLeaseStatus = LeaseStatusType.fromString(rawHeaders.getValue("x-ms-lease-status"));
        }
        if (rawHeaders.getValue("x-ms-lease-state") != null) {
            this.xMsLeaseState = LeaseStateType.fromString(rawHeaders.getValue("x-ms-lease-state"));
        }
        if (rawHeaders.getValue("x-ms-root-squash") != null) {
            this.xMsRootSquash = ShareRootSquash.fromString(rawHeaders.getValue("x-ms-root-squash"));
        }
        if (rawHeaders.getValue("Last-Modified") != null) {
            this.lastModified = new DateTimeRfc1123(rawHeaders.getValue("Last-Modified"));
        }
        if (rawHeaders.getValue("x-ms-access-tier-change-time") != null) {
            this.xMsAccessTierChangeTime = new DateTimeRfc1123(rawHeaders.getValue("x-ms-access-tier-change-time"));
        }
        HashMap<String, String> xMsMetaHeaderCollection = new HashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            if (!header.getName().startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(header.getName().substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
        if (rawHeaders.getValue("Date") != null) {
            this.dateProperty = new DateTimeRfc1123(rawHeaders.getValue("Date"));
        }
        if (rawHeaders.getValue("x-ms-share-provisioned-ingress-mbps") != null) {
            this.xMsShareProvisionedIngressMbps = Integer.parseInt(rawHeaders.getValue("x-ms-share-provisioned-ingress-mbps"));
        }
        if (rawHeaders.getValue("x-ms-share-provisioned-bandwidth-mibps") != null) {
            this.xMsShareProvisionedBandwidthMibps = Integer.parseInt(rawHeaders.getValue("x-ms-share-provisioned-bandwidth-mibps"));
        }
        if (rawHeaders.getValue("x-ms-share-quota") != null) {
            this.xMsShareQuota = Integer.parseInt(rawHeaders.getValue("x-ms-share-quota"));
        }
        this.xMsAccessTier = rawHeaders.getValue("x-ms-access-tier");
        this.eTag = rawHeaders.getValue("ETag");
        this.xMsEnabledProtocols = rawHeaders.getValue("x-ms-enabled-protocols");
        if (rawHeaders.getValue("x-ms-lease-duration") != null) {
            this.xMsLeaseDuration = LeaseDurationType.fromString(rawHeaders.getValue("x-ms-lease-duration"));
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.xMsAccessTierTransitionState = rawHeaders.getValue("x-ms-access-tier-transition-state");
        if (rawHeaders.getValue("x-ms-share-provisioned-egress-mbps") != null) {
            this.xMsShareProvisionedEgressMbps = Integer.parseInt(rawHeaders.getValue("x-ms-share-provisioned-egress-mbps"));
        }
        if (rawHeaders.getValue("x-ms-share-next-allowed-quota-downgrade-time") != null) {
            this.xMsShareNextAllowedQuotaDowngradeTime = new DateTimeRfc1123(rawHeaders.getValue("x-ms-share-next-allowed-quota-downgrade-time"));
        }
    }

    public Integer getXMsShareProvisionedIops() {
        return this.xMsShareProvisionedIops;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedIops(Integer xMsShareProvisionedIops) {
        this.xMsShareProvisionedIops = xMsShareProvisionedIops;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public SharesGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public SharesGetPropertiesHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public SharesGetPropertiesHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public ShareRootSquash getXMsRootSquash() {
        return this.xMsRootSquash;
    }

    public SharesGetPropertiesHeaders setXMsRootSquash(ShareRootSquash xMsRootSquash) {
        this.xMsRootSquash = xMsRootSquash;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public SharesGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public OffsetDateTime getXMsAccessTierChangeTime() {
        if (this.xMsAccessTierChangeTime == null) {
            return null;
        }
        return this.xMsAccessTierChangeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsAccessTierChangeTime(OffsetDateTime xMsAccessTierChangeTime) {
        this.xMsAccessTierChangeTime = xMsAccessTierChangeTime == null ? null : new DateTimeRfc1123(xMsAccessTierChangeTime);
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public SharesGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public SharesGetPropertiesHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Integer getXMsShareProvisionedIngressMbps() {
        return this.xMsShareProvisionedIngressMbps;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedIngressMbps(Integer xMsShareProvisionedIngressMbps) {
        this.xMsShareProvisionedIngressMbps = xMsShareProvisionedIngressMbps;
        return this;
    }

    public Integer getXMsShareProvisionedBandwidthMibps() {
        return this.xMsShareProvisionedBandwidthMibps;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedBandwidthMibps(Integer xMsShareProvisionedBandwidthMibps) {
        this.xMsShareProvisionedBandwidthMibps = xMsShareProvisionedBandwidthMibps;
        return this;
    }

    public Integer getXMsShareQuota() {
        return this.xMsShareQuota;
    }

    public SharesGetPropertiesHeaders setXMsShareQuota(Integer xMsShareQuota) {
        this.xMsShareQuota = xMsShareQuota;
        return this;
    }

    public String getXMsAccessTier() {
        return this.xMsAccessTier;
    }

    public SharesGetPropertiesHeaders setXMsAccessTier(String xMsAccessTier) {
        this.xMsAccessTier = xMsAccessTier;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SharesGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getXMsEnabledProtocols() {
        return this.xMsEnabledProtocols;
    }

    public SharesGetPropertiesHeaders setXMsEnabledProtocols(String xMsEnabledProtocols) {
        this.xMsEnabledProtocols = xMsEnabledProtocols;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public SharesGetPropertiesHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public SharesGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsAccessTierTransitionState() {
        return this.xMsAccessTierTransitionState;
    }

    public SharesGetPropertiesHeaders setXMsAccessTierTransitionState(String xMsAccessTierTransitionState) {
        this.xMsAccessTierTransitionState = xMsAccessTierTransitionState;
        return this;
    }

    public Integer getXMsShareProvisionedEgressMbps() {
        return this.xMsShareProvisionedEgressMbps;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedEgressMbps(Integer xMsShareProvisionedEgressMbps) {
        this.xMsShareProvisionedEgressMbps = xMsShareProvisionedEgressMbps;
        return this;
    }

    public OffsetDateTime getXMsShareNextAllowedQuotaDowngradeTime() {
        if (this.xMsShareNextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedQuotaDowngradeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsShareNextAllowedQuotaDowngradeTime(OffsetDateTime xMsShareNextAllowedQuotaDowngradeTime) {
        this.xMsShareNextAllowedQuotaDowngradeTime = xMsShareNextAllowedQuotaDowngradeTime == null ? null : new DateTimeRfc1123(xMsShareNextAllowedQuotaDowngradeTime);
        return this;
    }
}

