/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.sas;

import java.util.Locale;

public final class ShareSasPermission {
    private boolean readPermission;
    private boolean createPermission;
    private boolean writePermission;
    private boolean deletePermission;
    private boolean listPermission;

    public static ShareSasPermission parse(String permissionString) {
        ShareSasPermission permissions = new ShareSasPermission();
        block7: for (int i = 0; i < permissionString.length(); ++i) {
            char c = permissionString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block7;
                }
                case 'c': {
                    permissions.createPermission = true;
                    continue block7;
                }
                case 'w': {
                    permissions.writePermission = true;
                    continue block7;
                }
                case 'd': {
                    permissions.deletePermission = true;
                    continue block7;
                }
                case 'l': {
                    permissions.listPermission = true;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permissionString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public ShareSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasCreatePermission() {
        return this.createPermission;
    }

    public ShareSasPermission setCreatePermission(boolean hasCreatePermission) {
        this.createPermission = hasCreatePermission;
        return this;
    }

    public boolean hasWritePermission() {
        return this.writePermission;
    }

    public ShareSasPermission setWritePermission(boolean hasWritePermission) {
        this.writePermission = hasWritePermission;
        return this;
    }

    public boolean hasDeletePermission() {
        return this.deletePermission;
    }

    public ShareSasPermission setDeletePermission(boolean hasDeletePermission) {
        this.deletePermission = hasDeletePermission;
        return this;
    }

    public boolean hasListPermission() {
        return this.listPermission;
    }

    public ShareSasPermission setListPermission(boolean hasListPermission) {
        this.listPermission = hasListPermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.createPermission) {
            builder.append('c');
        }
        if (this.writePermission) {
            builder.append('w');
        }
        if (this.deletePermission) {
            builder.append('d');
        }
        if (this.listPermission) {
            builder.append('l');
        }
        return builder.toString();
    }
}

