/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractStandardEnforcerRule;

public class RequireFilesContent
extends AbstractStandardEnforcerRule {
    public String content;
    public File[] files;
    public boolean allowNulls = false;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        RequireFilesContent.checkNotNull(this.files, "file is mandatory");
        RequireFilesContent.checkNotNull(this.content, "content is mandatory");
        RequireFilesContent.checkArgument(this.files.length > 0, "at least 1 file must be specified");
        String newLine = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (File file : this.files) {
            Result result = this.checkFile(helper, file);
            if (result.successful) continue;
            sb.append(file.getAbsolutePath()).append(" : ").append(result.errorMessage);
            sb.append(newLine);
        }
        if (sb.length() != 0) {
            throw new EnforcerRuleException(sb.toString() + (this.getMessage() != null ? this.getMessage() : "Some files produce errors, please check the error message for the individual file above."));
        }
    }

    protected static void checkNotNull(Object reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    protected static void checkArgument(boolean condition, String errorMessage) throws EnforcerRuleException {
        if (!condition) {
            throw new EnforcerRuleException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result checkFile(EnforcerRuleHelper helper, File file) {
        if (file == null) {
            if (this.allowNulls) {
                return Result.success();
            }
            return Result.fail("Empty file name was given and allowNulls is set to false");
        }
        if (file.isFile()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    if (!line.contains(this.content)) continue;
                    Result result = Result.success();
                    return result;
                }
                Result result = Result.fail(String.format("Doesn't contain: \"%s\"", this.content));
                return result;
            }
            catch (FileNotFoundException e) {
                Result result = Result.fail("File doesn't exist");
                return result;
            }
            catch (IOException e) {
                helper.getLog().error((Throwable)e);
                Result result = Result.fail("IOException was thrown, please check the log.");
                return result;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        helper.getLog().error((Throwable)e);
                    }
                }
            }
        }
        return Result.fail("Not a file");
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    public String getCacheId() {
        return "0";
    }

    protected static class Result {
        public boolean successful;
        public String errorMessage = "";

        public static Result success() {
            return new Result(true, "");
        }

        public static Result fail(String errorMessage) {
            return new Result(false, errorMessage);
        }

        private Result(boolean successful, String errorMessage) {
            this.successful = successful;
            this.errorMessage = errorMessage;
        }
    }
}

