/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import java.util.Arrays;
import java.util.Objects;

public abstract class Message {
    final String aspect;
    final Type type;
    final String[] tags;
    protected boolean done;
    protected Integer hash;
    protected final int HASH_MULTIPLIER = 31;

    protected Message(Type type) {
        this.aspect = "";
        this.type = type;
        this.done = false;
        this.tags = null;
    }

    protected Message(String aspect, Type type, String[] tags) {
        this.aspect = aspect;
        this.type = type;
        this.done = false;
        this.tags = tags;
    }

    abstract void writeTo(StringBuilder var1);

    public abstract void aggregate(Message var1);

    public final String getAspect() {
        return this.aspect;
    }

    public final Type getType() {
        return this.type;
    }

    public String[] getTags() {
        return this.tags;
    }

    public boolean canAggregate() {
        return false;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean getDone() {
        return this.done;
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = new Integer(Objects.hash(this.aspect)) * 31;
            Message message = this;
            message.hash = message.hash + Objects.hash(this.tags);
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Message) {
            Message msg = (Message)object;
            boolean equals = this.getAspect() == msg.getAspect() && this.getType() == msg.getType() && this.done == msg.getDone() && Arrays.equals(this.tags, msg.getTags());
            return equals;
        }
        return false;
    }

    public static enum Type {
        GAUGE("g"),
        COUNT("c"),
        TIME("ms"),
        SET("s"),
        HISTOGRAM("h"),
        DISTRIBUTION("d"),
        EVENT("_e"),
        SERVICE_CHECK("_sc");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

