/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.collection;

import com.day.cq.workflow.collection.ResourceCollection;
import com.day.cq.workflow.collection.ResourceCollectionManager;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class ResourceCollectionUtil {
    public static ResourceCollection getResourceCollection(Node node, ResourceCollectionManager manager) throws RepositoryException {
        if (!node.isNodeType("vlt:PackageDefinition")) {
            NodeIterator itr = node.getNodes();
            while (itr.hasNext()) {
                Node n = itr.nextNode();
                ResourceCollection coll = ResourceCollectionUtil.getResourceCollection(n, manager);
                if (coll == null) continue;
                return coll;
            }
        } else {
            return manager.createCollection(node);
        }
        return null;
    }

    public static Node getContainingPage(ResourceCollection collection, Session session) throws RepositoryException {
        if (collection.getPath().indexOf("jcr:content") > 0) {
            Node node = (Node)session.getItem(collection.getPath());
            while (!node.getName().equals("jcr:content")) {
                node = node.getParent();
            }
            return node.getParent();
        }
        return (Node)session.getItem(collection.getPath());
    }
}

