/*
 * Decompiled with CFR 0.152.
 */
package com.day.cqse.httpservice.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CQSEConfig {
    private static final String FELIX_HOST = "org.apache.felix.http.host";
    private static final String HTTP_PORT = "org.osgi.service.http.port";
    public static final String HTTPS_PORT = "org.osgi.service.http.port.secure";
    public static final String HTTP_TIMEOUT = "org.apache.felix.http.timeout";
    public static final String FELIX_HTTP_DEBUG = "org.apache.felix.http.debug";
    private static final String HTTP_DEBUG = "org.apache.felix.http.jetty.debug";
    public static final String FELIX_KEYSTORE = "org.apache.felix.https.keystore";
    private static final String OSCAR_KEYSTORE = "org.ungoverned.osgi.bundle.https.keystore";
    public static final String FELIX_KEYSTORE_PASSWORD = "org.apache.felix.https.keystore.password";
    private static final String OSCAR_KEYSTORE_PASSWORD = "org.ungoverned.osgi.bundle.https.password";
    public static final String FELIX_KEYSTORE_KEY_ALIAS = "org.apache.felix.https.keystore.key";
    private static final String OSCAR_KEYSTORE_KEY_ALIAS = "org.ungoverned.osgi.bundle.https.key";
    public static final String FELIX_KEYSTORE_KEY_PASSWORD = "org.apache.felix.https.keystore.key.password";
    private static final String OSCAR_KEYSTORE_KEY_PASSWORD = "org.ungoverned.osgi.bundle.https.key.password";
    public static final String FELIX_HTTPS_ENABLE = "org.apache.felix.https.enable";
    private static final String OSCAR_HTTPS_ENABLE = "org.ungoverned.osgi.bundle.https.enable";
    private static final String FELIX_HTTP_ENABLE = "org.apache.felix.http.enable";
    public static final String FELIX_SESSION_TIMEOUT = "org.apache.felix.http.session.timeout";
    public static final String FELIX_HTTPS_CLIENT_CERT = "org.apache.felix.https.clientcertificate";
    public static final String FELIX_HTTP_NIO = "org.apache.felix.http.nio";
    public static final String FELIX_HTTPS_NIO = "org.apache.felix.https.nio";
    private static final String FELIX_HTTP_CONTEXT_PATH = "org.apache.felix.http.context_path";
    private final BundleContext context;
    private boolean debug;
    private String host;
    private int httpPort;
    private int httpsPort;
    private int httpTimeout;
    private String keystore;
    private String password;
    private String keyAlias;
    private String keyPassword;
    private boolean useHttps;
    private boolean useHttp;
    private String clientcert;
    private boolean useHttpNio;
    private boolean useHttpsNio;
    private int sessionTimeout;
    private String contextPath;

    public CQSEConfig(BundleContext context) {
        this.context = context;
        this.reset();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isUseHttp() {
        return this.useHttp && this.getHttpPort() > 0;
    }

    public boolean isUseHttpNio() {
        return this.useHttpNio;
    }

    public boolean isUseHttps() {
        return this.useHttps && this.getHttpsPort() > 0;
    }

    public boolean isUseHttpsNio() {
        return this.useHttpsNio;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getClientcert() {
        return this.clientcert;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void reset() {
        this.update(null);
    }

    public void update(Dictionary props) {
        if (props == null) {
            props = new Properties();
        }
        this.debug = this.getBooleanProperty(props, FELIX_HTTP_DEBUG, this.getBooleanProperty(props, HTTP_DEBUG, false));
        this.host = this.getProperty(props, FELIX_HOST, null);
        this.httpPort = this.getIntProperty(props, HTTP_PORT, 8080);
        this.httpsPort = this.getIntProperty(props, HTTPS_PORT, 8443);
        this.httpTimeout = this.getIntProperty(props, HTTP_TIMEOUT, 60000);
        this.keystore = this.getProperty(props, FELIX_KEYSTORE, this.context.getProperty(OSCAR_KEYSTORE));
        this.password = this.getProperty(props, FELIX_KEYSTORE_PASSWORD, this.context.getProperty(OSCAR_KEYSTORE_PASSWORD));
        this.keyAlias = this.getProperty(props, FELIX_KEYSTORE_KEY_ALIAS, this.context.getProperty(OSCAR_KEYSTORE_KEY_ALIAS));
        this.keyPassword = this.getProperty(props, FELIX_KEYSTORE_KEY_PASSWORD, this.context.getProperty(OSCAR_KEYSTORE_KEY_PASSWORD));
        this.useHttps = this.getBooleanProperty(props, FELIX_HTTPS_ENABLE, this.getBooleanProperty(props, OSCAR_HTTPS_ENABLE, false));
        this.useHttp = this.getBooleanProperty(props, FELIX_HTTP_ENABLE, true);
        this.clientcert = this.getProperty(props, FELIX_HTTPS_CLIENT_CERT, "none");
        this.useHttpNio = this.getBooleanProperty(props, FELIX_HTTP_NIO, true);
        this.useHttpsNio = this.getBooleanProperty(props, FELIX_HTTPS_NIO, this.useHttpNio);
        this.sessionTimeout = this.getIntProperty(props, FELIX_SESSION_TIMEOUT, 10);
        this.contextPath = CQSEConfig.validateContextPath(this.getProperty(props, FELIX_HTTP_CONTEXT_PATH, null));
    }

    private String getProperty(Dictionary props, String name, String defValue) {
        Object value = props.get(name);
        if (value == null) {
            value = this.context.getProperty(name);
        }
        return value != null ? String.valueOf(value) : defValue;
    }

    private boolean getBooleanProperty(Dictionary props, String name, boolean defValue) {
        String value = this.getProperty(props, name, null);
        if (value != null) {
            return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        return defValue;
    }

    private int getIntProperty(Dictionary props, String name, int defValue) {
        try {
            return Integer.parseInt(this.getProperty(props, name, null));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public void setServiceProperties(Hashtable<String, Object> props) {
        props.put(HTTP_PORT, String.valueOf(this.httpPort));
        props.put(HTTPS_PORT, String.valueOf(this.httpsPort));
        props.put(FELIX_HTTP_ENABLE, String.valueOf(this.useHttp));
        props.put(FELIX_HTTPS_ENABLE, String.valueOf(this.useHttps));
    }

    private static String validateContextPath(String ctxPath) {
        if (ctxPath == null || ctxPath.length() == 0 || "/".equals(ctxPath)) {
            return "/";
        }
        if (!ctxPath.startsWith("/")) {
            ctxPath = "/".concat(ctxPath);
        }
        while (ctxPath.endsWith("/")) {
            ctxPath = ctxPath.substring(0, ctxPath.length() - 1);
        }
        return ctxPath;
    }
}

