/*
 * Decompiled with CFR 0.152.
 */
package com.day.cqse.httpservice.internal;

import com.day.cqse.httpservice.internal.CQSEConfig;
import com.day.cqse.httpservice.internal.CQSEConfigHandler;
import com.day.j2ee.servletengine.HttpListener;
import com.day.j2ee.servletengine.HttpsListener;
import com.day.j2ee.servletengine.ServletContainer;
import com.day.j2ee.servletengine.ServletEngine;
import com.day.j2ee.servletengine.WebApplication;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.felix.http.base.internal.DispatcherServlet;
import org.apache.felix.http.base.internal.EventDispatcher;
import org.apache.felix.http.base.internal.HttpServiceController;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class CQSEService
implements Runnable {
    public static final String PID = "org.apache.felix.http";
    private final BundleContext context;
    private final CQSEConfig config;
    private final CQSEConfig defaultConfig;
    private final DispatcherServlet dispatcher;
    private final EventDispatcher eventDispatcher;
    private final HttpServiceController controller;
    private Thread thread;
    private ServiceRegistration configServiceReg;
    private volatile boolean running;
    private ServletEngine server;

    public CQSEService(BundleContext context, DispatcherServlet dispatcher, EventDispatcher eventDispatcher, HttpServiceController controller) {
        this.context = context;
        this.config = new CQSEConfig(this.context);
        this.defaultConfig = new CQSEConfig(this.context);
        this.dispatcher = dispatcher;
        this.eventDispatcher = eventDispatcher;
        this.controller = controller;
    }

    public void start() throws Exception {
        Properties props = new Properties();
        props.put("service.pid", PID);
        this.configServiceReg = this.context.registerService("org.osgi.service.cm.ManagedService", (Object)new ServiceFactory(){

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return new CQSEConfigHandler(CQSEService.this);
            }
        }, (Dictionary)props);
        this.thread = new Thread((Runnable)this, "CQSE HTTP Service");
        this.thread.start();
    }

    public void stop() throws Exception {
        if (this.configServiceReg != null) {
            this.configServiceReg.unregister();
        }
        this.running = false;
        this.thread.interrupt();
        try {
            this.thread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void updated(Dictionary props) {
        this.config.update(props);
        if (this.running && this.thread != null) {
            this.thread.interrupt();
        }
    }

    public CQSEConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        while (this.running) {
            this.startCQSE();
            CQSEService cQSEService = this;
            synchronized (cQSEService) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.stopCQSE();
        }
    }

    private void startCQSE() {
        try {
            this.initializeCQSE();
        }
        catch (Exception e) {
            SystemLogger.error("Exception while initializing CQSE.", e);
        }
    }

    private void stopCQSE() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
            }
            catch (Exception e) {
                SystemLogger.error("Exception while stopping CQSE.", e);
            }
        }
    }

    private void initializeCQSE() throws Exception {
        if (this.config.isUseHttp() || this.config.isUseHttps()) {
            StringBuffer message = new StringBuffer("Started CQSE ").append("4.x").append(" at port(s)");
            ServletContainer container = new ServletContainer();
            if (this.config.isUseHttp()) {
                this.initializeHttp(container);
                message.append(" HTTP:").append(this.config.getHttpPort());
            }
            if (this.config.isUseHttps()) {
                this.initializeHttps(container);
                message.append(" HTTPS:").append(this.config.getHttpsPort());
            }
            WebApplication webapp = new WebApplication(this.config.getContextPath());
            message.append(" on context path ").append(this.config.getContextPath());
            webapp.addServlet(this.dispatcher, "dispatcher", "/*");
            webapp.addEventListener(this.eventDispatcher);
            webapp.setDefaultTimeout(this.config.getSessionTimeout());
            container.addApplication(webapp);
            this.server = new ServletEngine();
            this.server.addContainer(container);
            this.server.start();
            SystemLogger.info(message.toString());
        } else {
            SystemLogger.info("CQSE not started (HTTP and HTTPS disabled)");
        }
        this.publishServiceProperties();
    }

    private void initializeHttp(ServletContainer container) throws Exception {
        HttpListener listener = new HttpListener();
        listener.setPort(this.config.getHttpPort());
        listener.setHost(this.config.getHost());
        listener.setHttpKeepAliveTimeout(this.config.getHttpTimeout());
        container.addListener(listener);
    }

    private void initializeHttps(ServletContainer container) throws Exception {
        HttpsListener listener = new HttpsListener();
        listener.setPort(this.config.getHttpsPort());
        listener.setHost(this.config.getHost());
        listener.setHttpKeepAliveTimeout(this.config.getHttpTimeout());
        if (this.config.getKeystore() != null) {
            listener.setKeyStore(this.config.getKeystore());
        }
        if (this.config.getPassword() != null) {
            listener.setKeyStorePass(this.config.getPassword());
        }
        if (this.config.getKeyAlias() != null) {
            listener.setKeyAlias(this.config.getKeyAlias());
        }
        if (this.config.getKeyPassword() != null) {
            listener.setKeyPass(this.config.getKeyPassword());
        }
        container.addListener(listener);
    }

    private void publishServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        this.config.setServiceProperties(props);
        this.controller.setProperties(props);
    }
}

