/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.Allow;
import com.day.j2ee.config.DefaultSerializable;
import com.day.j2ee.config.Deny;
import com.day.j2ee.config.HttpFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public final class AccessConstraint
extends DefaultSerializable {
    private static final String ELEMENT_ALLOW = "allow";
    private static final String ELEMENT_DENY = "deny";
    private List filters = new ArrayList();

    public void read(Element element) {
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            HttpFilter filter = null;
            if (child.getName().equals(ELEMENT_ALLOW)) {
                filter = new Allow();
            } else if (child.getName().equals(ELEMENT_DENY)) {
                filter = new Deny();
            }
            if (filter == null) continue;
            filter.read(child);
            this.filters.add(filter);
        }
    }

    public void write(Element element) {
        Iterator iter = this.filters.iterator();
        while (iter.hasNext()) {
            HttpFilter filter = (HttpFilter)iter.next();
            if (filter.isAllowed()) {
                this.setValue(element, ELEMENT_ALLOW, filter);
                continue;
            }
            this.setValue(element, ELEMENT_DENY, filter);
        }
    }

    public List getFilters() {
        return this.filters;
    }

    public void setFilters(List filters) {
        this.filters = filters;
    }
}

