/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.DefaultSerializable;
import com.day.j2ee.config.Dispatcher;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class FilterMapping
extends DefaultSerializable {
    private static final String ELEMENT_FILTER_NAME = "filter-name";
    private static final String ELEMENT_SERVLET_NAME = "servlet-name";
    private static final String ELEMENT_URL_PATTERN = "url-pattern";
    private static final String ELEMENT_DISPATCHER = "dispatcher";
    private static final Dispatcher.Set DEFAULT_DISPATCHERS = new Dispatcher.Set();
    private String filterName;
    private String servletName;
    private String urlPattern;
    private Dispatcher.Set dispatchers;

    public void read(Element element) throws ConfigException {
        Namespace ns = element.getNamespace();
        this.filterName = this.getStringValue(element, ELEMENT_FILTER_NAME);
        this.servletName = this.getStringValue(element, ELEMENT_SERVLET_NAME);
        this.urlPattern = this.getStringValue(element, ELEMENT_URL_PATTERN);
        List list = element.getChildren(ELEMENT_DISPATCHER, ns);
        if (list.isEmpty()) {
            this.dispatchers = DEFAULT_DISPATCHERS;
        } else {
            this.dispatchers = new Dispatcher.Set();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Element child = (Element)iter.next();
                this.dispatchers.add(Dispatcher.valueOf(child.getTextTrim()));
            }
        }
    }

    public void write(Element element) {
        this.setValue(element, ELEMENT_FILTER_NAME, this.filterName);
        this.setValue(element, ELEMENT_SERVLET_NAME, this.servletName);
        this.setValue(element, ELEMENT_URL_PATTERN, this.urlPattern);
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public Dispatcher.Set getDispatchers() {
        return this.dispatchers;
    }

    public void setDispatchers(Dispatcher.Set dispatchers) {
        this.dispatchers = dispatchers;
    }

    static {
        DEFAULT_DISPATCHERS.add(Dispatcher.REQUEST);
    }
}

