/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.ResourceAdapterXml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceAdapterXmlReader
implements EntityResolver {
    private static final String RESOURCE_NAME = "/resources/dtd/connector_1_0.dtd";
    private final ResourceAdapterXml raXml = new ResourceAdapterXml();

    private Document createDocument(File file) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver(this);
        builder.setValidation(true);
        return builder.build(file);
    }

    private void read(Document doc) throws ConfigException {
        this.raXml.read(doc.getRootElement());
    }

    public static ResourceAdapterXml parse(File xmlFile) throws IOException, ConfigException {
        ResourceAdapterXmlReader xmlReader = new ResourceAdapterXmlReader();
        xmlReader.read(xmlFile);
        return xmlReader.getRaXml();
    }

    public void read(File xmlFile) throws IOException, ConfigException {
        if (!xmlFile.exists()) {
            throw new IOException("web application descriptor not found: " + xmlFile.getPath());
        }
        if (!xmlFile.canRead()) {
            throw new IOException("unable to read web application descriptor: " + xmlFile.getPath());
        }
        try {
            this.read(this.createDocument(xmlFile));
        }
        catch (JDOMException e) {
            ConfigException ce = new ConfigException(e.getMessage(), e);
            throw ce;
        }
    }

    public ResourceAdapterXml getRaXml() {
        return this.raXml;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream in = null;
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN")) {
            in = this.getClass().getResourceAsStream(RESOURCE_NAME);
        }
        if (in != null) {
            return new InputSource(in);
        }
        return null;
    }
}

