/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.ServerXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServerXmlReader
implements EntityResolver {
    private static final String RESOURCE_NAME = "/resources/dtd/server_3_0.dtd";

    protected ServerXmlReader() {
    }

    private Document createDocument(File file) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver(this);
        builder.setValidation(true);
        return builder.build(file);
    }

    private Document createDocument(InputStream in) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver(this);
        builder.setValidation(true);
        return builder.build(in);
    }

    protected ServerXml read(Document doc) throws ConfigException {
        ServerXml config = new ServerXml();
        config.read(doc.getRootElement());
        return config;
    }

    public static ServerXml parse(File xmlFile) throws IOException, ConfigException {
        if (!xmlFile.exists()) {
            throw new FileNotFoundException(xmlFile.getPath());
        }
        if (!xmlFile.canRead()) {
            throw new IOException("unable to read: " + xmlFile.getPath());
        }
        try {
            ServerXmlReader xmlReader = new ServerXmlReader();
            Document doc = xmlReader.createDocument(xmlFile);
            return xmlReader.read(doc);
        }
        catch (JDOMException e) {
            ConfigException ce = new ConfigException(e.getMessage(), e);
            throw ce;
        }
    }

    public static ServerXml parse(InputStream in) throws ConfigException, IOException {
        try {
            ServerXmlReader xmlReader = new ServerXmlReader();
            Document doc = xmlReader.createDocument(in);
            return xmlReader.read(doc);
        }
        catch (JDOMException e) {
            ConfigException ce = new ConfigException(e.getMessage(), e);
            throw ce;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream in = null;
        if (publicId.equals("-//Day Software AG//DTD J2EE Server 3.0//EN")) {
            in = this.getClass().getResourceAsStream(RESOURCE_NAME);
        }
        if (in != null) {
            return new InputSource(in);
        }
        return null;
    }
}

