/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.DefaultSerializable;
import org.jdom.Element;

public final class WebApplication
extends DefaultSerializable {
    private static final String ELEMENT_CONTEXT = "context";
    private static final String ELEMENT_PATH = "path";
    private static final String ELEMENT_LEVEL = "log-level";
    private static final String ELEMENT_RUN_ON_STARTUP = "run-on-startup";
    public static final String STATE_SUSPENDED = "suspended";
    private String context;
    private String path;
    private String level;
    private String runOnStartup;

    public void read(Element element) throws ConfigException {
        this.context = this.getStringValue(element, ELEMENT_CONTEXT);
        this.path = this.getStringValue(element, ELEMENT_PATH);
        this.level = this.getStringValue(element, ELEMENT_LEVEL);
        this.runOnStartup = this.getStringValue(element, ELEMENT_RUN_ON_STARTUP);
        if (this.runOnStartup == null) {
            this.runOnStartup = String.valueOf(true);
        }
        if (!WebApplication.isValidContextPath(this.context)) {
            throw new ConfigException("The context path is invalid: " + this.context);
        }
    }

    public void write(Element element) {
        this.setValue(element, ELEMENT_CONTEXT, this.context);
        this.setValue(element, ELEMENT_PATH, this.path);
        this.setValue(element, ELEMENT_LEVEL, this.level);
        this.setValue(element, ELEMENT_RUN_ON_STARTUP, this.runOnStartup);
    }

    public void setContext(String context) {
        if (!WebApplication.isValidContextPath(context)) {
            throw new IllegalArgumentException("The context path is invalid: " + context);
        }
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    public void setRunOnStartup(String value) {
        this.runOnStartup = value;
    }

    public String getRunOnStartup() {
        return this.runOnStartup;
    }

    private static boolean isValidContextPath(String contextPath) {
        return contextPath != null && (contextPath.equals("/") || contextPath.startsWith("/") && !contextPath.endsWith("/"));
    }
}

