/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.DefaultSerializable;
import com.day.j2ee.config.ErrorPage;
import com.day.j2ee.config.EventListener;
import com.day.j2ee.config.Filter;
import com.day.j2ee.config.FilterMapping;
import com.day.j2ee.config.JspConfig;
import com.day.j2ee.config.LoginConfig;
import com.day.j2ee.config.MimeMapping;
import com.day.j2ee.config.Param;
import com.day.j2ee.config.ResourceRef;
import com.day.j2ee.config.SecurityConstraint;
import com.day.j2ee.config.SecurityRole;
import com.day.j2ee.config.Servlet;
import com.day.j2ee.config.ServletMapping;
import com.day.j2ee.config.SessionConfig;
import com.day.j2ee.config.TagLib;
import com.day.j2ee.config.WelcomeFileList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class WebXml
extends DefaultSerializable {
    public static final String PUBLIC_ID_2_2 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    public static final String PUBLIC_ID_2_3 = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    public static final String SYSTEM_ID_2_2 = "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
    public static final String SYSTEM_ID_2_3 = "http://java.sun.com/dtd/web-app_2_3.dtd";
    public static final String DEFAULT_NAME = "web.xml";
    public static final String ROOT_ELEMENT = "web-app";
    private static final String ELEMENT_DISPLAY_NAME = "display-name";
    private static final String ELEMENT_CONTEXT_PARAM = "context-param";
    private static final String ELEMENT_LISTENER = "listener";
    private static final String ELEMENT_FILTER = "filter";
    private static final String ELEMENT_FILTER_MAPPING = "filter-mapping";
    private static final String ELEMENT_SERVLET = "servlet";
    private static final String ELEMENT_SERVLET_MAPPING = "servlet-mapping";
    private static final String ELEMENT_MIME_MAPPING = "mime-mapping";
    private static final String ELEMENT_WELCOME_FILE_LIST = "welcome-file-list";
    private static final String ELEMENT_ERROR_PAGE = "error-page";
    private static final String ELEMENT_JSP_CONFIG = "jsp-config";
    private static final String ELEMENT_TAGLIB = "taglib";
    private static final String ELEMENT_RESOURCE_REF = "resource-ref";
    private static final String ELEMENT_SECURITY_CONSTRAINT = "security-constraint";
    private static final String ELEMENT_LOGIN_CONFIG = "login-config";
    private static final String ELEMENT_SECURITY_ROLE = "security-role";
    private static final String ELEMENT_SESSION_CONFIG = "session-config";
    private static final String ELEMENT_VERSION = "version";
    private String displayName;
    private List contextParams = new ArrayList();
    private List filters = new ArrayList();
    private List filterMappings = new ArrayList();
    private List listeners = new ArrayList();
    private List servlets = new ArrayList();
    private List servletMappings = new ArrayList();
    private List mimeMappings = new ArrayList();
    private WelcomeFileList welcomeFileList;
    private List errorPages = new ArrayList();
    private List tagLibs = new ArrayList();
    private List resourceRefs = new ArrayList();
    private List securityConstraints = new ArrayList();
    private LoginConfig loginConfig;
    private List securityRoles = new ArrayList();
    private SessionConfig sessionConfig;
    private JspConfig jspConfig;
    private transient Map contextParamMap;
    private transient Map filterMap;
    private transient Map servletMap;
    private transient Map mimeMappingMap;
    private Version version;

    public WebXml(Version version) {
        this.version = version;
    }

    WebXml() {
    }

    public void read(Element element) throws ConfigException {
        Namespace ns = element.getNamespace();
        Iterator iter = element.getAttributes().iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (!ELEMENT_VERSION.equals(attr.getName())) continue;
            this.version = Version.valueOf(attr.getValue());
        }
        this.displayName = this.getStringValue(element, ELEMENT_DISPLAY_NAME);
        iter = element.getChildren(ELEMENT_CONTEXT_PARAM, ns).iterator();
        while (iter.hasNext()) {
            Param param = new Param();
            param.read((Element)iter.next());
            this.contextParams.add(param);
        }
        iter = element.getChildren(ELEMENT_FILTER, ns).iterator();
        while (iter.hasNext()) {
            Filter filter = new Filter();
            filter.read((Element)iter.next());
            this.filters.add(filter);
        }
        iter = element.getChildren(ELEMENT_FILTER_MAPPING, ns).iterator();
        while (iter.hasNext()) {
            FilterMapping filterMapping = new FilterMapping();
            filterMapping.read((Element)iter.next());
            this.filterMappings.add(filterMapping);
        }
        iter = element.getChildren(ELEMENT_LISTENER, ns).iterator();
        while (iter.hasNext()) {
            EventListener listener = new EventListener();
            listener.read((Element)iter.next());
            this.listeners.add(listener);
        }
        iter = element.getChildren(ELEMENT_SERVLET, ns).iterator();
        while (iter.hasNext()) {
            Servlet servlet = new Servlet();
            servlet.read((Element)iter.next());
            this.servlets.add(servlet);
        }
        iter = element.getChildren(ELEMENT_SERVLET_MAPPING, ns).iterator();
        while (iter.hasNext()) {
            ServletMapping servletMapping = new ServletMapping();
            servletMapping.read((Element)iter.next());
            this.servletMappings.add(servletMapping);
        }
        iter = element.getChildren(ELEMENT_MIME_MAPPING, ns).iterator();
        while (iter.hasNext()) {
            MimeMapping mimeMapping = new MimeMapping();
            mimeMapping.read((Element)iter.next());
            this.mimeMappings.add(mimeMapping);
        }
        Element child = element.getChild(ELEMENT_WELCOME_FILE_LIST, ns);
        if (child != null) {
            this.welcomeFileList = new WelcomeFileList();
            this.welcomeFileList.read(child);
        }
        iter = element.getChildren(ELEMENT_ERROR_PAGE, ns).iterator();
        while (iter.hasNext()) {
            ErrorPage errorPage = new ErrorPage();
            errorPage.read((Element)iter.next());
            this.errorPages.add(errorPage);
        }
        if (this.version == Version.V2_4) {
            child = element.getChild(ELEMENT_JSP_CONFIG, ns);
            if (child != null) {
                this.jspConfig = new JspConfig();
                this.jspConfig.read(child);
            }
        } else {
            iter = element.getChildren(ELEMENT_TAGLIB, ns).iterator();
            while (iter.hasNext()) {
                TagLib tagLib = new TagLib();
                tagLib.read((Element)iter.next());
                this.tagLibs.add(tagLib);
            }
        }
        iter = element.getChildren(ELEMENT_RESOURCE_REF, ns).iterator();
        while (iter.hasNext()) {
            ResourceRef resourceRef = new ResourceRef();
            resourceRef.read((Element)iter.next());
            this.resourceRefs.add(resourceRef);
        }
        iter = element.getChildren(ELEMENT_SECURITY_CONSTRAINT, ns).iterator();
        while (iter.hasNext()) {
            SecurityConstraint securityConstraint = new SecurityConstraint();
            securityConstraint.read((Element)iter.next());
            this.securityConstraints.add(securityConstraint);
        }
        child = element.getChild(ELEMENT_LOGIN_CONFIG, ns);
        if (child != null) {
            this.loginConfig = new LoginConfig();
            this.loginConfig.read(child);
        }
        iter = element.getChildren(ELEMENT_SECURITY_ROLE, ns).iterator();
        while (iter.hasNext()) {
            SecurityRole securityRole = new SecurityRole();
            securityRole.read((Element)iter.next());
            this.securityRoles.add(securityRole);
        }
        child = element.getChild(ELEMENT_SESSION_CONFIG, ns);
        if (child != null) {
            this.sessionConfig = new SessionConfig();
            this.sessionConfig.read(child);
        }
    }

    public void write(Element element) {
        this.setValue(element, ELEMENT_DISPLAY_NAME, this.displayName);
        Iterator iter = this.contextParams.iterator();
        while (iter.hasNext()) {
            Param param = (Param)iter.next();
            this.setValue(element, ELEMENT_CONTEXT_PARAM, param);
        }
        iter = this.filters.iterator();
        while (iter.hasNext()) {
            Filter filter = (Filter)iter.next();
            this.setValue(element, ELEMENT_FILTER, filter);
        }
        iter = this.filterMappings.iterator();
        while (iter.hasNext()) {
            FilterMapping filterMapping = (FilterMapping)iter.next();
            this.setValue(element, ELEMENT_FILTER_MAPPING, filterMapping);
        }
        iter = this.listeners.iterator();
        while (iter.hasNext()) {
            EventListener listener = (EventListener)iter.next();
            this.setValue(element, ELEMENT_LISTENER, listener);
        }
        iter = this.servlets.iterator();
        while (iter.hasNext()) {
            Servlet servlet = (Servlet)iter.next();
            this.setValue(element, ELEMENT_SERVLET, servlet);
        }
        iter = this.servletMappings.iterator();
        while (iter.hasNext()) {
            ServletMapping servletMapping = (ServletMapping)iter.next();
            this.setValue(element, ELEMENT_SERVLET_MAPPING, servletMapping);
        }
        this.setValue(element, ELEMENT_WELCOME_FILE_LIST, this.welcomeFileList);
        iter = this.errorPages.iterator();
        while (iter.hasNext()) {
            ErrorPage errorPage = (ErrorPage)iter.next();
            this.setValue(element, ELEMENT_ERROR_PAGE, errorPage);
        }
        if (this.version == Version.V2_4) {
            if (this.jspConfig != null) {
                this.setValue(element, ELEMENT_JSP_CONFIG, this.jspConfig);
            }
        } else {
            iter = this.tagLibs.iterator();
            while (iter.hasNext()) {
                TagLib tagLib = (TagLib)iter.next();
                this.setValue(element, ELEMENT_TAGLIB, tagLib);
            }
        }
        iter = this.resourceRefs.iterator();
        while (iter.hasNext()) {
            ResourceRef resourceRef = (ResourceRef)iter.next();
            this.setValue(element, ELEMENT_RESOURCE_REF, resourceRef);
        }
        iter = this.securityConstraints.iterator();
        while (iter.hasNext()) {
            SecurityConstraint securityConstraint = (SecurityConstraint)iter.next();
            this.setValue(element, ELEMENT_SECURITY_CONSTRAINT, securityConstraint);
        }
        this.setValue(element, ELEMENT_LOGIN_CONFIG, this.loginConfig);
        iter = this.securityRoles.iterator();
        while (iter.hasNext()) {
            SecurityRole securityRole = (SecurityRole)iter.next();
            this.setValue(element, ELEMENT_SECURITY_ROLE, securityRole);
        }
        this.setValue(element, ELEMENT_SESSION_CONFIG, this.sessionConfig);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List getContextParams() {
        return this.contextParams;
    }

    public void setContextParams(List contextParams) {
        this.contextParams = contextParams;
        this.contextParamMap = null;
    }

    public List getFilters() {
        return this.filters;
    }

    public void setFilters(List filters) {
        this.filters = filters;
    }

    public List getFilterMappings() {
        return this.filterMappings;
    }

    public void setFilterMappings(List filterMappings) {
        this.filterMappings = filterMappings;
    }

    public List getListeners() {
        return this.listeners;
    }

    public void setListeners(List listeners) {
        this.listeners = listeners;
    }

    public List getServlets() {
        return this.servlets;
    }

    public void setServlets(List servlets) {
        this.servlets = servlets;
        this.servletMap = null;
    }

    public void addServlet(Servlet servlet) {
        this.servlets.add(servlet);
        this.servletMap = null;
    }

    public List getServletMappings() {
        return this.servletMappings;
    }

    public void setServletMappings(List servletMappings) {
        this.servletMappings = servletMappings;
    }

    public void addServletMapping(ServletMapping servletMapping) {
        this.servletMappings.add(servletMapping);
        this.servletMap = null;
    }

    public List getMimeMappings() {
        return this.mimeMappings;
    }

    public void setMimeMappings(List mimeMappings) {
        this.mimeMappings = mimeMappings;
        this.mimeMappingMap = null;
    }

    public WelcomeFileList getWelcomeFileList() {
        return this.welcomeFileList;
    }

    public void setWelcomeFileList(WelcomeFileList welcomeFileList) {
        this.welcomeFileList = welcomeFileList;
    }

    public List getErrorPages() {
        return this.errorPages;
    }

    public void setErrorPages(List errorPages) {
        this.errorPages = errorPages;
    }

    public void addTagLib(TagLib tagLib) {
        if (this.version == Version.V2_4) {
            if (this.jspConfig == null) {
                this.jspConfig = new JspConfig();
            }
            this.jspConfig.addTagLib(tagLib);
        } else {
            this.tagLibs.add(tagLib);
        }
    }

    public List getResourceRefs() {
        return this.resourceRefs;
    }

    public void setResourceRefs(List resourceRefs) {
        this.resourceRefs = resourceRefs;
    }

    public boolean hasSecurityConstraints() {
        return this.securityConstraints.size() > 0;
    }

    public List getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void setSecurityConstraints(List securityConstraints) {
        this.securityConstraints = securityConstraints;
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        this.loginConfig = loginConfig;
    }

    public List getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(List securityRoles) {
        this.securityRoles = securityRoles;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public Iterator contextParamNames() {
        if (this.contextParamMap == null) {
            this.contextParamMap = this.setupContextParamMap();
        }
        return this.contextParamMap.keySet().iterator();
    }

    public Param getContextParam(String paramName) {
        if (this.contextParamMap == null) {
            this.contextParamMap = this.setupContextParamMap();
        }
        return (Param)this.contextParamMap.get(paramName);
    }

    protected HashMap setupContextParamMap() {
        HashMap<String, Param> contextParamMap = new HashMap<String, Param>();
        Iterator iter = this.contextParams.iterator();
        while (iter.hasNext()) {
            Param param = (Param)iter.next();
            contextParamMap.put(param.getParamName(), param);
        }
        return contextParamMap;
    }

    public Filter getFilter(String filterName) {
        if (this.filterMap == null) {
            this.filterMap = this.setupFilterMap();
        }
        return (Filter)this.filterMap.get(filterName);
    }

    protected HashMap setupFilterMap() {
        HashMap<String, Filter> filterMap = new HashMap<String, Filter>();
        Iterator iter = this.filters.iterator();
        while (iter.hasNext()) {
            Filter filter = (Filter)iter.next();
            filterMap.put(filter.getFilterName(), filter);
        }
        return filterMap;
    }

    public Servlet getServlet(String servletName) {
        if (this.servletMap == null) {
            this.servletMap = this.setupServletMap();
        }
        return (Servlet)this.servletMap.get(servletName);
    }

    protected HashMap setupServletMap() {
        HashMap<String, Servlet> servletMap = new HashMap<String, Servlet>();
        Iterator iter = this.servlets.iterator();
        while (iter.hasNext()) {
            Servlet servlet = (Servlet)iter.next();
            servletMap.put(servlet.getServletName(), servlet);
        }
        return servletMap;
    }

    public MimeMapping getMimeMapping(String extension) {
        if (this.mimeMappingMap == null) {
            this.mimeMappingMap = this.setupMimeMappingMap();
        }
        return (MimeMapping)this.mimeMappingMap.get(extension);
    }

    protected HashMap setupMimeMappingMap() {
        HashMap<String, MimeMapping> mimeMappingMap = new HashMap<String, MimeMapping>();
        Iterator iter = this.mimeMappings.iterator();
        while (iter.hasNext()) {
            MimeMapping mimeMapping = (MimeMapping)iter.next();
            mimeMappingMap.put(mimeMapping.getExtension(), mimeMapping);
        }
        return mimeMappingMap;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public static class Version {
        public static final Version V2_2 = new Version("2.2");
        public static final Version V2_3 = new Version("2.3");
        public static final Version V2_4 = new Version("2.4");
        public static final Version V2_5 = new Version("2.5");
        private static final HashMap VERSIONS = new HashMap();
        private String s;

        private Version(String s) {
            this.s = s;
        }

        public String value() {
            return this.s;
        }

        public static Version valueOf(String s) {
            return (Version)VERSIONS.get(s);
        }

        static {
            VERSIONS.put(V2_2.value(), V2_2);
            VERSIONS.put(V2_3.value(), V2_3);
            VERSIONS.put(V2_4.value(), V2_4);
            VERSIONS.put(V2_5.value(), V2_5);
        }
    }
}

