/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.WebXml;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class WebXmlWriter {
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String J2EE_NS_URI = "http://java.sun.com/xml/ns/j2ee";
    private static final String J2EE_SCHEMA_LOCATION = "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
    private static final String XSI_NS_PREFIX = "xsi";
    private static final String XSI_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";

    private WebXmlWriter() {
    }

    private Document createDocument(WebXml webXml) {
        Element root = WebXmlWriter.createRoot(webXml.getVersion());
        webXml.write(root);
        Document doc = new Document();
        doc.setDocType(WebXmlWriter.createDocType(webXml.getVersion()));
        doc.setRootElement(root);
        return doc;
    }

    private static Element createRoot(WebXml.Version v) {
        if (v != WebXml.Version.V2_4) {
            return new Element("web-app");
        }
        Element root = new Element("web-app", J2EE_NS_URI);
        root.setAttribute("id", "WebApp_ID");
        root.setAttribute("version", v.value());
        root.setAttribute("schemaLocation", J2EE_SCHEMA_LOCATION, Namespace.getNamespace(XSI_NS_PREFIX, XSI_NS_URI));
        return root;
    }

    private static DocType createDocType(WebXml.Version v) {
        if (v == WebXml.Version.V2_2) {
            DocType dt = new DocType("web-app");
            dt.setPublicID("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
            dt.setSystemID("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd");
            return dt;
        }
        if (v == WebXml.Version.V2_3) {
            DocType dt = new DocType("web-app");
            dt.setPublicID("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
            dt.setSystemID("http://java.sun.com/dtd/web-app_2_3.dtd");
            return dt;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(Document doc, File output) throws IOException {
        BufferedWriter w;
        XMLOutputter outputter;
        block7: {
            outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            FileOutputStream out = new FileOutputStream(output);
            w = null;
            try {
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)out, UTF8_ENCODING));
                out = null;
                Object var7_6 = null;
                if (out == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (out == null) throw throwable;
                try {
                    ((OutputStream)out).close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            ((OutputStream)out).close();
        }
        try {
            outputter.output(doc, (Writer)w);
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            ((Writer)w).close();
            throw throwable;
        }
        ((Writer)w).close();
    }

    public static void write(WebXml webXml, File output) throws IOException {
        WebXmlWriter writer = new WebXmlWriter();
        Document doc = writer.createDocument(webXml);
        writer.write(doc, output);
    }
}

