/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.ntlm;

import com.day.j2ee.ntlm.NTLMAuthenticator;
import com.day.j2ee.ntlm.NTLMCallContext;
import com.day.j2ee.ntlm.NTLMDomain;
import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.RequestImpl;
import com.day.j2ee.servletengine.ResponseImpl;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.netbios.NBException;
import com.day.smb.ntlm.Base64;
import com.day.smb.ntlm.Header;
import com.day.smb.ntlm.Message;
import com.day.smb.ntlm.NTLMPrincipal;
import com.day.smb.ntlm.Type1Message;
import com.day.smb.ntlm.Type2Message;
import com.day.smb.ntlm.Type3Message;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTLMAuthenticationHandler
implements NTLMCallContext,
Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final String NTLM_PREFIX = "NTLM ";
    private static final int NONE = 0;
    private static final int CHALLENGED = 1;
    private static final int RESPONDED = 2;
    private final NTLMAuthenticator authenticator;
    private final Map attributes = new HashMap();
    private Principal principal;
    private int state;
    private NTLMDomain domain;
    private byte[] challenge;

    public NTLMAuthenticationHandler(NTLMAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public boolean handle(RequestImpl req, ResponseImpl res) {
        Message message = null;
        String value = req.getHeader("Authorization");
        if (value != null && value.startsWith(NTLM_PREFIX)) {
            message = NTLMAuthenticationHandler.decodeMessage(value.substring(NTLM_PREFIX.length()));
        }
        if (message instanceof Type1Message) {
            this.reset();
        }
        switch (this.state) {
            case 0: {
                if (message == null) break;
                if (message instanceof Type1Message) {
                    return this.handleChallenge(req, res, (Type1Message)message);
                }
                SEL.warn("Expected Type1 message, got: {}", (Object)message);
                break;
            }
            case 1: {
                if (message == null) break;
                if (message instanceof Type3Message) {
                    this.handleResponse((Type3Message)message);
                    break;
                }
                SEL.warn("Expected Type3 message, got: {}", (Object)message);
                break;
            }
            case 2: {
                if (message == null) break;
                SEL.warn("Unexpected message: {}", (Object)message);
            }
        }
        if (this.principal != null) {
            req.setUserPrincipal(this.principal, "NTLM");
        }
        return false;
    }

    public void reset() {
        this.principal = null;
        this.state = 0;
        if (this.domain != null) {
            this.domain.release(this);
            this.domain = null;
        }
        this.challenge = null;
    }

    private static Message decodeMessage(String encoded) {
        byte[] data = Base64.decode((String)encoded);
        SmbInput smbIn = new SmbInput(data);
        Header hdr = new Header();
        try {
            hdr.read(smbIn);
        }
        catch (SmbException e) {
            SEL.warn("Unable to parse message header: {}", (Object)e.getMessage());
            if (SEL.isDebugEnabled()) {
                SEL.debug("Stack trace: ", (Throwable)e);
            }
            return null;
        }
        Type1Message message = null;
        switch (hdr.getType()) {
            case 1: {
                message = new Type1Message();
                break;
            }
            case 2: {
                message = new Type2Message();
                break;
            }
            case 3: {
                message = new Type3Message(true);
            }
        }
        try {
            message.read(smbIn);
        }
        catch (SmbException e) {
            SEL.warn("Unable to parse message: {}", (Object)e.getMessage());
            if (SEL.isDebugEnabled()) {
                SEL.debug("Stack trace: ", (Throwable)e);
            }
            return null;
        }
        return message;
    }

    private boolean handleChallenge(RequestImpl req, ResponseImpl res, Type1Message in) {
        String name = in.getDomain();
        if (name == null) {
            try {
                name = this.authenticator.getDomain(req.getRemoteInetAddress());
            }
            catch (NBException e) {
                SEL.warn("Unable to determine domain of client {}: {}.", (Object)req.getRemoteHost(), (Object)e.getMessage());
            }
        }
        if (name == null) {
            this.domain = this.authenticator.getAnonymousDomain();
            if (this.domain == null) {
                SEL.warn("Unable to get anonymous domain.");
                return false;
            }
        } else {
            this.domain = this.authenticator.getDomain(name);
            if (this.domain == null) {
                SEL.warn("Unable to find domain {}.", (Object)name);
                return false;
            }
        }
        SmbOutput smbOut = new SmbOutput();
        try {
            Type2Message out = this.domain.challenge(this, in);
            this.challenge = out.getChallenge();
            out.write(smbOut);
        }
        catch (SmbException e) {
            SEL.warn("Unable to get challenge from domain: {}", (Object)e.getMessage());
            if (SEL.isDebugEnabled()) {
                SEL.debug("Stack trace: ", (Throwable)e);
            }
            return false;
        }
        String encoded = Base64.encode((byte[])smbOut.toByteArray());
        res.setHeader("WWW-Authenticate", NTLM_PREFIX + encoded);
        res.setStatus(401);
        this.state = 1;
        return true;
    }

    private void handleResponse(Type3Message in) {
        block2: {
            this.principal = new NTLMPrincipal(in.getUserName(), in.getWorkstation(), this.domain.getName(), this.challenge, in.getNtlmResponse());
            try {
                this.domain.validate(this, in);
            }
            catch (SmbException e) {
                SEL.warn("Unable to validate response: {}", (Object)e.getMessage());
                if (!SEL.isDebugEnabled()) break block2;
                SEL.debug("Stack trace: ", (Throwable)e);
            }
        }
        this.state = 2;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }
}

