/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.portal;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.Servlet;
import com.day.j2ee.config.ServletMapping;
import com.day.j2ee.config.WebXml;
import com.day.j2ee.config.WebXmlReader;
import com.day.j2ee.config.WebXmlWriter;
import com.day.j2ee.server.Server;
import com.day.j2ee.server.Util;
import com.day.j2ee.server.ZipCreator;
import com.day.j2ee.server.ZipExtractor;
import com.day.j2ee.servletengine.Constants;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Converter286
implements Constants {
    private static final String PORTLET_XML = "WEB-INF/portlet.xml";
    private static final String WEB_XML_FILE = "WEB-INF" + File.separator + "web.xml";
    private static final String PORTLET_SERVLET = "cqportal";
    private static final String PORTLET_SERVLET_PATH = "/SlingPortletInvoker";
    private static final String PORTLET_SERVLET_CLASS = "org.apache.sling.portal.container.api.ContainerServlet";
    private final File file;
    private File tmpDir;
    private WebXml webXml;

    private Converter286(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() throws IOException, ConfigException {
        this.tmpDir = File.createTempFile("svr", null, Server.getTempDirectory());
        this.tmpDir.delete();
        this.tmpDir.mkdir();
        try {
            ZipExtractor.extract(this.file, this.tmpDir);
            this.loadWebXml();
            this.addPortletServlet();
            this.saveWebXml();
            ZipCreator.create(this.tmpDir, this.file);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Util.rmdir(this.tmpDir);
            throw throwable;
        }
        Util.rmdir(this.tmpDir);
    }

    private void loadWebXml() throws IOException, ConfigException {
        File webXmlFile = new File(this.tmpDir, WEB_XML_FILE);
        this.webXml = webXmlFile.exists() ? WebXmlReader.parse(webXmlFile) : new WebXml(WebXml.Version.V2_3);
    }

    private void addPortletServlet() {
        Servlet servlet = new Servlet();
        servlet.setServletName(PORTLET_SERVLET);
        servlet.setServletClass(PORTLET_SERVLET_CLASS);
        servlet.setLoadOnStartup("1");
        this.webXml.addServlet(servlet);
        ServletMapping servletMapping = new ServletMapping();
        servletMapping.setServletName(PORTLET_SERVLET);
        servletMapping.setUrlPattern(PORTLET_SERVLET_PATH);
        this.webXml.addServletMapping(servletMapping);
    }

    private void saveWebXml() throws IOException {
        File webXmlFile = new File(this.tmpDir, WEB_XML_FILE);
        WebXmlWriter.write(this.webXml, webXmlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File file) throws IOException, ConfigException {
        ZipFile zipFile = new ZipFile(file);
        boolean containsPortlets = false;
        try {
            ZipEntry entry = zipFile.getEntry(PORTLET_XML);
            if (entry != null && !entry.isDirectory()) {
                containsPortlets = true;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            zipFile.close();
            throw throwable;
        }
        zipFile.close();
        if (containsPortlets) {
            new Converter286(file).execute();
        }
    }
}

