/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.portal;

import com.day.j2ee.portal.AbstractNode;
import com.day.j2ee.portal.Portlet;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class PortletXml
extends AbstractNode
implements EntityResolver {
    private static final String RESOURCE_NAME = "/resources/dtd/portlet-app_1_0.xsd";
    public static final String SYSTEM_ID = "http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd";
    private static final String ELEMENT_PORTLET = "portlet";
    private Map portlets = new HashMap();

    private PortletXml() {
    }

    public static PortletXml load(InputSource source) throws ParserConfigurationException, SAXException, IOException {
        PortletXml portletXml = new PortletXml();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(portletXml);
        Document document = builder.parse(source);
        portletXml.read(document);
        return portletXml;
    }

    private void read(Document document) {
        Element element = document.getDocumentElement();
        NodeList list = element.getElementsByTagName(ELEMENT_PORTLET);
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Portlet portlet = new Portlet();
                portlet.read((Element)list.item(i));
                this.portlets.put(portlet.getPortletName(), portlet);
            }
        }
    }

    public Map getPortlets() {
        return this.portlets;
    }

    public Portlet getPortlet(String name) {
        return (Portlet)this.portlets.get(name);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream in = null;
        if (systemId.equals(RESOURCE_NAME)) {
            in = this.getClass().getResourceAsStream(RESOURCE_NAME);
        }
        if (in != null) {
            return new InputSource(in);
        }
        return null;
    }
}

