/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.HttpFilter;
import com.day.util.GlobPattern;
import java.util.Iterator;

class AccessConstraint {
    private ChildConstraint[] constraints = new ChildConstraint[0];

    AccessConstraint() {
    }

    public void init(com.day.j2ee.config.AccessConstraint config) {
        Iterator iter = config.getFilters().iterator();
        while (iter.hasNext()) {
            this.addConstraint(new ChildConstraint((HttpFilter)iter.next()));
        }
    }

    protected void addConstraint(ChildConstraint c) {
        ChildConstraint[] cs = new ChildConstraint[this.constraints.length + 1];
        System.arraycopy(this.constraints, 0, cs, 0, cs.length - 1);
        cs[cs.length - 1] = c;
        this.constraints = cs;
    }

    public boolean isOperationAllowed(String ipAddr, String httpMethod) {
        boolean isAllowed = true;
        for (int i = 0; i < this.constraints.length; ++i) {
            ChildConstraint c = this.constraints[i];
            if (!c.applies(ipAddr, httpMethod)) continue;
            isAllowed = c.allowed;
        }
        return isAllowed;
    }

    class ChildConstraint {
        public final GlobPattern ipAddr;
        public final String httpMethod;
        public final boolean allowed;

        public ChildConstraint(HttpFilter filter) {
            this.ipAddr = filter.getIPAddress() != null ? new GlobPattern(filter.getIPAddress()) : null;
            this.httpMethod = filter.getHttpMethod();
            this.allowed = filter.isAllowed();
        }

        boolean applies(String ipAddr, String httpMethod) {
            if (this.ipAddr != null && !this.ipAddr.matches(ipAddr)) {
                return false;
            }
            return this.httpMethod == null || this.httpMethod.equalsIgnoreCase(httpMethod);
        }
    }
}

