/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.server.LogFile;
import com.day.j2ee.server.Server;
import com.day.j2ee.servletengine.RequestImpl;
import com.day.j2ee.servletengine.ResponseImpl;
import com.day.util.Queue;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

class AccessLogger
implements Runnable {
    private Appender appender;
    private Category category = new Category("");
    private final Queue accesses = new Queue();
    private static final SimpleDateFormat accessLogDateFmt = new SimpleDateFormat("[dd/MMM/yyyy:HH:mm:ss ", Locale.US);
    private static final DecimalFormat dfmt = new DecimalFormat("0000]");
    public static final String DEFAULT_FORMAT = "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"";
    private Formatter formatter;
    private Appender logAppender;

    public AccessLogger(Appender appender, String format) {
        this.appender = appender;
        this.formatter = this.createFormatter(format);
    }

    public AccessLogger(Appender appender) {
        this(appender, DEFAULT_FORMAT);
    }

    public AccessLogger(LogFile lf) throws IOException {
        this.appender = this.logAppender = this.createFileAppender(lf);
        this.formatter = this.createFormatter(lf.getPattern());
    }

    protected Formatter createFormatter(String format) {
        return new CompositeFormatter(format);
    }

    public void start() {
        Thread thread = new Thread((Runnable)this, "AccessLogger");
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.accesses.close();
        if (this.logAppender != null) {
            this.logAppender.close();
        }
    }

    public void logAccess(String requestURI, RequestImpl req, ResponseImpl res) {
        this.accesses.enqueue(this.formatter.format(requestURI, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String logTime(Date date) {
        StringBuffer logTime = new StringBuffer();
        SimpleDateFormat simpleDateFormat = accessLogDateFmt;
        synchronized (simpleDateFormat) {
            logTime.append(accessLogDateFmt.format(date));
        }
        int tzOffset = AccessLogger.getTimezoneOffset(date);
        tzOffset /= 60000;
        tzOffset = tzOffset / 60 * 100 + tzOffset % 60;
        logTime.append(dfmt.format(tzOffset));
        return logTime.toString();
    }

    protected static int getTimezoneOffset(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(15) + cal.get(16);
    }

    private final RollingFileAppender createFileAppender(LogFile lf) throws IOException {
        RollingFileAppender logAppender;
        File logFile = Server.getAbsolutePath(lf.getFilename());
        logFile.getParentFile().mkdirs();
        try {
            logAppender = new RollingFileAppender((org.apache.log4j.Layout)new Layout(), logFile.getPath(), true);
        }
        catch (IOException e) {
            throw new IOException(MessageFormat.format("unable to open log file {0}: {1}", logFile.getPath(), e.getMessage()));
        }
        logAppender.setMaxBackupIndex(lf.getMaxBackupIndex());
        logAppender.setMaxFileSize(lf.getMaxFileSize());
        return logAppender;
    }

    public final void run() {
        try {
            while (true) {
                String s = (String)this.accesses.dequeue();
                this.appender.doAppend(new LoggingEvent(null, (org.apache.log4j.Category)this.category, (Priority)Level.DEBUG, (Object)s, null));
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    static {
        dfmt.setPositivePrefix("+");
        dfmt.setNegativePrefix("-");
    }

    class Layout
    extends org.apache.log4j.Layout {
        Layout() {
        }

        public String format(LoggingEvent event) {
            return event.getRenderedMessage();
        }

        public boolean ignoresThrowable() {
            return true;
        }

        public void activateOptions() {
        }
    }

    class CompositeFormatter
    implements Formatter {
        private static final int PS_START = 0;
        private static final int PS_FORMAT = 1;
        private static final int PS_ATTRIBUTE = 2;
        private static final int PS_ATTRIBUTE_END = 3;
        private final Formatter[] formatters;

        public CompositeFormatter(String format) {
            this.formatters = this.parse(format);
        }

        public String format(String requestURI, RequestImpl req, ResponseImpl res) {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < this.formatters.length; ++i) {
                String value = this.formatters[i].format(requestURI, req, res);
                if (value == null) {
                    value = "-";
                }
                b.append(value);
            }
            b.append('\n');
            return b.toString();
        }

        private Formatter[] parse(String format) {
            ArrayList<Formatter> formatters = new ArrayList<Formatter>();
            String attribute = null;
            char[] ach = format.toCharArray();
            int last = 0;
            int state = 0;
            block6: for (int i = 0; i < ach.length; ++i) {
                char ch = ach[i];
                switch (state) {
                    case 0: {
                        if (ch != '%') continue block6;
                        if (i - last > 0) {
                            String literal = format.substring(last, i);
                            formatters.add(new LiteralFormatter(literal));
                        }
                        attribute = null;
                        state = 1;
                        continue block6;
                    }
                    case 1: {
                        if (ch == '{') {
                            last = i + 1;
                            state = 2;
                            continue block6;
                        }
                        formatters.add(new DirectiveFormatter(ch));
                        last = i + 1;
                        state = 0;
                        continue block6;
                    }
                    case 2: {
                        if (ch != '}') continue block6;
                        if (i - last > 0) {
                            attribute = format.substring(last, i);
                        }
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        formatters.add(new DirectiveFormatter(ch, attribute));
                        last = i + 1;
                        state = 0;
                    }
                }
            }
            if (state == 0 && ach.length - last > 0) {
                String literal = format.substring(last, ach.length);
                formatters.add(new LiteralFormatter(literal));
            }
            Formatter[] result = new Formatter[formatters.size()];
            formatters.toArray(result);
            return result;
        }
    }

    class LiteralFormatter
    implements Formatter {
        private final String literal;

        public LiteralFormatter(String literal) {
            this.literal = literal;
        }

        public String format(String requestURI, RequestImpl req, ResponseImpl res) {
            return this.literal;
        }
    }

    class DirectiveFormatter
    implements Formatter {
        private final char ch;
        private final String attribute;

        public DirectiveFormatter(char ch, String attribute) {
            this.ch = ch;
            this.attribute = attribute;
        }

        public DirectiveFormatter(char ch) {
            this(ch, null);
        }

        public String format(String requestURI, RequestImpl req, ResponseImpl res) {
            switch (this.ch) {
                case 'h': {
                    String s = req.getHeader("x-forwarded-for");
                    if (s != null) {
                        int idx = s.lastIndexOf(32);
                        if (idx != -1) {
                            s = s.substring(idx + 1);
                        }
                    } else {
                        s = req.getHeader("via");
                        if (s != null) {
                            int idx = s.lastIndexOf("received=");
                            s = idx != -1 ? s.substring(idx += "received=".length()) : null;
                        }
                        if (s == null) {
                            s = req.getRemoteAddr();
                        }
                    }
                    return s;
                }
                case 'u': {
                    return req.getRemoteUser();
                }
                case 't': {
                    return AccessLogger.this.logTime(new Date());
                }
                case 'r': {
                    String method = req.getHeader("cq-action");
                    if (method == null) {
                        method = req.getMethod();
                    }
                    return method + " " + requestURI + " " + req.getProtocol();
                }
                case 's': {
                    return String.valueOf(res.getStatus());
                }
                case 'b': {
                    int contentLength = req.getContentLength();
                    if (contentLength == -1) break;
                    return String.valueOf(contentLength);
                }
                case 'i': {
                    if (this.attribute == null) break;
                    return req.getHeader(this.attribute);
                }
                case 'o': {
                    if (this.attribute == null) break;
                    return res.getHeader(this.attribute);
                }
            }
            return null;
        }
    }

    static interface Formatter {
        public String format(String var1, RequestImpl var2, ResponseImpl var3);
    }

    class Category
    extends org.apache.log4j.Category {
        public Category(String name) {
            super(name);
        }
    }
}

