/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.RequestImpl;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BoundedInputStream
extends FilterInputStream
implements Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final int READ_TIMEOUT = 2000;
    private final RequestImpl request;
    private long limit;
    private boolean closed;

    public BoundedInputStream(RequestImpl request, InputStream in, long limit) {
        super(in);
        if (limit < 0L) {
            throw new IllegalArgumentException("0 >= " + String.valueOf(limit));
        }
        this.limit = limit;
        this.request = request;
    }

    public int read() throws IOException {
        if (!this.closed) {
            int c;
            if (this.limit > 0L) {
                c = this.in.read();
                if (c != -1) {
                    --this.limit;
                }
            } else {
                c = -1;
            }
            return c;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.closed) {
            int read;
            if (this.limit > 0L) {
                int readMax;
                int chunkLen;
                int nlimit = Integer.MAX_VALUE;
                if (this.limit < Integer.MAX_VALUE) {
                    nlimit = (int)this.limit;
                }
                if ((chunkLen = this.in.read(b, off, readMax = Math.min(len, nlimit))) > 0) {
                    this.limit -= (long)chunkLen;
                }
                read = chunkLen;
            } else {
                read = -1;
            }
            return read;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void finish() {
        block16: {
            if (this.limit > 0L) {
                block15: {
                    SEL.debug("Finishing up {} unread bytes", (Object)String.valueOf(this.limit));
                    try {
                        this.request.setReadTimeout(2000);
                    }
                    catch (IOException e) {
                        SEL.warn("I/O error while setting timeout to {} ms: {}", (Object)String.valueOf(2000), (Object)e.getMessage());
                        return;
                    }
                    int skipped = 0;
                    skipped = (int)this.in.skip(this.limit);
                    if ((long)skipped == this.limit) break block15;
                    SEL.debug("Skipped {} bytes only, {} expected", (Object)(skipped == -1 ? String.valueOf(0) : String.valueOf(skipped)), (Object)String.valueOf(this.limit));
                    this.request.disableKeepAlive();
                }
                Object var4_3 = null;
                try {
                    this.request.setReadTimeout(0);
                }
                catch (IOException e2) {
                    SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                    this.request.disableKeepAlive();
                }
                break block16;
                {
                    catch (SocketException e) {
                        SEL.debug("socket error while finishing input: {}", (Object)e.getMessage());
                        Object var4_4 = null;
                        try {
                            this.request.setReadTimeout(0);
                        }
                        catch (IOException e2) {
                            SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                            this.request.disableKeepAlive();
                        }
                        break block16;
                    }
                    catch (InterruptedIOException e) {
                        SEL.warn("socket timeout while finishing input after {} ms", (Object)String.valueOf(2000));
                        Object var4_5 = null;
                        try {
                            this.request.setReadTimeout(0);
                        }
                        catch (IOException e2) {
                            SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                            this.request.disableKeepAlive();
                        }
                        break block16;
                    }
                    catch (IOException e) {
                        SEL.warn("I/O error while finishing input: {}", (Object)e.getMessage());
                        Object var4_6 = null;
                        try {
                            this.request.setReadTimeout(0);
                        }
                        catch (IOException e2) {
                            SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                            this.request.disableKeepAlive();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    try {
                        this.request.setReadTimeout(0);
                    }
                    catch (IOException e2) {
                        SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                        this.request.disableKeepAlive();
                    }
                    throw throwable;
                }
            }
        }
    }

    public void close() {
        if (!this.closed) {
            this.finish();
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closed = true;
        }
    }
}

