/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.RequestImpl;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChunkedBodyInputStream
extends FilterInputStream
implements Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final int READ_TIMEOUT = 2000;
    private static final int SIZE = 0;
    private static final int EXTENSION = 1;
    private static final int CHUNK = 2;
    private static final int CRLF_SIZE = 3;
    private static final int CRLF_CHUNK = 4;
    private static final int LAST_CHUNK_READ = 5;
    private static final int FINISHED = 6;
    private final RequestImpl request;
    private boolean closed;
    private byte[] chunk = new byte[0];
    private int chunkptr = 0;
    private int state = 0;
    private int crlfCnt = 0;

    public ChunkedBodyInputStream(RequestImpl request, InputStream in) {
        super(in);
        this.request = request;
    }

    public int read() throws IOException {
        if (!this.closed) {
            int c = -1;
            if (this.chunkptr < this.chunk.length) {
                c = this.chunk[this.chunkptr++];
            } else if (this.hasMoreChunks()) {
                this.chunk = this.nextChunk();
                c = this.chunk[this.chunkptr++];
            }
            return c;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.closed) {
            int bytesRead = 0;
            if (this.chunkptr < this.chunk.length) {
                int lenToCopy = Math.min(len, this.chunk.length - this.chunkptr);
                System.arraycopy(this.chunk, this.chunkptr, b, off, lenToCopy);
                this.chunkptr += lenToCopy;
                off += lenToCopy;
                len -= lenToCopy;
                bytesRead = lenToCopy;
            } else if (len > 0 && this.hasMoreChunks()) {
                this.chunk = this.nextChunk();
                int lenToCopy = Math.min(len, this.chunk.length - this.chunkptr);
                System.arraycopy(this.chunk, this.chunkptr, b, off, lenToCopy);
                this.chunkptr += lenToCopy;
                off += lenToCopy;
                len -= lenToCopy;
                bytesRead = lenToCopy;
            }
            return bytesRead == 0 && len > 0 ? -1 : bytesRead;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void finish() {
        block16: {
            SEL.debug("Finishing up unread bytes.");
            try {
                this.request.setReadTimeout(2000);
            }
            catch (IOException e) {
                SEL.warn("I/O error while setting timeout to {} ms: {}", (Object)String.valueOf(2000), (Object)e.getMessage());
                return;
            }
            int skipped = 0;
            if (this.chunkptr < this.chunk.length) {
                skipped = this.chunk.length - this.chunkptr;
            }
            while (this.hasMoreChunks()) {
                this.chunk = this.nextChunk();
                skipped += this.chunk.length;
            }
            SEL.debug("Skipped {} bytes.", (Object)String.valueOf(skipped += this.skipTrailers()));
            Object var3_6 = null;
            try {
                this.request.setReadTimeout(0);
            }
            catch (IOException e2) {
                SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                this.request.disableKeepAlive();
            }
            break block16;
            {
                catch (SocketException e) {
                    SEL.warn("socket error while finishing input: {}", (Object)e.getMessage());
                    Object var3_7 = null;
                    try {
                        this.request.setReadTimeout(0);
                    }
                    catch (IOException e2) {
                        SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                        this.request.disableKeepAlive();
                    }
                    break block16;
                }
                catch (InterruptedIOException e) {
                    SEL.warn("socket timeout while finishing input after {} ms", (Object)String.valueOf(2000));
                    Object var3_8 = null;
                    try {
                        this.request.setReadTimeout(0);
                    }
                    catch (IOException e2) {
                        SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                        this.request.disableKeepAlive();
                    }
                    break block16;
                }
                catch (IOException e) {
                    SEL.warn("I/O error while finishing input: {}", (Object)e.getMessage());
                    Object var3_9 = null;
                    try {
                        this.request.setReadTimeout(0);
                    }
                    catch (IOException e2) {
                        SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                        this.request.disableKeepAlive();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_10 = null;
                try {
                    this.request.setReadTimeout(0);
                }
                catch (IOException e2) {
                    SEL.warn("I/O error while resetting timeout back: {}", (Object)e2.getMessage());
                    this.request.disableKeepAlive();
                }
                throw throwable;
            }
        }
    }

    public void close() {
        if (!this.closed) {
            this.finish();
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closed = true;
        }
    }

    public byte[] getData() throws IOException {
        int length = 0;
        byte[] data = new byte[]{};
        ArrayList<byte[]> l = new ArrayList<byte[]>();
        while (this.hasMoreChunks()) {
            byte[] chunk = this.nextChunk();
            l.add(chunk);
            length += chunk.length;
        }
        if (length > 0) {
            data = new byte[length];
            int pos = 0;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                byte[] c = (byte[])it.next();
                System.arraycopy(c, 0, data, pos, c.length);
                pos += c.length;
            }
        }
        return data;
    }

    private byte[] nextChunk() throws IOException {
        byte[] b = new byte[]{};
        StringBuffer sizeBuff = new StringBuffer();
        boolean chunkRead = false;
        int chunksize = 0;
        while (this.state != 5 && this.state != 6 && !chunkRead) {
            int r = -1;
            if (this.state != 2 && (r = this.in.read()) == -1) {
                this.state = 6;
                String msg = "Unexpected end of file while processing chunk stream.";
                throw new IOException(msg);
            }
            char c = (char)r;
            this.controlCRLF(c);
            switch (this.state) {
                case 0: {
                    if (c == ';' || c == '\r') {
                        try {
                            String hexStr = sizeBuff.toString().trim();
                            chunksize = Integer.parseInt(hexStr, 16);
                            sizeBuff = new StringBuffer();
                            if (c == ';') {
                                this.state = 1;
                                break;
                            }
                            this.state = 3;
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.state = 6;
                            String msg = "Invalid or missing chunk size: " + e.getMessage();
                            throw new IOException(msg);
                        }
                    }
                    sizeBuff.append(c);
                    break;
                }
                case 1: {
                    if (c != '\r') break;
                    this.state = 3;
                    break;
                }
                case 3: {
                    String msg;
                    if (c != '\n') {
                        this.state = 6;
                        msg = "CRLF expected after chunk-size and optional extensions.";
                        throw new IOException(msg);
                    }
                    if (chunksize == 0) {
                        this.state = 5;
                        break;
                    }
                    this.state = 2;
                    break;
                }
                case 4: {
                    if (c == '\r') break;
                    if (c == '\n') {
                        chunkRead = true;
                        this.state = 0;
                        break;
                    }
                    this.state = 6;
                    String msg = "CRLF expected after chunk.";
                    throw new IOException(msg);
                }
                case 2: {
                    int readBytes;
                    b = new byte[chunksize];
                    for (int off = 0; off < chunksize; off += readBytes) {
                        readBytes = this.in.read(b, off, chunksize - off);
                        if (readBytes > 0) continue;
                        this.state = 6;
                        String msg = "Unable to finish reading complete chunk consisting of " + chunksize + " bytes";
                        throw new IOException(msg);
                    }
                    this.state = 4;
                    break;
                }
                case 6: {
                    SEL.warn("Unexpected second CRLF encountered before 0-sized chunk was reached.");
                }
            }
        }
        this.chunkptr = 0;
        return b;
    }

    private boolean hasMoreChunks() {
        return this.state != 5 && this.state != 6;
    }

    private void controlCRLF(char c) {
        if (c != '\r' && c != '\n') {
            this.crlfCnt = 0;
            return;
        }
        if (c == '\r' && this.crlfCnt % 2 != 0) {
            SEL.warn("Invalid chunked body: Expected LF after CR");
        }
        if (c == '\n' && this.crlfCnt % 2 != 1) {
            SEL.warn("Invalid chunked body: Expecting CR or data after LF, additional LF is not allowed.");
        }
        ++this.crlfCnt;
        if (this.crlfCnt == 4) {
            this.state = 6;
        }
    }

    private int skipTrailers() throws IOException {
        int skipped = 0;
        int readBytes = 0;
        int ptr = 0;
        byte[] b = new byte[2048];
        while (this.state != 6) {
            if (ptr < readBytes) {
                char c = (char)b[ptr++];
                this.controlCRLF(c);
                continue;
            }
            skipped += ptr;
            ptr = 0;
            readBytes = this.in.read(b);
            if (readBytes > 0) continue;
            this.state = 6;
        }
        return skipped += ptr;
    }
}

