/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommandLineArgs
implements Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private String address;
    private int port;
    private String contextDir;
    private int logLevel = -1;
    private final ArrayList files = new ArrayList();
    private static final String[] logLevels = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"};

    CommandLineArgs() {
    }

    public static CommandLineArgs parseArgs(String[] args) {
        CommandLineArgs cmdLineArgs = new CommandLineArgs();
        cmdLineArgs.parseInternal(args);
        return cmdLineArgs;
    }

    protected void parseInternal(String[] args) {
        boolean noMoreOptions = false;
        int argc = 0;
        block13: while (argc < args.length) {
            String arg = args[argc++];
            if (noMoreOptions) {
                this.addFile(arg);
                continue;
            }
            if (arg.startsWith("-")) {
                if (arg.length() != 2) {
                    SEL.warn("Missing option name");
                }
                String value = argc < args.length ? args[argc++] : null;
                switch (arg.charAt(1)) {
                    case 'l': {
                        if (value == null) {
                            SEL.warn("Missing log level value");
                            continue block13;
                        }
                        try {
                            this.logLevel = Integer.parseInt(value);
                            if (this.logLevel >= 0 && this.logLevel <= 5) continue block13;
                            this.logLevel = -1;
                            SEL.warn("Bad log level: " + value);
                        }
                        catch (RuntimeException e) {
                            SEL.warn("Bad log level: " + value);
                        }
                        break;
                    }
                    case 'd': {
                        SEL.info("The -d command line parameter is deprecated: use -c instead.");
                        break;
                    }
                    case 'c': {
                        if (value == null) {
                            SEL.warn("Missing directory value");
                            continue block13;
                        }
                        this.contextDir = value;
                        break;
                    }
                    case 'p': {
                        if (value == null) {
                            SEL.warn("Missing port value");
                            continue block13;
                        }
                        try {
                            this.port = Integer.parseInt(value);
                        }
                        catch (RuntimeException e) {
                            SEL.warn("Bad port: " + value);
                        }
                        break;
                    }
                    case 'a': {
                        if (value == null) {
                            SEL.warn("Missing address value");
                            continue block13;
                        }
                        this.address = value;
                        break;
                    }
                    case 'X': {
                        break;
                    }
                    case '-': {
                        noMoreOptions = true;
                        break;
                    }
                    default: {
                        SEL.warn("Unrecognized option " + arg);
                    }
                }
                continue;
            }
            noMoreOptions = true;
            this.addFile(arg);
        }
    }

    private void addFile(String s) {
        this.files.add(new File(s));
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getContextDir() {
        return this.contextDir;
    }

    public String getLogLevel() {
        return this.logLevel == -1 ? null : logLevels[this.logLevel];
    }

    public File[] getFiles() {
        File[] result = new File[this.files.size()];
        this.files.toArray(result);
        return result;
    }
}

