/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.ConfigProperty;
import com.day.j2ee.config.ResourceAdapterXml;
import com.day.j2ee.config.ResourceAdapterXmlReader;
import com.day.j2ee.deploy.DeployException;
import com.day.j2ee.server.Server;
import com.day.j2ee.server.Util;
import com.day.j2ee.server.ZipExtractor;
import com.day.j2ee.servletengine.ServletContainer;
import com.day.j2ee.servletengine.ServletEngine;
import com.day.util.PatternFileFilter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connector
implements com.day.j2ee.deploy.Connector,
ConnectionManager {
    private static final String CONNECTOR = "connector";
    Logger logger;
    private ClassLoader parentLoader;
    private ServletContainer container;
    private ClassLoader loader;
    private ResourceAdapterXml raXml;
    private File file;
    private File directory;
    private boolean started;
    private final com.day.j2ee.config.Connector config;
    private String label;
    private List connections = new LinkedList();

    public Connector(com.day.j2ee.config.Connector config) {
        this.config = config;
    }

    public void init(ClassLoader parentLoader, ServletContainer container) throws IOException, ConfigException {
        this.parentLoader = parentLoader;
        this.container = container;
        String flatPath = this.config.getJndiName().replace('/', '_');
        File path = Server.getAbsolutePath(this.config.getPath());
        if (!path.exists()) {
            throw new IOException("connector " + path + " not found");
        }
        if (path.isDirectory()) {
            this.file = null;
            this.directory = path;
        } else {
            this.file = path;
            this.directory = new File(container.getRuntimeFolder(), flatPath);
            if (this.directory.exists() && this.directory.lastModified() < this.file.lastModified() && !Util.rmdir(this.directory)) {
                this.directory = new File(container.getTempFolder(), Long.toHexString(System.currentTimeMillis()));
            }
        }
        if (this.file != null) {
            this.extractRAR();
        }
        ResourceAdapterXmlReader reader = new ResourceAdapterXmlReader();
        reader.read(new File(this.directory, "META-INF/ra.xml"));
        this.raXml = reader.getRaXml();
        this.setupLogger();
        this.setupLoader(parentLoader);
    }

    private void reinit() {
        this.setupLoader(this.parentLoader);
    }

    private void setupLogger() {
        String name = this.getLabel().replace('.', '_');
        this.logger = LoggerFactory.getLogger((String)("connector-" + name));
    }

    private void setupLoader(ClassLoader parentLoader) {
        if (this.loader == null) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            try {
                urlList.add(this.directory.toURL());
            }
            catch (MalformedURLException e) {
                this.logger.warn("Unable to add root folder to loader", (Throwable)e);
            }
            File[] libs = this.directory.listFiles(new PatternFileFilter("*.jar"));
            if (libs != null) {
                for (int i = 0; i < libs.length; ++i) {
                    try {
                        urlList.add(libs[i].toURL());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        this.logger.warn("Unable to add library " + libs[i], (Throwable)e);
                    }
                }
            }
            URL[] urls = new URL[urlList.size()];
            urlList.toArray(urls);
            this.loader = new URLClassLoader(urls, parentLoader);
            if (this.logger.isInfoEnabled()) {
                this.logger.debug("Classpath of connector:");
                for (int i = 0; i < urls.length; ++i) {
                    this.logger.debug(" - {}", (Object)Connector.toFilename(urls[i]));
                }
            }
        }
    }

    private static final String toFilename(URL url) {
        String filename = url.getFile();
        if ((filename = filename.replace('/', File.separatorChar)).startsWith("\\")) {
            filename = filename.substring(1);
        }
        return filename;
    }

    private void extractRAR() throws IOException {
        File src = this.file;
        File dst = this.directory;
        if (!dst.exists() || src.lastModified() > dst.lastModified()) {
            Util.clean(dst);
            ZipExtractor.extract(src, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!this.started) {
            Object cf;
            this.logger.debug("Start connector");
            this.reinit();
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.loader);
                cf = this.createConnectionFactory();
            }
            catch (Throwable e) {
                this.log("Connector unavailable", e);
                return;
            }
            finally {
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
            try {
                InitialContext initCtx = new InitialContext(ServletEngine.DEFAULT_ENVIRONMENT);
                Context ctx = (Context)initCtx.lookup(this.container.getLabel());
                ctx.bind(this.getJndiName(), cf);
            }
            catch (NamingException e) {
                this.logger.error("Unable to bind connector: {}", (Object)e.getMessage());
                return;
            }
            this.started = true;
        }
    }

    private Object createConnectionFactory() throws ResourceException {
        ManagedConnectionFactory mcf;
        String mcfClassName = this.raXml.getResourceAdapter().getMcfClass();
        try {
            Class<?> mcfClass = this.loader.loadClass(mcfClassName);
            mcf = (ManagedConnectionFactory)mcfClass.newInstance();
        }
        catch (Exception e) {
            ResourceException re = new ResourceException("Unable to instantiate managed connection factory class: " + mcfClassName);
            re.setLinkedException(e);
            throw re;
        }
        mcf.setLogWriter(new PrintWriter((Writer)new LogWriter(), true));
        try {
            Iterator iter = this.raXml.getResourceAdapter().getConfigProperties().iterator();
            while (iter.hasNext()) {
                ConfigProperty property = (ConfigProperty)iter.next();
                String name = property.getName();
                String type = property.getType();
                String value = property.getValue();
                ConfigProperty runtime = this.config.getProperty(property.getName());
                if (runtime != null) {
                    value = runtime.getValue();
                }
                if (value == null) continue;
                Connector.setProperty(mcf, name, type, value);
            }
        }
        catch (IllegalArgumentException e) {
            ResourceException re = new ResourceException("Error while setting properties on managed connection factory class: " + mcfClassName);
            re.setLinkedException((Exception)e);
            throw re;
        }
        return mcf.createConnectionFactory((ConnectionManager)this);
    }

    private static void setProperty(Object o, String name, String type, String value) throws IllegalArgumentException {
        Class<?> parameterType;
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            parameterType = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find config property class: " + type);
        }
        Object arg = Connector.valueOf(parameterType, value);
        try {
            Method method = o.getClass().getMethod(methodName, parameterType);
            method.invoke(o, arg);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to access method: " + methodName);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Method does not exist: " + methodName);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Error while invoking " + methodName + ": " + e.getMessage());
        }
    }

    private static Object valueOf(Class clazz, String s) {
        if (clazz == String.class) {
            return s;
        }
        if (clazz == Character.class) {
            return new Character(s.charAt(0));
        }
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            return method.invoke(null, s);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to access method: " + clazz.getName() + ".valueOf");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Method does not exist: " + clazz.getName() + ".valueOf");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Error while invoking " + clazz.getName() + ".valueOf:" + e.getMessage());
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.logger.debug("Stop connector");
            Iterator iter = this.connections.iterator();
            while (iter.hasNext()) {
                ManagedConnection mc = (ManagedConnection)iter.next();
                try {
                    mc.cleanup();
                }
                catch (ResourceException e) {
                    this.logger.warn("Unable to cleanup connection {}: {}", (Object)mc, (Object)e.getMessage());
                }
                iter.remove();
            }
            try {
                InitialContext initCtx = new InitialContext(ServletEngine.DEFAULT_ENVIRONMENT);
                Context ctx = (Context)initCtx.lookup(this.container.getLabel());
                ctx.unbind(this.getJndiName());
            }
            catch (NamingException e) {
                this.logger.error("Unable to unbind connector: {}", (Object)e.getMessage());
            }
            this.loader = null;
            this.started = false;
            System.gc();
        }
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.raXml != null && this.raXml.getDisplayName() != null ? this.raXml.getDisplayName() : this.config.getJndiName();
        }
        return this.label;
    }

    public String getJndiName() {
        return this.config.getJndiName();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void undeploy() throws DeployException {
        this.container.removeConnector(this);
    }

    com.day.j2ee.config.Connector getConfig() {
        return this.config;
    }

    void cleanup() {
        if (this.file != null && !Util.rmdir(this.directory)) {
            this.logger.warn("Unable to remove all files in: " + this.directory);
        }
    }

    private void log(String message, Throwable throwable) {
        this.logger.error(message, throwable);
        while (throwable instanceof ResourceException && (throwable = ((ResourceException)throwable).getLinkedException()) != null) {
            this.logger.error("Root cause", throwable);
        }
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo info) throws ResourceException {
        ManagedConnection mc = mcf.createManagedConnection(null, info);
        this.connections.add(mc);
        return mc.getConnection(null, info);
    }

    class LogWriter
    extends Writer {
        private boolean closed;

        LogWriter() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (!this.closed) {
                Connector.this.logger.info(new String(cbuf, off, len));
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
            }
        }
    }
}

