/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

class EventMulticaster
implements ServletContextListener,
ServletContextAttributeListener,
HttpSessionListener,
HttpSessionAttributeListener,
ServletRequestListener,
ServletRequestAttributeListener {
    private final List contextListeners = new ArrayList();
    private ServletContextListener[] cachedContextListeners;
    private final List ctxtAttrListeners = new ArrayList();
    private ServletContextAttributeListener[] cachedCtxtAttrListeners;
    private final List sessionListeners = new ArrayList();
    private HttpSessionListener[] cachedSessionListeners;
    private final List sessAttrListeners = new ArrayList();
    private HttpSessionAttributeListener[] cachedSessAttrListeners;
    private final List requestListeners = new ArrayList();
    private ServletRequestListener[] cachedRequestListeners;
    private final List reqAttrListeners = new ArrayList();
    private ServletRequestAttributeListener[] cachedReqAttrListeners;

    EventMulticaster() {
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContextListener[] listeners = this.getContextListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].contextInitialized(event);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContextListener[] listeners = this.getContextListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].contextDestroyed(event);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        ServletContextAttributeListener[] listeners = this.getCtxtAttrListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].attributeAdded(event);
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        ServletContextAttributeListener[] listeners = this.getCtxtAttrListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].attributeReplaced(event);
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        ServletContextAttributeListener[] listeners = this.getCtxtAttrListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].attributeRemoved(event);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSessionListener[] listeners = this.getSessionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].sessionCreated(event);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSessionListener[] listeners = this.getSessionListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].sessionDestroyed(event);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        HttpSessionAttributeListener[] listeners = this.getSessAttrListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].attributeAdded(event);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        HttpSessionAttributeListener[] listeners = this.getSessAttrListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].attributeReplaced(event);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        HttpSessionAttributeListener[] listeners = this.getSessAttrListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].attributeRemoved(event);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        ServletRequestListener[] listeners = this.getRequestListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].requestInitialized(event);
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
        ServletRequestListener[] listeners = this.getRequestListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].requestDestroyed(event);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent event) {
        ServletRequestAttributeListener[] listeners = this.getReqAttrListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].attributeAdded(event);
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        ServletRequestAttributeListener[] listeners = this.getReqAttrListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].attributeRemoved(event);
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        ServletRequestAttributeListener[] listeners = this.getReqAttrListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].attributeReplaced(event);
        }
    }

    public boolean addListener(Object obj) {
        int interfacesImplemented = 0;
        if (obj instanceof ServletContextListener) {
            this.contextListeners.add(obj);
            this.cachedContextListeners = null;
            ++interfacesImplemented;
        }
        if (obj instanceof ServletContextAttributeListener) {
            this.ctxtAttrListeners.add(obj);
            this.cachedCtxtAttrListeners = null;
            ++interfacesImplemented;
        }
        if (obj instanceof HttpSessionListener) {
            this.sessionListeners.add(obj);
            this.cachedSessionListeners = null;
            ++interfacesImplemented;
        }
        if (obj instanceof HttpSessionAttributeListener) {
            this.sessAttrListeners.add(obj);
            this.cachedSessAttrListeners = null;
            ++interfacesImplemented;
        }
        if (obj instanceof ServletRequestListener) {
            this.requestListeners.add(obj);
            this.cachedRequestListeners = null;
            ++interfacesImplemented;
        }
        if (obj instanceof ServletRequestAttributeListener) {
            this.reqAttrListeners.add(obj);
            this.cachedReqAttrListeners = null;
            ++interfacesImplemented;
        }
        return interfacesImplemented > 0;
    }

    private ServletContextListener[] getContextListeners() {
        if (this.cachedContextListeners == null) {
            this.cachedContextListeners = new ServletContextListener[this.contextListeners.size()];
            this.contextListeners.toArray(this.cachedContextListeners);
        }
        return this.cachedContextListeners;
    }

    private ServletContextAttributeListener[] getCtxtAttrListeners() {
        if (this.cachedCtxtAttrListeners == null) {
            this.cachedCtxtAttrListeners = new ServletContextAttributeListener[this.ctxtAttrListeners.size()];
            this.ctxtAttrListeners.toArray(this.cachedCtxtAttrListeners);
        }
        return this.cachedCtxtAttrListeners;
    }

    private HttpSessionListener[] getSessionListeners() {
        if (this.cachedSessionListeners == null) {
            this.cachedSessionListeners = new HttpSessionListener[this.sessionListeners.size()];
            this.sessionListeners.toArray(this.cachedSessionListeners);
        }
        return this.cachedSessionListeners;
    }

    private HttpSessionAttributeListener[] getSessAttrListeners() {
        if (this.cachedSessAttrListeners == null) {
            this.cachedSessAttrListeners = new HttpSessionAttributeListener[this.sessAttrListeners.size()];
            this.sessAttrListeners.toArray(this.cachedSessAttrListeners);
        }
        return this.cachedSessAttrListeners;
    }

    private ServletRequestListener[] getRequestListeners() {
        if (this.cachedRequestListeners == null) {
            this.cachedRequestListeners = new ServletRequestListener[this.requestListeners.size()];
            this.requestListeners.toArray(this.cachedRequestListeners);
        }
        return this.cachedRequestListeners;
    }

    private ServletRequestAttributeListener[] getReqAttrListeners() {
        if (this.cachedReqAttrListeners == null) {
            this.cachedReqAttrListeners = new ServletRequestAttributeListener[this.reqAttrListeners.size()];
            this.requestListeners.toArray(this.cachedReqAttrListeners);
        }
        return this.cachedReqAttrListeners;
    }

    public void clear() {
        this.contextListeners.clear();
        this.cachedContextListeners = null;
        this.ctxtAttrListeners.clear();
        this.cachedCtxtAttrListeners = null;
        this.sessionListeners.clear();
        this.cachedSessionListeners = null;
        this.sessAttrListeners.clear();
        this.cachedSessAttrListeners = null;
        this.requestListeners.clear();
        this.cachedRequestListeners = null;
        this.reqAttrListeners.clear();
        this.cachedReqAttrListeners = null;
    }
}

