/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.Dispatcher;
import com.day.j2ee.config.Filter;
import com.day.j2ee.config.FilterMapping;
import com.day.util.GlobPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class FilterMap {
    private final List patternMappings = new ArrayList();
    private final Map servletMappings = new HashMap();

    FilterMap() {
    }

    public void put(FilterMapping mapping, Filter filter) throws IllegalArgumentException {
        String pattern = mapping.getUrlPattern();
        if (pattern != null) {
            int index = pattern.indexOf(42);
            if (index != -1 && index != 0 && index != pattern.length() - 1) {
                throw new IllegalArgumentException("Illegal mapping specification " + pattern);
            }
            this.patternMappings.add(new PatternMapping(mapping, filter));
        } else {
            ArrayList<ServletMapping> list = (ArrayList<ServletMapping>)this.servletMappings.get(mapping.getServletName());
            if (list == null) {
                list = new ArrayList<ServletMapping>();
                this.servletMappings.put(mapping.getServletName(), list);
            }
            list.add(new ServletMapping(mapping, filter));
        }
    }

    public Filter[] map(String path, String servletName, Dispatcher dispatcher) {
        List l;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (path != null) {
            for (int i = 0; i < this.patternMappings.size(); ++i) {
                PatternMapping m = (PatternMapping)this.patternMappings.get(i);
                if (!m.mapping.getDispatchers().contains(dispatcher) || !m.pattern.matches(path)) continue;
                filters.add(m.filter);
            }
        }
        if (servletName != null && (l = (List)this.servletMappings.get(servletName)) != null) {
            for (int i = 0; i < l.size(); ++i) {
                ServletMapping m = (ServletMapping)l.get(i);
                if (!m.mapping.getDispatchers().contains(dispatcher)) continue;
                filters.add(m.filter);
            }
        }
        Filter[] result = null;
        if (filters.size() > 0) {
            result = new Filter[filters.size()];
            filters.toArray(result);
        }
        return result;
    }

    class ServletMapping {
        public final FilterMapping mapping;
        public final Filter filter;

        public ServletMapping(FilterMapping mapping, Filter filter) {
            this.mapping = mapping;
            this.filter = filter;
        }
    }

    class PatternMapping {
        public final GlobPattern pattern;
        public final FilterMapping mapping;
        public final Filter filter;

        public PatternMapping(FilterMapping mapping, Filter filter) {
            this.pattern = new GlobPattern(mapping.getUrlPattern());
            this.mapping = mapping;
            this.filter = filter;
        }
    }
}

