/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.Listener;
import com.day.j2ee.servletengine.AccessConstraint;
import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.ServletContainer;
import com.day.j2ee.servletengine.ServletHandlerImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListener
implements com.day.j2ee.deploy.Listener,
Constants {
    protected static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    protected int port;
    protected int backlog = 100;
    private static final int DEFAULT_HTTP_KEEP_ALIVE_TIMEOUT = 15000;
    private static final int DEFAULT_REQUEST_HANDLING_BUFFER_SIZE = 8192;
    protected String host;
    protected InetAddress addr;
    AccessConstraint accessConstraint;
    ServletContainer container;
    ServerSocket server;
    private String displayName;
    protected Boolean keepAlive;
    protected Integer receiveBufferSize;
    protected Integer sendBufferSize;
    protected Integer lingerDelay;
    protected Integer soTimeout;
    protected Boolean tcpNoDelay;
    protected Boolean httpKeepAliveEnabled;
    protected Integer httpKeepAliveTimeout;
    protected Integer requestHandlingBufferSize;
    protected int maxThreads = 200;
    protected WorkerStack workers;
    protected volatile boolean running;
    protected int curThreadsBusy;
    protected int curThreads;

    public void loadFromConfig(Listener config) throws ConfigException {
        this.setPort(config.getBindPort() != null ? config.getBindPort() : 80);
        if (config.getBindAddress() != null) {
            this.setHost(config.getBindAddress());
        }
        if (config.getBacklog() != null) {
            this.backlog = config.getBacklog();
        }
        if (config.getAccessConstraint() != null) {
            this.accessConstraint = new AccessConstraint();
            this.accessConstraint.init(config.getAccessConstraint());
        }
        this.keepAlive = config.getKeepAlive();
        this.receiveBufferSize = config.getRcvBufferSize();
        this.sendBufferSize = config.getSndBufferSize();
        this.lingerDelay = config.getLingerDelay();
        this.soTimeout = config.getTimeout();
        this.tcpNoDelay = config.getTcpNoDelay();
        if (config.getMaxCount() != null) {
            this.maxThreads = config.getMaxCount();
        }
        this.httpKeepAliveEnabled = config.getHttpKeepAlive();
        Integer timeoutSeconds = config.getHttpKeepAliveTimeout();
        if (timeoutSeconds != null) {
            this.httpKeepAliveTimeout = new Integer(timeoutSeconds * 1000);
        }
        this.requestHandlingBufferSize = config.getRequestHandlingBufferSize();
    }

    void setContainer(ServletContainer container) {
        this.container = container;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    void start() throws IOException {
        if (!this.running) {
            this.running = true;
            this.workers = new WorkerStack(this.maxThreads);
            this.server = this.startServer();
            Thread acceptorThread = new Thread((Runnable)new Acceptor(), this.getDisplayName());
            acceptorThread.setPriority(5);
            acceptorThread.setDaemon(true);
            acceptorThread.start();
        }
    }

    void stop() {
        if (this.running) {
            this.running = false;
            if (this.server != null) {
                try {
                    this.server.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.server = null;
            }
            this.workers.close();
        }
    }

    public InetAddress getInetAddress() {
        InetAddress addr = this.addr;
        if (addr == null) {
            addr = new InetSocketAddress((InetAddress)null, this.port).getAddress();
        }
        return addr;
    }

    public String getListenerAddress() {
        return this.getInetAddress().getHostAddress();
    }

    public String getDescription() {
        return MessageFormat.format("{0} listener on address {1}, port {2}", this.getScheme().toUpperCase(), this.getListenerAddress(), String.valueOf(this.port));
    }

    public final boolean isHttpKeepAliveEnabled() {
        return this.httpKeepAliveEnabled == null || this.httpKeepAliveEnabled != false;
    }

    public final int getHttpKeepAliveTimeout() {
        return this.httpKeepAliveTimeout == null ? 15000 : this.httpKeepAliveTimeout;
    }

    public void setHttpKeepAliveTimeout(int timeout) {
        this.httpKeepAliveTimeout = new Integer(timeout);
    }

    protected ServerSocket startServer() throws IOException {
        SEL.debug("Starting {}", (Object)this.getDescription());
        if (!this.isHttpKeepAliveEnabled()) {
            SEL.debug("HTTP Keep-Alive for {} disabled", (Object)this.getDescription());
        }
        if (this.host != null) {
            this.addr = InetAddress.getByName(this.host);
        }
        ServerSocket server = new ServerSocket(this.port, this.backlog, this.addr);
        if (this.port == 0) {
            this.port = server.getLocalPort();
        }
        server.setSoTimeout(15000);
        return server;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return "http";
    }

    public final int getRequestHandlingBufferSize() {
        return this.requestHandlingBufferSize == null ? 8192 : this.requestHandlingBufferSize;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = "CQSE Listener [" + this.getListenerAddress() + ":" + String.valueOf(this.port) + "]";
        }
        return this.displayName;
    }

    protected boolean processSocket(Socket socket) {
        try {
            this.getWorkerThread().assign(socket);
        }
        catch (Throwable t) {
            SEL.error("Error while assigning socket", t);
            return false;
        }
        return true;
    }

    protected boolean setSocketOptions(Socket socket) {
        try {
            if (this.keepAlive != null) {
                socket.setKeepAlive(this.keepAlive);
            }
            if (this.receiveBufferSize != null) {
                socket.setReceiveBufferSize(this.receiveBufferSize);
            }
            if (this.sendBufferSize != null) {
                socket.setSendBufferSize(this.sendBufferSize);
            }
            socket.setSoLinger(true, this.lingerDelay != null ? this.lingerDelay : 100);
            socket.setTcpNoDelay(this.tcpNoDelay != null ? this.tcpNoDelay : true);
            socket.setSoTimeout(this.soTimeout != null ? this.soTimeout * 1000 : 20000);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker createWorkerThread() {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            if (this.workers.size() > 0) {
                ++this.curThreadsBusy;
                return this.workers.pop();
            }
            if (this.curThreads < this.maxThreads) {
                ++this.curThreadsBusy;
                if (this.curThreadsBusy == this.maxThreads) {
                    SEL.warn("Maximum thread number reached: " + this.maxThreads);
                }
                return this.newWorkerThread();
            }
            return null;
        }
    }

    protected Worker newWorkerThread() {
        Worker workerThread = new Worker();
        workerThread.start();
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker getWorkerThread() {
        Worker workerThread = this.createWorkerThread();
        while (workerThread == null) {
            try {
                WorkerStack workerStack = this.workers;
                synchronized (workerStack) {
                    this.workers.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            workerThread = this.createWorkerThread();
        }
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleWorkerThread(Worker workerThread) {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            this.workers.push(workerThread);
            --this.curThreadsBusy;
            this.workers.notify();
        }
    }

    class WorkerStack {
        private final Worker[] workers;
        private int size;

        public WorkerStack(int size) {
            this.workers = new Worker[size];
        }

        public void push(Worker worker) {
            if (this.size < this.workers.length) {
                this.workers[this.size++] = worker;
            } else {
                --HttpListener.this.curThreads;
            }
        }

        public Worker pop() {
            if (this.size > 0) {
                return this.workers[--this.size];
            }
            return null;
        }

        public int size() {
            return this.size;
        }

        public void close() {
            for (int i = 0; i < this.size; ++i) {
                this.workers[i].assign(null);
            }
        }
    }

    protected class Worker
    implements Runnable {
        private Thread thread;
        private boolean available;
        private Socket socket;
        private final ServletHandlerImpl handler;

        Worker() {
            this.handler = new ServletHandlerImpl(HttpListener.this.container, HttpListener.this.getRequestHandlingBufferSize(), HttpListener.this.isHttpKeepAliveEnabled(), HttpListener.this.getHttpKeepAliveTimeout(), HttpListener.this.getScheme(), HttpListener.this.accessConstraint);
        }

        synchronized void assign(Socket socket) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.available = true;
            this.notifyAll();
        }

        private synchronized Socket await() {
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            Socket socket = this.socket;
            this.available = false;
            this.notifyAll();
            return socket;
        }

        public void run() {
            while (HttpListener.this.running) {
                Socket socket = this.await();
                if (socket == null) continue;
                if (!HttpListener.this.setSocketOptions(socket)) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.handler.process(socket);
                socket = null;
                HttpListener.this.recycleWorkerThread(this);
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName(HttpListener.this.getDisplayName() + ":Thread-" + ++HttpListener.this.curThreads);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        public void run() {
            while (HttpListener.this.running) {
                try {
                    Socket socket = HttpListener.this.server.accept();
                    if (HttpListener.this.processSocket(socket)) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (SocketTimeoutException e) {
                }
                catch (IOException e) {
                    if (!HttpListener.this.running) continue;
                    SEL.error("Error while accepting socket", (Throwable)e);
                }
                catch (Throwable t) {
                    SEL.error("Error while accepting socket", t);
                }
            }
        }
    }
}

