/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.HttpSessionManager;
import com.day.j2ee.servletengine.WebApplication;
import com.day.util.UUID;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpSessionImpl
implements HttpSession,
Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private Map attributes;
    private final long creationTime;
    private long accessTime;
    private int lifeTime;
    private boolean httpOnly;
    private final String id;
    private boolean old;
    private boolean invalid;
    private final WebApplication application;
    private final HttpSessionManager parent;

    public HttpSessionImpl(HttpSessionManager parent, WebApplication application, int lifeTime, boolean httpOnly, String sessionid) {
        this.parent = parent;
        this.application = application;
        this.accessTime = this.creationTime = System.currentTimeMillis();
        this.id = sessionid != null ? sessionid : new UUID().toString();
        this.lifeTime = lifeTime;
        this.httpOnly = httpOnly;
    }

    void destroy() {
        this.application.sessionDestroyed(new HttpSessionEvent(this));
        if (this.attributes != null) {
            SEL.debug("cleaning up session with id {}", (Object)this.id);
            Iterator iter = this.attributes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, name, value);
                if (value instanceof HttpSessionBindingListener) {
                    ((HttpSessionBindingListener)value).valueUnbound(event);
                }
                this.application.sessionAttributeRemoved(event);
            }
            this.attributes = null;
        }
    }

    void setInvalid() {
        this.invalid = true;
    }

    public long getCreationTime() {
        this.checkValid();
        return this.creationTime;
    }

    public String getId() {
        this.checkValid();
        return this.id;
    }

    public boolean getHttpOnly() {
        return this.httpOnly;
    }

    public long getLastAccessedTime() {
        this.checkValid();
        return this.accessTime;
    }

    public void setMaxInactiveInterval(int interval) {
        if (!this.invalid) {
            this.lifeTime = interval;
        }
    }

    public int getMaxInactiveInterval() {
        return this.lifeTime;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        this.checkValid();
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public Object getValue(String name) {
        this.checkValid();
        return this.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        this.checkValid();
        if (this.attributes == null) {
            return new Vector().elements();
        }
        return Collections.enumeration(this.attributes.keySet());
    }

    public String[] getValueNames() {
        this.checkValid();
        if (this.attributes == null) {
            return new String[0];
        }
        return this.attributes.keySet().toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        this.checkValid();
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        Object old = this.attributes.put(name, value);
        HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, name, value);
        if (old == null) {
            this.application.sessionAttributeAdded(event);
        } else {
            this.application.sessionAttributeReplaced(event);
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkValid();
        if (this.attributes != null) {
            Object value = this.attributes.remove(name);
            if (value == null) {
                return;
            }
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, name, value);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(event);
            }
            this.application.sessionAttributeRemoved(event);
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.checkValid();
        this.parent.invalidateSession(this);
    }

    public boolean isNew() {
        this.checkValid();
        return !this.old;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public boolean isValid() {
        if (!this.invalid && this.isOutdated()) {
            this.invalidate();
        }
        return !this.invalid;
    }

    private boolean isOutdated() {
        long idleTime = (System.currentTimeMillis() - this.accessTime) / 1000L;
        if (this.lifeTime >= 0 && idleTime >= (long)this.lifeTime) {
            if (SEL.isDebugEnabled()) {
                SEL.debug("session {} is outdated (idle time: {}s)", (Object)this.id, (Object)new Long(idleTime));
                SEL.debug("session dump:\n{}", (Object)this);
            }
            return true;
        }
        if (SEL.isDebugEnabled()) {
            SEL.info("session {} is not outdated (idle time: {}s)", (Object)this.id, (Object)new Long(idleTime));
            SEL.debug("session dump:\n{}", (Object)this);
        }
        return false;
    }

    public void touch() {
        if (!this.invalid) {
            this.accessTime = new Date().getTime();
            this.old = true;
        }
    }

    public void checkValid() throws IllegalStateException {
        if (this.invalid) {
            throw new IllegalStateException("session is invalid");
        }
    }

    WebApplication getApplication() {
        return this.application;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("  accessTime: ");
        b.append(new Date(this.accessTime));
        b.append("\n  creationTime: ");
        b.append(new Date(this.creationTime));
        b.append("\n  isNew: ");
        b.append(String.valueOf(!this.old));
        b.append("\n  lifeTime: ");
        b.append(this.lifeTime);
        b.append(" seconds\n  sessionId: ");
        b.append(this.id);
        return b.toString();
    }
}

