/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.Dispatcher;
import com.day.j2ee.config.ErrorPage;
import com.day.j2ee.deploy.StartupFailedException;
import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.DirectoryServlet;
import com.day.j2ee.servletengine.RequestImpl;
import com.day.j2ee.servletengine.ResponseImpl;
import com.day.j2ee.servletengine.ServletContainer;
import com.day.j2ee.servletengine.ServletWrapper;
import com.day.j2ee.servletengine.URLPath;
import com.day.j2ee.servletengine.Util;
import com.day.j2ee.servletengine.WebApplication;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestDispatcherImpl
implements RequestDispatcher,
FilterChain,
Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private final ServletContainer container;
    private WebApplication application;
    private FilterChain chain;
    private ServletWrapper servlet;
    private URLPath urlPath;
    private final ServletWrapper directoryServlet = new DirectoryServlet();

    public RequestDispatcherImpl(ServletContainer container, String path) {
        this.container = container;
        try {
            this.urlPath = this.parseURL(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public RequestDispatcherImpl(ServletContainer container) {
        this.container = container;
    }

    public RequestDispatcherImpl(ServletContainer container, WebApplication application, ServletWrapper servlet) {
        this.container = container;
        this.application = application;
        this.servlet = servlet;
        this.chain = null;
        this.urlPath = new URLPath(application.getContextPath(), "/");
        this.urlPath.setServletPath("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ResponseImpl res;
        RequestImpl req;
        if (this.servlet == null) {
            HttpServletResponse hsr;
            if (response instanceof HttpServletResponse && !(hsr = (HttpServletResponse)response).isCommitted()) {
                hsr.sendError(404);
            }
            return;
        }
        try {
            req = this.unwrap(request);
            res = this.unwrap(response);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("request or response not of required type");
        }
        String oldPath = req.getRequestURI();
        String oldContextPath = req.getContextPath();
        String oldPathInfo = req.getPathInfo();
        String oldQueryString = req.getQueryString();
        String oldServletPath = req.getServletPath();
        req.reset();
        res.resetBuffer();
        req.setURLPath(this.urlPath);
        req.setApplication(this.application);
        res.setApplication(this.application);
        try {
            req.setAttribute("javax.servlet.forward.request_uri", oldPath, false);
            req.setAttribute("javax.servlet.forward.context_path", oldContextPath, false);
            req.setAttribute("javax.servlet.forward.path_info", oldPathInfo, false);
            req.setAttribute("javax.servlet.forward.query_string", oldQueryString, false);
            req.setAttribute("javax.servlet.forward.servlet_path", oldServletPath, false);
            req.pushParameters(this.urlPath.getQueryString());
            this.chain = this.application.createFilterChain(this.urlPath.getRelativePath(), this.servlet.getServletName(), this, Dispatcher.FORWARD);
            try {
                this.service(request, response);
            }
            catch (ServletException e) {
                SEL.info("Servlet threw exception: ", Util.getRootCause(e));
                this.error(req, res, e);
            }
            if (res.isError()) {
                this.error(req, res);
            }
        }
        finally {
            if (response instanceof ResponseImpl) {
                ((ResponseImpl)response).setSuspended(true);
            }
            req.popParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ResponseImpl res;
        RequestImpl req;
        if (this.servlet == null) {
            HttpServletResponse hsr;
            if (response instanceof HttpServletResponse && !(hsr = (HttpServletResponse)response).isCommitted()) {
                hsr.sendError(404);
            }
            return;
        }
        try {
            req = this.unwrap(request);
            res = this.unwrap(response);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("request or response not of required type: " + e.getMessage());
        }
        Object oldPath = null;
        Object oldContextPath = null;
        Object oldPathInfo = null;
        Object oldQueryString = null;
        Object oldServletPath = null;
        WebApplication oldApplication = null;
        try {
            oldPath = req.getAttribute("javax.servlet.include.request_uri");
            oldContextPath = req.getAttribute("javax.servlet.include.context_path");
            oldPathInfo = req.getAttribute("javax.servlet.include.path_info");
            oldQueryString = req.getAttribute("javax.servlet.include.query_string");
            oldServletPath = req.getAttribute("javax.servlet.include.servlet_path");
            oldApplication = req.getApplication();
            req.setAttribute("javax.servlet.include.request_uri", this.urlPath.getRequestURI(), false);
            req.setAttribute("javax.servlet.include.context_path", this.urlPath.getContextPath(), false);
            req.setAttribute("javax.servlet.include.path_info", this.urlPath.getPathInfo(), false);
            req.setAttribute("javax.servlet.include.query_string", this.urlPath.getQueryString(), false);
            req.setAttribute("javax.servlet.include.servlet_path", this.urlPath.getServletPath(), false);
            req.setApplication(this.application);
            res.setApplication(this.application);
            req.pushParameters(this.urlPath.getQueryString());
            res.beforeInclude();
            this.chain = this.application.createFilterChain(this.urlPath.getRelativePath(), this.servlet.getServletName(), this, Dispatcher.INCLUDE);
            this.service(request, response);
            res.afterInclude();
            req.popParameters();
            req.setApplication(oldApplication);
            res.setApplication(oldApplication);
            req.setAttribute("javax.servlet.include.request_uri", oldPath, false);
            req.setAttribute("javax.servlet.include.context_path", oldContextPath, false);
            req.setAttribute("javax.servlet.include.path_info", oldPathInfo, false);
            req.setAttribute("javax.servlet.include.query_string", oldQueryString, false);
            req.setAttribute("javax.servlet.include.servlet_path", oldServletPath, false);
        }
        catch (Throwable throwable) {
            res.afterInclude();
            req.popParameters();
            req.setApplication(oldApplication);
            res.setApplication(oldApplication);
            req.setAttribute("javax.servlet.include.request_uri", oldPath, false);
            req.setAttribute("javax.servlet.include.context_path", oldContextPath, false);
            req.setAttribute("javax.servlet.include.path_info", oldPathInfo, false);
            req.setAttribute("javax.servlet.include.query_string", oldQueryString, false);
            req.setAttribute("javax.servlet.include.servlet_path", oldServletPath, false);
            throw throwable;
        }
    }

    protected URLPath parseURL(String path) throws FileNotFoundException {
        int protocolEnd;
        this.application = null;
        this.servlet = null;
        this.chain = null;
        if (!path.startsWith("/") && (protocolEnd = path.indexOf("://")) != -1) {
            int hostPortEnd = path.indexOf(47, protocolEnd + 3);
            if (hostPortEnd == -1) {
                throw new FileNotFoundException();
            }
            path = path.substring(hostPortEnd);
        }
        URLPath urlPath = new URLPath(path);
        this.application = this.container.map(urlPath);
        if (this.application == null) {
            throw new FileNotFoundException();
        }
        if (urlPath.getRemaining().equals("")) {
            this.servlet = this.directoryServlet;
        } else {
            if (!this.application.isStarted()) {
                if ("suspended".equals(this.application.getRunOnStartup())) {
                    try {
                        this.application.start();
                    }
                    catch (StartupFailedException e) {
                        SEL.error("Unable to start " + this.application.getLabel(), (Throwable)e);
                        throw new FileNotFoundException();
                    }
                } else {
                    throw new FileNotFoundException();
                }
            }
            this.servlet = this.application.map(urlPath);
            if (this.servlet == null) {
                throw new FileNotFoundException();
            }
        }
        return urlPath;
    }

    public void doFilter(ServletRequest req, ServletResponse res) throws IOException, ServletException {
        this.servlet.service(req, res);
    }

    protected void service(ServletRequest req, ServletResponse res) throws IOException, ServletException {
        Object o = null;
        try {
            o = this.application.enter();
            FilterChain chain = this.chain;
            if (chain == null) {
                chain = this;
            }
            chain.doFilter(req, res);
        }
        catch (RuntimeException e) {
            throw new ServletException("Unhandled exception in servlet", e);
        }
        catch (Error e) {
            throw new ServletException("Error occurred in servlet", e);
        }
        finally {
            this.application.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String path, RequestImpl req, ResponseImpl res) throws IOException, ServletException {
        URLPath urlPath;
        try {
            urlPath = this.parseURL(path);
        }
        catch (FileNotFoundException e) {
            if (!res.isCommitted()) {
                res.sendError(404);
            }
            return;
        }
        req.setURLPath(urlPath);
        req.setApplication(this.application);
        res.setApplication(this.application);
        try {
            this.application.requestInitialized(req);
            this.chain = this.application.createFilterChain(urlPath.getRelativePath(), this.servlet.getServletName(), this, Dispatcher.REQUEST);
            try {
                this.service(req, res);
            }
            catch (ServletException e) {
                SEL.info("Servlet threw exception: ", Util.getRootCause(e));
                this.error(req, res, e);
            }
            if (res.isError() && !res.isCommitted()) {
                this.error(req, res);
            }
            this.application.requestDestroyed(req);
        }
        finally {
            this.servlet = null;
            this.chain = null;
            this.application = null;
        }
    }

    void error(RequestImpl req, ResponseImpl res, ServletException e) throws IOException, ServletException {
        URLPath urlPath;
        ServletWrapper servlet;
        ErrorPage errorPage;
        Throwable t = e.getRootCause();
        if (t == null) {
            t = e;
        }
        if ((errorPage = this.application.getErrorPage(t)) != null && (servlet = this.application.map(urlPath = new URLPath(this.application.getContextPath(), errorPage.getLocation()))) != null) {
            this.error(servlet, urlPath, req, res, t);
            return;
        }
        res.setStatus(500);
        res.setError();
    }

    void error(RequestImpl req, ResponseImpl res) throws IOException, ServletException {
        URLPath urlPath;
        ServletWrapper servlet;
        res.setSuspended(false);
        int status = res.getStatus();
        ErrorPage errorPage = this.application.getErrorPage(status);
        if (errorPage != null && (servlet = this.application.map(urlPath = new URLPath(this.application.getContextPath(), errorPage.getLocation()))) != null) {
            this.error(servlet, urlPath, req, res, null);
            return;
        }
        if (status != 304 && status != 204) {
            res.setContentType("text/html");
            PrintWriter writer = res.getWriter();
            writer.println("<html><head><title>");
            writer.println(String.valueOf(status));
            writer.println(" ");
            writer.println(ResponseImpl.reasonPhrase(status));
            writer.println("</title></head><body><h1>");
            writer.println(ResponseImpl.reasonPhrase(status));
            writer.println("</h1>");
            String message = res.getMessage();
            if (message != null) {
                writer.println("<p>");
                writer.println(message);
                writer.println("</p>");
            }
            writer.println("</body></html>");
            writer.flush();
        } else {
            res.setContentLength(0);
        }
    }

    void error(ServletWrapper errorPage, URLPath urlPath, RequestImpl req, ResponseImpl res, Throwable t) throws IOException, ServletException {
        int status = res.getStatus();
        String message = res.getMessage();
        req.reset();
        res.resetBuffer();
        req.setAttribute("javax.servlet.error.request_uri", req.getRequestURI(), false);
        if (this.servlet != null) {
            req.setAttribute("javax.servlet.error.servlet_name", this.servlet.getServletName(), false);
        }
        if (t != null) {
            req.setAttribute("javax.servlet.error.status_code", new Integer(500));
            req.setAttribute("javax.servlet.error.message", t.getMessage());
            req.setAttribute("javax.servlet.error.exception", t);
            req.setAttribute("javax.servlet.error.exception_type", t.getClass());
        } else {
            req.setAttribute("javax.servlet.error.status_code", new Integer(status));
            req.setAttribute("javax.servlet.error.message", message);
        }
        req.setURLPath(urlPath);
        this.servlet = errorPage;
        this.chain = this.application.createFilterChain(urlPath.getRelativePath(), null, this, Dispatcher.ERROR);
        this.service(req, res);
    }

    private RequestImpl unwrap(ServletRequest request) throws ClassCastException {
        while (request instanceof ServletRequestWrapper) {
            request = ((ServletRequestWrapper)request).getRequest();
        }
        return (RequestImpl)request;
    }

    private ResponseImpl unwrap(ServletResponse response) throws ClassCastException {
        while (response instanceof ServletResponseWrapper) {
            response = ((ServletResponseWrapper)response).getResponse();
        }
        return (ResponseImpl)response;
    }
}

