/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.Container;
import com.day.j2ee.config.Listener;
import com.day.j2ee.deploy.DeployException;
import com.day.j2ee.deploy.NoSuchApplicationException;
import com.day.j2ee.deploy.NoSuchConnectorException;
import com.day.j2ee.deploy.StartupFailedException;
import com.day.j2ee.portal.Converter;
import com.day.j2ee.portal.Converter286;
import com.day.j2ee.server.LogFile;
import com.day.j2ee.server.Server;
import com.day.j2ee.servletengine.AccessLogger;
import com.day.j2ee.servletengine.Connector;
import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.HttpListener;
import com.day.j2ee.servletengine.HttpSessionManager;
import com.day.j2ee.servletengine.HttpsListener;
import com.day.j2ee.servletengine.PathMap;
import com.day.j2ee.servletengine.RequestImpl;
import com.day.j2ee.servletengine.ResponseImpl;
import com.day.j2ee.servletengine.ServletEngine;
import com.day.j2ee.servletengine.URLPath;
import com.day.j2ee.servletengine.WebApplication;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainer
implements com.day.j2ee.deploy.ServletContainer,
Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final String DEF_ACCESS_LOG_MAX_FILE_SIZE = "100MB";
    private static final int DEF_ACCESS_LOG_MAX_BACKUP_INDEX = 1;
    private static int nextLabel;
    private final ServletEngine engine;
    private final List listeners = new ArrayList();
    private final List applications = new ArrayList();
    private final List connectors = new ArrayList();
    private final PathMap pathMap = new PathMap();
    private final HttpSessionManager sessionManager = new HttpSessionManager();
    private LogFile lf;
    private AccessLogger accessLogger;
    private ClassLoader parentLoader;
    private final Container config;
    private final String label;
    private boolean portletApi2Available;

    ServletContainer(ServletEngine engine, Container config) {
        this.engine = engine;
        this.config = config;
        this.label = ServletContainer.getNextLabel();
    }

    public ServletContainer() {
        this(null, null);
    }

    void init(ClassLoader parentLoader) throws ConfigException, IOException {
        this.parentLoader = parentLoader;
        if (this.config == null) {
            return;
        }
        if (this.config.getLogFile() != null) {
            LogFile lf = new LogFile("%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"", null, 1, DEF_ACCESS_LOG_MAX_FILE_SIZE);
            this.lf = new LogFile(this.config.getLogFile(), lf);
        }
        try {
            InitialContext ctx = new InitialContext(ServletEngine.DEFAULT_ENVIRONMENT);
            ctx.createSubcontext(this.getLabel());
        }
        catch (NamingException e) {
            SEL.warn("Unable to create JNDI subcontext.", (Throwable)e);
        }
        Iterator iter = this.config.getWebapps().iterator();
        while (iter.hasNext()) {
            WebApplication webapp = new WebApplication((com.day.j2ee.config.WebApplication)iter.next());
            this.addApplication(webapp);
        }
        iter = this.config.getConnectors().iterator();
        while (iter.hasNext()) {
            com.day.j2ee.config.Connector config = (com.day.j2ee.config.Connector)iter.next();
            Connector connector = new Connector(config);
            connector.init(parentLoader, this);
            this.connectors.add(connector);
        }
        iter = this.config.getListeners().iterator();
        while (iter.hasNext()) {
            HttpListener listener;
            Listener lc = (Listener)iter.next();
            if (lc.getSSL() != null) {
                listener = new HttpsListener();
                listener.loadFromConfig(lc);
            } else {
                listener = new HttpListener();
                listener.loadFromConfig(lc);
            }
            this.addListener(listener);
        }
        Class<?> c = null;
        try {
            c = parentLoader.loadClass("javax.portlet.ResourceRequest");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (c != null) {
            String msg = "Portlet API 2.0 detected in classpath.";
            SEL.info(msg);
            this.portletApi2Available = true;
        }
    }

    public void addListener(HttpListener listener) {
        listener.setContainer(this);
        this.listeners.add(listener);
    }

    public void addApplication(WebApplication application) throws ConfigException, IOException {
        this.addApplication(application, this.parentLoader);
    }

    public void addApplication(WebApplication application, ClassLoader parentLoader) throws ConfigException, IOException {
        application.init(parentLoader, this);
        this.pathMap.insert(application.getContext(), application);
        this.applications.add(application);
    }

    public WebApplication addApplication(com.day.j2ee.config.WebApplication webapp) throws ConfigException, IOException {
        WebApplication application = new WebApplication(webapp);
        this.addApplication(application);
        return application;
    }

    protected void removeApplication(WebApplication application) {
        this.pathMap.delete(application.getContext());
        if (application.isStarted()) {
            application.stop();
        }
        application.cleanup();
        this.config.removeWebapp(application.getConfig());
        this.applications.remove(application);
        this.configChanged();
    }

    public Iterator getListeners() {
        return this.listeners.iterator();
    }

    public HttpListener getListener(int index) {
        return (HttpListener)this.listeners.get(index);
    }

    public void addConnector(Connector connector) throws ConfigException, IOException {
        connector.init(this.parentLoader, this);
        this.connectors.add(connector);
    }

    protected void removeConnector(Connector connector) {
        if (connector.isStarted()) {
            connector.stop();
        }
        connector.cleanup();
        this.config.removeConnector(connector.getConfig());
        this.connectors.remove(connector);
        this.configChanged();
    }

    void start() throws IOException {
        SEL.debug("Servlet container start");
        this.startLogger();
        Iterator iter = this.connectors.iterator();
        while (iter.hasNext()) {
            Connector connector = (Connector)iter.next();
            connector.start();
        }
        iter = this.applications.iterator();
        while (iter.hasNext()) {
            WebApplication application = (WebApplication)iter.next();
            if (!"true".equals(application.getRunOnStartup())) continue;
            try {
                application.start();
                this.pathMap.insert(application.getContext(), application);
            }
            catch (StartupFailedException e) {
                SEL.error("Unable to start " + application.getLabel(), (Throwable)e);
            }
        }
        int runningListeners = 0;
        iter = this.listeners.iterator();
        while (iter.hasNext()) {
            HttpListener listener = (HttpListener)iter.next();
            try {
                listener.start();
                ++runningListeners;
                SEL.debug("{} started", (Object)listener.getDescription());
            }
            catch (IOException e) {
                SEL.error("Unable to start {}: {}", (Object)listener.getDescription(), (Object)e.getMessage());
            }
        }
        if (runningListeners == 0) {
            SEL.debug("No listeners active, shutting down servlet container");
            iter = this.applications.iterator();
            while (iter.hasNext()) {
                ((WebApplication)iter.next()).stop();
            }
            this.stopLogger();
            throw new IOException("no listener running");
        }
    }

    private void startLogger() throws IOException {
        if (this.lf != null) {
            this.accessLogger = new AccessLogger(this.lf);
            this.accessLogger.start();
        }
    }

    private void stopLogger() {
        if (this.accessLogger != null) {
            this.accessLogger.stop();
            this.accessLogger = null;
        }
    }

    void stop() {
        int i;
        SEL.debug("Servlet container stop");
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((HttpListener)iter.next()).stop();
        }
        for (i = this.applications.size() - 1; i >= 0; --i) {
            ((WebApplication)this.applications.get(i)).stop();
        }
        for (i = this.connectors.size() - 1; i >= 0; --i) {
            ((Connector)this.connectors.get(i)).stop();
        }
        this.stopLogger();
        this.sessionManager.close();
    }

    public WebApplication map(URLPath urlPath) {
        return (WebApplication)this.pathMap.map(urlPath);
    }

    public HttpSessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected File getTempFolder() {
        return new File(Server.getTempDirectory(), this.label);
    }

    protected File getRuntimeFolder() {
        return new File(Server.getRuntimeDirectory(), this.label);
    }

    protected String resolvePath(String relativePath) {
        return this.getLabel() + "/" + relativePath;
    }

    public void logAccess(String requestURI, RequestImpl req, ResponseImpl res) {
        if (this.accessLogger != null) {
            this.accessLogger.logAccess(requestURI, req, res);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public com.day.j2ee.deploy.WebApplication deploy(String contextPath, File filename) throws DeployException {
        WebApplication application;
        File dest;
        com.day.j2ee.config.WebApplication webappConfig = new com.day.j2ee.config.WebApplication();
        try {
            webappConfig.setContext(contextPath);
        }
        catch (IllegalArgumentException e) {
            throw new DeployException(e.getMessage());
        }
        WebApplication oldApp = this.map(new URLPath(contextPath));
        if (oldApp != null && oldApp.getContext().equals(contextPath)) {
            oldApp.undeploy();
            this.configChanged();
        }
        if ((dest = this.getUniqueFile(contextPath)).exists() && !dest.delete()) {
            throw new DeployException("Unable to delete " + dest.getPath());
        }
        if (!filename.renameTo(dest)) {
            throw new DeployException("Unable to rename " + filename.getPath() + " to " + dest.getPath());
        }
        if (this.portletApi2Available) {
            try {
                Converter286.convert(dest);
            }
            catch (IOException e) {
                throw new DeployException("Unable to process WAR file containing portlets", e);
            }
            catch (ConfigException e) {
                throw new DeployException("Unable to process WAR file containing portlets", e);
            }
        }
        try {
            Converter.convert(dest);
        }
        catch (IOException e) {
            throw new DeployException("Unable to process WAR file containing portlets", e);
        }
        catch (ConfigException e) {
            throw new DeployException("Unable to process WAR file containing portlets", e);
        }
        webappConfig.setPath(Server.getRelativePath(dest));
        webappConfig.setRunOnStartup(String.valueOf(true));
        try {
            application = this.addApplication(webappConfig);
            this.config.addWebapp(webappConfig);
            this.configChanged();
            application.start();
        }
        catch (IOException e) {
            throw new DeployException(e.getMessage());
        }
        catch (ConfigException e) {
            Throwable t = e.getCause();
            if (t == null) {
                t = e;
            }
            throw new DeployException(t.getMessage());
        }
        catch (RuntimeException e) {
            throw new DeployException(e.getMessage(), e);
        }
        return application;
    }

    public com.day.j2ee.deploy.WebApplication getApplication(String contextPath) throws NoSuchApplicationException {
        WebApplication application = this.map(new URLPath(contextPath));
        if (application != null && application.getContext().equals(contextPath)) {
            return application;
        }
        throw new NoSuchApplicationException("No web application found under '" + contextPath + "'");
    }

    public com.day.j2ee.deploy.WebApplication[] getApplications() {
        com.day.j2ee.deploy.WebApplication[] apps = this.applications.toArray(new WebApplication[0]);
        Arrays.sort(apps, new Comparator(){

            public int compare(Object o1, Object o2) {
                WebApplication app1 = (WebApplication)o1;
                WebApplication app2 = (WebApplication)o2;
                return app1.getContext().compareTo(app2.getContext());
            }
        });
        return apps;
    }

    public com.day.j2ee.deploy.Connector getConnector(String jndiName) throws NoSuchConnectorException {
        Iterator iter = this.connectors.iterator();
        while (iter.hasNext()) {
            Connector connector = (Connector)iter.next();
            if (!jndiName.equals(connector.getJndiName())) continue;
            return connector;
        }
        throw new NoSuchConnectorException("Unable to find connector with JNDI name '" + jndiName + "'");
    }

    public com.day.j2ee.deploy.Connector[] getConnectors() {
        com.day.j2ee.deploy.Connector[] conns = this.connectors.toArray(new Connector[0]);
        Arrays.sort(conns, new Comparator(){

            public int compare(Object o1, Object o2) {
                Connector conn1 = (Connector)o1;
                Connector conn2 = (Connector)o2;
                return conn1.getJndiName().compareTo(conn2.getJndiName());
            }
        });
        return conns;
    }

    public com.day.j2ee.deploy.Connector deployConnector(String jndiName, File filename) throws DeployException {
        Connector connector;
        com.day.j2ee.config.Connector newConfig = new com.day.j2ee.config.Connector();
        try {
            newConfig.setJndiName(jndiName);
        }
        catch (IllegalArgumentException e) {
            throw new DeployException(e.getMessage());
        }
        try {
            com.day.j2ee.deploy.Connector oldConn = this.getConnector(jndiName);
            oldConn.undeploy();
        }
        catch (NoSuchConnectorException e) {
            // empty catch block
        }
        File dest = new File(Server.getConnectorsDirectory(), jndiName.replace('/', '_') + ".rar");
        if (dest.exists() && !dest.delete()) {
            throw new DeployException("Unable to delete " + dest.getPath());
        }
        if (!filename.renameTo(dest)) {
            throw new DeployException("Unable to rename " + filename.getPath() + " to " + dest.getPath());
        }
        newConfig.setPath(Server.getRelativePath(dest));
        try {
            connector = new Connector(newConfig);
            connector.init(this.parentLoader, this);
            connector.start();
        }
        catch (IOException e) {
            throw new DeployException(e.getMessage());
        }
        catch (ConfigException e) {
            Throwable t = e.getCause();
            if (t == null) {
                t = e;
            }
            throw new DeployException(t.getMessage());
        }
        this.config.addConnector(newConfig);
        this.configChanged();
        this.connectors.add(connector);
        return connector;
    }

    private File getUniqueFile(String contextPath) {
        String name = (contextPath = contextPath.substring(1)).equals("") ? "ROOT" : contextPath.replace('/', '_');
        return new File(Server.getWebappsDirectory(), name + ".war");
    }

    public void configChanged() {
        this.engine.configChanged();
    }

    public ServletEngine getEngine() {
        return this.engine;
    }

    private static synchronized String getNextLabel() {
        return String.valueOf(nextLabel++);
    }
}

