/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.Admin;
import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.Container;
import com.day.j2ee.deploy.DeployerRuntime;
import com.day.j2ee.deploy.LoginException;
import com.day.j2ee.jndi.JavaObjectFactory;
import com.day.j2ee.ntlm.NTLMAuthenticationHandler;
import com.day.j2ee.ntlm.NTLMAuthenticator;
import com.day.j2ee.server.Server;
import com.day.j2ee.servletengine.CommandLineArgs;
import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.DefaultVersion;
import com.day.j2ee.servletengine.HttpListener;
import com.day.j2ee.servletengine.PropertiesVersion;
import com.day.j2ee.servletengine.ServletContainer;
import com.day.j2ee.servletengine.Version;
import com.day.j2ee.servletengine.WebApplication;
import com.day.jndi.url.java.javaURLContextFactory;
import com.day.util.UnixCrypt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletEngine
extends DeployerRuntime
implements Constants {
    private static final String ADMIN_WEB_APP = "/resources/admin.war";
    private static final String ADMIN_CONTEXT = "/admin";
    private static final String ADMIN_TMP_PREFIX = "admin";
    private static final String ADMIN_USER_NAME = "admin";
    private static final String ADMIN_TMP_SUFFIX = ".war";
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private final List containers = new ArrayList();
    private ClassLoader loader;
    private boolean running;
    private URL serverURL;
    private final com.day.j2ee.config.ServletEngine config;
    private Server server;
    private NTLMAuthenticator ntlmAuthenticator;
    static final Properties DEFAULT_ENVIRONMENT = new Properties();
    private static final String VERSION_PROPERTIES = "version.properties";
    private static Version VERSION;

    public static Version getVersion() {
        if (VERSION == null) {
            VERSION = ServletEngine.loadVersion();
        }
        return VERSION;
    }

    private static Version loadVersion() {
        DefaultVersion defaultVersion = new DefaultVersion();
        try {
            return new PropertiesVersion(VERSION_PROPERTIES, defaultVersion);
        }
        catch (FileNotFoundException e) {
            SEL.warn("Properties file not found at location: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            SEL.warn("I/O error while loading properties file: {}", (Object)e.getMessage());
        }
        return defaultVersion;
    }

    public ServletEngine(com.day.j2ee.config.ServletEngine config) {
        this.config = config;
    }

    public ServletEngine() {
        this(null);
    }

    public void init(String[] args, Server server, ClassLoader parentLoader) throws IOException, ConfigException {
        this.server = server;
        CommandLineArgs cmdLine = CommandLineArgs.parseArgs(args);
        if (cmdLine.getContextDir() != null) {
            System.setProperty("cq3.home", cmdLine.getContextDir());
        }
        if (cmdLine.getLogLevel() != null) {
            System.setProperty("cq3.loglevel", cmdLine.getLogLevel());
        }
        this.setupLoader(parentLoader);
        Iterator iter = this.config.getContainers().iterator();
        while (iter.hasNext()) {
            Container cc = (Container)iter.next();
            ServletContainer container = new ServletContainer(this, cc);
            this.addContainer(container);
        }
        ServletContainer firstContainer = (ServletContainer)this.containers.get(0);
        HttpListener listener = firstContainer.getListener(0);
        if (cmdLine.getPort() != 0) {
            listener.setPort(cmdLine.getPort());
        }
        if (cmdLine.getAddress() != null) {
            listener.setHost(cmdLine.getAddress());
        }
        File[] files = cmdLine.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String contextPath = file.getPath();
            int index = contextPath.lastIndexOf(File.separatorChar);
            if (index != -1) {
                contextPath = contextPath.substring(index + 1);
            }
            if (contextPath.endsWith(ADMIN_TMP_SUFFIX)) {
                contextPath = contextPath.substring(0, contextPath.length() - 4);
            }
            contextPath = "/" + contextPath;
            com.day.j2ee.config.WebApplication config = new com.day.j2ee.config.WebApplication();
            config.setContext(contextPath);
            config.setPath(file.getPath());
            config.setRunOnStartup("true");
            firstContainer.addApplication(config);
        }
        try {
            javaURLContextFactory.setObjectFactory(new JavaObjectFactory());
        }
        catch (IllegalStateException e) {
            throw new IOException("Unable to setup object factory for java namespace: {0}" + e.getMessage());
        }
        try {
            this.setupDeployer();
        }
        catch (IOException e) {
            SEL.warn("Unable to setup deployer: {}", (Object)e.getMessage());
        }
        catch (ConfigException e) {
            SEL.warn("Unable to setup deployer: {}", (Object)e.getMessage());
        }
        try {
            this.ntlmAuthenticator = new NTLMAuthenticator();
        }
        catch (Exception e) {
            SEL.warn("Unable to initialize NTLM authenticator: {}", (Object)e.getMessage());
        }
    }

    public void addContainer(ServletContainer container) throws ConfigException, IOException {
        container.init(this.loader);
        this.containers.add(container);
    }

    public URL getMainServerURL() {
        if (this.serverURL == null) {
            if (this.containers.size() == 0) {
                return null;
            }
            ServletContainer container = (ServletContainer)this.containers.get(0);
            Iterator listeners = container.getListeners();
            if (!listeners.hasNext()) {
                return null;
            }
            HttpListener listener = (HttpListener)listeners.next();
            String hostaddr = listener.getListenerAddress();
            try {
                this.serverURL = new URL("http", hostaddr, listener.port, "/");
            }
            catch (MalformedURLException e) {
                SEL.warn("Invalid server configuration", (Throwable)e);
            }
        }
        return this.serverURL;
    }

    public synchronized void start() throws IOException {
        if (!this.running) {
            SEL.info("Servlet engine start");
            int runningContainers = 0;
            Iterator iter = this.containers.iterator();
            while (iter.hasNext()) {
                ServletContainer container = (ServletContainer)iter.next();
                try {
                    container.start();
                    ++runningContainers;
                }
                catch (IOException e) {
                    SEL.error("Unable to start container: {}", (Object)e.getMessage());
                }
            }
            if (runningContainers == 0) {
                throw new IOException("no container running");
            }
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.running) {
            SEL.info("Servlet engine stop");
            for (int i = this.containers.size() - 1; i >= 0; --i) {
                ((ServletContainer)this.containers.get(i)).stop();
            }
            if (this.ntlmAuthenticator != null) {
                this.ntlmAuthenticator.close();
            }
            this.running = false;
        }
    }

    protected void setupLoader(ClassLoader parentLoader) {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            list.add(Server.getAbsolutePath("classes/container").toURL());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.populateLibraries(list, "lib/container");
        URL[] urls = new URL[list.size()];
        list.toArray(urls);
        this.loader = new URLClassLoader(urls, parentLoader);
    }

    protected void populateLibraries(ArrayList list, String path) {
        File libDir = Server.getAbsolutePath(path);
        File[] libs = libDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                try {
                    list.add(libs[i].toURL());
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void setupDeployer() throws IOException, ConfigException {
        in = this.getClass().getResourceAsStream("/resources/admin.war");
        if (in == null) {
            throw new FileNotFoundException("Admin application not found: /resources/admin.war");
        }
        warFile = null;
        out = null;
        try {
            warFile = File.createTempFile("admin", ".war", Server.getTempDirectory());
            try {
                out = new FileOutputStream(warFile);
                data = new byte[32768];
                while ((len = in.read(data)) > 0) {
                    out.write(data, 0, len);
                }
                var7_7 = null;
                ** if (out == null) goto lbl-1000
            }
            catch (Throwable var6_11) {
                var7_8 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var6_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
            }
            config = new com.day.j2ee.config.WebApplication();
            config.setContext("/admin");
            config.setPath(warFile.getAbsolutePath());
            config.setRunOnStartup(String.valueOf(true));
            container = (ServletContainer)this.containers.get(0);
            container.addApplication(new WebApplication(config, true), Thread.currentThread().getContextClassLoader());
            DeployerRuntime.setRuntime(this);
            var10_12 = null;
        }
        catch (Throwable var9_16) {
            var10_13 = null;
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (warFile != null) {
                warFile.delete();
            }
            throw var9_16;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (warFile != null) {
            warFile.delete();
        }
    }

    public int getContainers() {
        return this.containers.size();
    }

    public com.day.j2ee.deploy.ServletContainer getContainer(int index) {
        return (com.day.j2ee.deploy.ServletContainer)this.containers.get(index);
    }

    public void authenticate(String username, char[] password) throws LoginException {
        if (!username.equals("admin")) {
            throw new LoginException("Username and/or password mismatch");
        }
        Admin admin = this.config.getAdmin();
        if (admin != null) {
            if (password == null) {
                throw new LoginException("Password must be non-empty");
            }
            String crypt = UnixCrypt.crypt(username, new String(password));
            if (!crypt.equals(admin.getCrypt())) {
                throw new LoginException("Username and/or password mismatch");
            }
        }
    }

    public boolean isUserInRole(String username, String roleName) {
        return "admin".equals(username);
    }

    public void changePassword(String username, char[] oldPassword, char[] newPassword) throws LoginException {
        if (!"admin".equals(username)) {
            throw new LoginException("Invalid username");
        }
        if (oldPassword == null) {
            throw new LoginException("Old password cannot be empty");
        }
        if (newPassword == null) {
            throw new LoginException("New password cannot be empty");
        }
        Admin admin = this.config.getAdmin();
        if (admin == null) {
            admin = new Admin();
            this.config.setAdmin(admin);
        }
        String oldCrypt = admin.getCrypt();
        String checkCrypt = UnixCrypt.crypt(username, new String(oldPassword));
        if (oldCrypt != null && !oldCrypt.equals(checkCrypt)) {
            throw new LoginException("Old password incorrect");
        }
        if (new String(oldPassword).equals(new String(newPassword))) {
            throw new LoginException("Old and new password must be different");
        }
        admin.setCrypt(UnixCrypt.crypt(username, new String(newPassword)));
        this.server.configChanged();
    }

    public void configChanged() {
        this.server.configChanged();
    }

    public NTLMAuthenticationHandler createNTLMHandler() {
        if (this.ntlmAuthenticator != null) {
            return this.ntlmAuthenticator.createHandler();
        }
        return null;
    }

    static {
        DEFAULT_ENVIRONMENT.setProperty("java.naming.factory.initial", "com.day.j2ee.jndi.SimpleInitialContextFactory");
        DEFAULT_ENVIRONMENT.setProperty("java.naming.provider.url", "http://www.day.com/cqse");
    }
}

