/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.ntlm.NTLMAuthenticationHandler;
import com.day.j2ee.servletengine.AccessConstraint;
import com.day.j2ee.servletengine.BadRequestException;
import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.Cookie3;
import com.day.j2ee.servletengine.HttpSessionImpl;
import com.day.j2ee.servletengine.HttpSessionManager;
import com.day.j2ee.servletengine.RequestDispatcherImpl;
import com.day.j2ee.servletengine.RequestImpl;
import com.day.j2ee.servletengine.RequestURL;
import com.day.j2ee.servletengine.ResponseImpl;
import com.day.j2ee.servletengine.ServletContainer;
import com.day.j2ee.servletengine.ServletEngine;
import com.day.j2ee.servletengine.ServletHandler;
import com.day.j2ee.servletengine.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServletHandlerImpl
implements Constants,
ServletHandler {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final boolean DEBUG = SEL.isDebugEnabled();
    private static final int START = 0;
    private static final int INSIDE_METHOD = 1;
    private static final int BEFORE_FILE = 2;
    private static final int INSIDE_FILE = 3;
    private static final int BEFORE_PROTOCOL = 4;
    private static final int INSIDE_PROTOCOL = 5;
    private static final int BEFORE_CR = 6;
    private static final int BEFORE_LF = 7;
    private static final int BEFORE_CR_2 = 8;
    private static final int BEFORE_LF_2 = 9;
    private static final int BEFORE_HEADER = 10;
    private static final int HEADER_NAME = 11;
    private static final int HEADER_VALUE = 12;
    private static final int FINISHED = 13;
    private static final int UNCHECKED = 0;
    private static final int TRYING = 1;
    private static final int ACCEPTED = 2;
    private static final int NOT_ACCEPTED = 3;
    private static final byte[] CONTINUE = "HTTP/1.1 100 Continue\r\n\r\n".getBytes();
    private final RequestImpl req;
    private final ResponseImpl res;
    private final ServletContainer container;
    private final RequestDispatcherImpl dispatcher;
    private final AccessConstraint accessConstraint;
    private final boolean accessRestricted;
    private Socket client;
    InputStream in;
    OutputStream out;
    private String method;
    private String file;
    private String protocol;
    private boolean http11;
    private boolean headRequest;
    private HttpSessionImpl session;
    private int cookieState;
    private boolean cookieSent;
    boolean expectedContinue;
    boolean sentContinue;
    boolean continueDisallowed;
    byte[] dataIn;
    private char[] dataOut;
    int readptr;
    int read;
    private final Map headers = new HashMap();
    private int keepAliveRequests;
    private String serverName;
    private int serverPort;
    private InetAddress remoteAddr;
    private int remotePort;
    private String remoteHost;
    private InetAddress localAddr;
    private int localPort;
    private String localHost;
    private NTLMAuthenticationHandler ntlmHandler;
    private final boolean keepAliveEnabled;
    private final int keepAliveTimeout;
    private final String scheme;

    public ServletHandlerImpl(ServletContainer container, int bufferSize, boolean keepAliveEnabled, int keepAliveTimeout, String scheme, AccessConstraint accessConstraint) {
        this.container = container;
        this.dataIn = new byte[bufferSize];
        this.dataOut = new char[bufferSize];
        this.keepAliveEnabled = keepAliveEnabled;
        this.keepAliveTimeout = keepAliveTimeout;
        this.scheme = scheme;
        this.req = new RequestImpl(this);
        this.res = new ResponseImpl(this);
        this.dispatcher = new RequestDispatcherImpl(container);
        ServletEngine engine = container.getEngine();
        if (engine != null) {
            this.ntlmHandler = engine.createNTLMHandler();
        }
        this.accessConstraint = accessConstraint;
        this.accessRestricted = accessConstraint != null;
    }

    private void init(Socket client) throws IOException {
        this.client = client;
        this.in = client.getInputStream();
        this.out = client.getOutputStream();
        this.readptr = 0;
        this.read = 0;
        this.cookieState = 0;
        this.keepAliveRequests = 0;
        this.serverName = null;
        this.serverPort = -1;
        this.remoteAddr = null;
        this.remotePort = -1;
        this.remoteHost = null;
        this.localAddr = null;
        this.localPort = -1;
        this.localHost = null;
        if (this.ntlmHandler != null) {
            this.ntlmHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void process(Socket socket) {
        block45: {
            block43: {
                this.init(socket);
                this.threadStateChanged("<parse>");
                this.req.attach(new InputStreamWrapper());
                this.res.attach(new OutputStreamWrapper());
                do {
                    block48: {
                        Object var6_8;
                        block42: {
                            block40: {
                                this.req.recycle();
                                this.res.recycle();
                                if (this.keepAliveRequests == 1) {
                                    this.setReadTimeout(this.keepAliveTimeout);
                                }
                                try {
                                    if (this.parseRequest()) break block40;
                                    break;
                                }
                                catch (BadRequestException e) {
                                    SEL.warn("Bad request.", (Throwable)e);
                                    try {
                                        this.res.sendError(400);
                                        Object var4_9 = null;
                                        this.res.finish();
                                        break;
                                    }
                                    catch (Throwable throwable) {
                                        Object var4_10 = null;
                                        this.res.finish();
                                        throw throwable;
                                    }
                                }
                                catch (InterruptedIOException e) {
                                    SEL.debug("Interrupted while reading request");
                                    break;
                                }
                            }
                            try {
                                String ipAddr;
                                this.threadStateChanged(this.method + " " + this.file + " " + this.protocol);
                                if (this.accessRestricted && !this.isAccessAllowed(ipAddr = this.getRemoteAddr().getHostAddress(), this.method)) {
                                    SEL.warn("Access is restricted: IP address {} and HTTP method {} combination is not allowed", (Object)ipAddr, (Object)this.method);
                                    if (!this.res.isCommitted()) {
                                        this.res.sendError(403);
                                    }
                                    var6_8 = null;
                                    if (this.expectedContinue && !this.sentContinue && (this.req.keepAliveDisabled() || !this.res.isKeepAlive())) {
                                        this.continueDisallowed = true;
                                    }
                                    this.req.finish();
                                    this.res.finish();
                                    this.container.logAccess(this.file, this.req, this.res);
                                    break;
                                }
                                if (this.handleNTLM()) break block42;
                                this.dispatcher.service(this.file, this.req, this.res);
                            }
                            catch (Throwable throwable) {
                                var6_8 = null;
                                if (this.expectedContinue && !this.sentContinue && (this.req.keepAliveDisabled() || !this.res.isKeepAlive())) {
                                    this.continueDisallowed = true;
                                }
                                this.req.finish();
                                this.res.finish();
                                this.container.logAccess(this.file, this.req, this.res);
                                throw throwable;
                            }
                        }
                        var6_8 = null;
                        if (this.expectedContinue && !this.sentContinue && (this.req.keepAliveDisabled() || !this.res.isKeepAlive())) {
                            this.continueDisallowed = true;
                        }
                        break block48;
                        {
                            catch (ServletException e) {
                                SEL.info("Servlet threw exception: ", Util.getRootCause(e));
                                if (!this.res.isCommitted()) {
                                    this.res.sendError(500);
                                }
                                var6_8 = null;
                                if (this.expectedContinue && !this.sentContinue && (this.req.keepAliveDisabled() || !this.res.isKeepAlive())) {
                                    this.continueDisallowed = true;
                                }
                                this.req.finish();
                                this.res.finish();
                                this.container.logAccess(this.file, this.req, this.res);
                                break;
                            }
                        }
                    }
                    this.req.finish();
                    this.res.finish();
                    this.container.logAccess(this.file, this.req, this.res);
                    this.threadStateChanged("<wait>");
                    ++this.keepAliveRequests;
                    if (this.req.keepAliveDisabled()) break;
                } while (this.res.isKeepAlive());
                Object var8_13 = null;
                this.threadStateChanged("<closing>");
                if (this.out != null) {
                    this.finishOutput();
                    this.out = null;
                }
                if (this.in != null) {
                    this.finishInput();
                    this.in = null;
                }
                if (this.client == null) break block43;
                try {
                    this.client.close();
                }
                catch (IOException e2) {
                    SEL.warn("I/O error on socket close: {}", (Object)e2.getMessage());
                }
                this.client = null;
            }
            this.req.recycle();
            this.res.recycle();
            this.threadStateChanged("<closed>");
            {
                break block45;
                catch (SocketException e) {
                    if (DEBUG) {
                        SEL.debug("Socket exception", (Throwable)e);
                    }
                    Object var8_14 = null;
                    this.threadStateChanged("<closing>");
                    if (this.out != null) {
                        this.finishOutput();
                        this.out = null;
                    }
                    if (this.in != null) {
                        this.finishInput();
                        this.in = null;
                    }
                    if (this.client != null) {
                        try {
                            this.client.close();
                        }
                        catch (IOException e2) {
                            SEL.warn("I/O error on socket close: {}", (Object)e2.getMessage());
                        }
                        this.client = null;
                    }
                    this.req.recycle();
                    this.res.recycle();
                    this.threadStateChanged("<closed>");
                    break block45;
                }
                catch (IOException e) {
                    SEL.warn("I/O error in execution: {}", (Throwable)e);
                    Object var8_15 = null;
                    this.threadStateChanged("<closing>");
                    if (this.out != null) {
                        this.finishOutput();
                        this.out = null;
                    }
                    if (this.in != null) {
                        this.finishInput();
                        this.in = null;
                    }
                    if (this.client != null) {
                        try {
                            this.client.close();
                        }
                        catch (IOException e2) {
                            SEL.warn("I/O error on socket close: {}", (Object)e2.getMessage());
                        }
                        this.client = null;
                    }
                    this.req.recycle();
                    this.res.recycle();
                    this.threadStateChanged("<closed>");
                }
            }
            catch (Throwable throwable) {
                Object var8_16 = null;
                this.threadStateChanged("<closing>");
                if (this.out != null) {
                    this.finishOutput();
                    this.out = null;
                }
                if (this.in != null) {
                    this.finishInput();
                    this.in = null;
                }
                if (this.client != null) {
                    try {
                        this.client.close();
                    }
                    catch (IOException e2) {
                        SEL.warn("I/O error on socket close: {}", (Object)e2.getMessage());
                    }
                    this.client = null;
                }
                this.req.recycle();
                this.res.recycle();
                this.threadStateChanged("<closed>");
                throw throwable;
            }
        }
    }

    private boolean isAccessAllowed(String ipAddr, String httpMethod) {
        return this.accessConstraint == null || this.accessConstraint.isOperationAllowed(ipAddr, httpMethod);
    }

    private void threadStateChanged(String state) {
        String ipAddr = this.getRemoteAddr().getHostAddress();
        Thread.currentThread().setName(ipAddr + " [" + String.valueOf(System.currentTimeMillis()) + "] " + state);
    }

    protected boolean parseRequest() throws BadRequestException, IOException {
        String headerName = "";
        int writeptr = 0;
        this.headers.clear();
        this.session = null;
        this.method = null;
        this.file = null;
        this.protocol = "HTTP/0.9";
        this.cookieSent = false;
        this.continueDisallowed = false;
        this.sentContinue = false;
        this.expectedContinue = false;
        this.http11 = false;
        this.headRequest = false;
        int state = 0;
        while (state != 13) {
            if (this.readptr >= this.read) {
                this.read = this.in.read(this.dataIn);
                if (this.read == -1) break;
                this.readptr = 0;
            }
            char ch = (char)this.dataIn[this.readptr++];
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch) || ch == '\u0000') break;
                    this.dataOut[writeptr++] = ch;
                    state = 1;
                    break;
                }
                case 1: {
                    if (ch == ' ') {
                        this.method = new String(this.dataOut, 0, writeptr);
                        this.headRequest = "HEAD".equals(this.method);
                        writeptr = 0;
                        state = 2;
                        break;
                    }
                    if (ch == '\r' || ch == '\n') {
                        throw new BadRequestException("no method");
                    }
                    this.checkSpace(this.dataOut, writeptr, "request line");
                    this.dataOut[writeptr++] = ch;
                    break;
                }
                case 2: {
                    if (ch == '\r' || ch == '\n') {
                        throw new BadRequestException("no file");
                    }
                    if (ch == ' ') break;
                    this.checkSpace(this.dataOut, writeptr, "request line");
                    this.dataOut[writeptr++] = ch;
                    state = 3;
                    break;
                }
                case 3: {
                    if (ch == ' ' || ch == '\r' || ch == '\n') {
                        this.file = new String(this.dataOut, 0, writeptr);
                        writeptr = 0;
                        if (ch == ' ') {
                            state = 4;
                            break;
                        }
                        if (ch == '\r') {
                            state = 7;
                            break;
                        }
                        if (ch != '\n') break;
                        state = 8;
                        break;
                    }
                    this.checkSpace(this.dataOut, writeptr, "request line");
                    this.dataOut[writeptr++] = ch;
                    break;
                }
                case 4: {
                    if (ch == '\r') {
                        state = 7;
                        break;
                    }
                    if (ch == '\n') {
                        state = 8;
                        break;
                    }
                    if (ch == ' ') break;
                    this.checkSpace(this.dataOut, writeptr, "request line");
                    this.dataOut[writeptr++] = ch;
                    state = 5;
                    break;
                }
                case 5: {
                    if (ch == ' ' || ch == '\r' || ch == '\n') {
                        this.protocol = new String(this.dataOut, 0, writeptr);
                        this.http11 = this.protocol.equals("HTTP/1.1");
                        writeptr = 0;
                        if (ch == ' ') {
                            state = 6;
                            break;
                        }
                        if (ch == '\r') {
                            state = 7;
                            break;
                        }
                        if (ch != '\n') break;
                        state = 8;
                        break;
                    }
                    this.checkSpace(this.dataOut, writeptr, "request line");
                    this.dataOut[writeptr++] = ch;
                    break;
                }
                case 6: {
                    if (ch == '\r') {
                        state = 7;
                        break;
                    }
                    if (ch != '\n') break;
                    state = 8;
                    break;
                }
                case 7: {
                    if (ch == '\n') {
                        state = 8;
                        break;
                    }
                    if (ch != '\r') break;
                    state = 13;
                    break;
                }
                case 8: {
                    if (ch == '\r') {
                        state = 9;
                        break;
                    }
                    if (ch == '\n') {
                        state = 13;
                        break;
                    }
                    state = 11;
                    this.dataOut[writeptr++] = ch;
                    break;
                }
                case 9: {
                    if (ch == '\n') {
                        state = 13;
                        break;
                    }
                    throw new BadRequestException("no second CR LF");
                }
                case 11: {
                    String headerValue;
                    if (ch == ':' || ch == '\r' || ch == '\n') {
                        headerName = new String(this.dataOut, 0, writeptr);
                        headerValue = "";
                        writeptr = 0;
                        if (ch == ':') {
                            state = 12;
                            break;
                        }
                        if (ch == '\r') {
                            this.addHeader(headerName.trim(), headerValue.trim());
                            state = 7;
                            break;
                        }
                        if (ch != '\n') break;
                        this.addHeader(headerName.trim(), headerValue.trim());
                        state = 8;
                        break;
                    }
                    this.checkSpace(this.dataOut, writeptr, "header");
                    this.dataOut[writeptr++] = ch;
                    break;
                }
                case 12: {
                    String headerValue;
                    if (ch == '\r' || ch == '\n') {
                        headerValue = new String(this.dataOut, 0, writeptr);
                        writeptr = 0;
                        this.addHeader(headerName.trim(), headerValue.trim());
                        if (ch == '\r') {
                            state = 7;
                            break;
                        }
                        if (ch != '\n') break;
                        state = 8;
                        break;
                    }
                    this.checkSpace(this.dataOut, writeptr, "header");
                    this.dataOut[writeptr++] = ch;
                }
            }
        }
        if (state == 0) {
            return false;
        }
        if (this.method == null || this.file == null) {
            throw new BadRequestException("either method or file empty");
        }
        if (this.http11 && !this.hasHeader("Host")) {
            throw new BadRequestException("Host header required in HTTP 1.1 requests");
        }
        return true;
    }

    private void checkSpace(char[] buf, int off, String sectionName) throws BadRequestException {
        if (off == buf.length) {
            throw new BadRequestException(sectionName + " exceeds " + String.valueOf(buf.length) + " bytes");
        }
    }

    private boolean handleNTLM() {
        return this.ntlmHandler != null && this.ntlmHandler.handle(this.req, this.res);
    }

    private void addHeader(String name, String value) {
        String key = name.toLowerCase();
        if (this.http11 && key.equals("expect") && "100-continue".equalsIgnoreCase(value)) {
            this.expectedContinue = true;
            return;
        }
        ArrayList<String> list = (ArrayList<String>)this.headers.get(key);
        if (list == null) {
            list = new ArrayList<String>(10);
            this.headers.put(key, list);
        }
        list.add(value);
    }

    protected boolean hasHeader(String name) {
        return this.headers.containsKey(name.toLowerCase());
    }

    public List getHeaders(String name) {
        return (List)this.headers.get(name.toLowerCase());
    }

    public Iterator getHeaderNames() {
        return this.headers.keySet().iterator();
    }

    protected String getHeader(String name) {
        List list = this.getHeaders(name);
        if (list != null) {
            return (String)list.get(0);
        }
        return null;
    }

    public String getMethod() {
        return this.method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isHttp11() {
        return this.http11;
    }

    public boolean isHeadRequest() {
        return this.headRequest;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.checkServerNameAndPort();
        }
        return this.serverName;
    }

    public int getServerPort() {
        if (this.serverPort == -1) {
            this.checkServerNameAndPort();
        }
        return this.serverPort;
    }

    private void checkServerNameAndPort() {
        String s = this.getHeader("Host");
        if (s != null) {
            int toIndex;
            int fromIndex = 0;
            int length = s.length();
            if (length > 0 && s.charAt(0) == '[') {
                fromIndex = s.indexOf(93);
            }
            if ((toIndex = s.indexOf(58, fromIndex)) == -1) {
                toIndex = length;
            }
            this.serverName = s.substring(0, toIndex);
            if (toIndex < length) {
                try {
                    this.serverPort = Integer.parseInt(s.substring(toIndex + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (this.serverPort == -1) {
                this.serverPort = this.isSecure() ? 443 : 80;
            }
        } else {
            this.serverName = this.client.getLocalAddress().getHostName();
            this.serverPort = this.client.getLocalPort();
        }
    }

    public InetAddress getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.client.getInetAddress();
        }
        return this.remoteAddr;
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.remotePort = this.client.getPort();
        }
        return this.remotePort;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = this.client.getInetAddress().getHostName();
        }
        return this.remoteHost;
    }

    public InetAddress getLocalAddr() {
        if (this.localAddr == null) {
            this.localAddr = this.client.getLocalAddress();
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.localPort = this.client.getLocalPort();
        }
        return this.localPort;
    }

    public String getLocalHost() {
        if (this.localHost == null) {
            this.localHost = this.client.getLocalAddress().getHostName();
        }
        return this.localHost;
    }

    public boolean isSecure() {
        return this.client instanceof SSLSocket;
    }

    public int getSSLKeyLength() {
        String cipher = this.getCipherSuite();
        if (cipher == null) {
            return 1;
        }
        if (cipher.indexOf("_RC4_128_") > 0) {
            return 128;
        }
        if (cipher.indexOf("_RC4_40_") > 0) {
            return 40;
        }
        if (cipher.indexOf("_3DES_") > 0) {
            return 168;
        }
        if (cipher.indexOf("_DES_") > 0) {
            return 56;
        }
        if (cipher.indexOf("_DES40_") > 0) {
            return 40;
        }
        return 0;
    }

    public String getCipherSuite() {
        if (this.isSecure()) {
            return ((SSLSocket)this.client).getSession().getCipherSuite();
        }
        return null;
    }

    public X509Certificate[] getCertificateChain() {
        if (this.isSecure()) {
            try {
                return ((SSLSocket)this.client).getSession().getPeerCertificateChain();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return null;
    }

    public HttpServletRequest getServletRequest() {
        return this.req;
    }

    public StringBuffer getRequestURL() {
        return this.getServletRequest().getRequestURL();
    }

    public HttpServletResponse getServletResponse() {
        return this.res;
    }

    public boolean keepConnection() {
        if (!this.keepAliveEnabled) {
            return false;
        }
        if (this.http11) {
            return !"Close".equalsIgnoreCase(this.getHeader("Connection"));
        }
        return "Keep-Alive".equalsIgnoreCase(this.getHeader("Connection"));
    }

    public HttpSession getSession(boolean create) {
        boolean created = false;
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session == null) {
            HttpSessionManager sessionManager = this.container.getSessionManager();
            HttpSessionImpl session = null;
            String id = this.req.getSessionId();
            if (id != null && (session = sessionManager.getSession(id)) == null) {
                session = sessionManager.createSession(this.req.getApplication());
                SEL.debug("Unknown session with session id {}, created new id {}", (Object)id, (Object)session.getId());
            }
            if (session == null && create) {
                session = sessionManager.createSession(this.req.getApplication());
                created = true;
            }
            if (session != null) {
                if (this.req.isRequestedSessionIdFromCookie()) {
                    this.cookieState = 2;
                } else if (this.cookieState == 1) {
                    this.cookieState = 3;
                } else if (this.cookieState == 0 && !this.res.isCommitted()) {
                    this.cookieState = 1;
                }
                if (this.cookieState != 3) {
                    if (created && this.res.isCommitted()) {
                        String msg = "Response already committed: unable to send session in cookies";
                        throw new IllegalStateException(msg);
                    }
                    Cookie3 sc = new Cookie3("JSESSIONID", session.getId());
                    String scpath = this.req.getApplication().getContextPath();
                    if (scpath.equals("")) {
                        scpath = "/";
                    }
                    sc.setPath(scpath);
                    sc.setHttpOnly(session.getHttpOnly());
                    this.res.addCookie(sc);
                    this.cookieSent = true;
                }
            }
            this.session = session;
        }
        return this.session;
    }

    public String encodeURL(String url) {
        HttpSession session = this.getSession(false);
        if (session == null || this.cookieSent && this.cookieState != 1) {
            return url;
        }
        RequestURL encodedURL = new RequestURL(url);
        if (encodedURL.getSessionId() == null) {
            encodedURL.setSessionId(session.getId());
        }
        return encodedURL.toString();
    }

    protected void finishInput() {
        int available;
        try {
            available = this.in.available();
        }
        catch (IOException e) {
            return;
        }
        try {
            if (available > 0) {
                SEL.debug("additional {} bytes available", (Object)String.valueOf(available));
                this.in.skip(available);
            }
        }
        catch (IOException e) {
            SEL.warn("I/O error occurred on skipping {} bytes: {}", (Object)String.valueOf(available), (Object)e.getMessage());
        }
    }

    protected void finishOutput() {
        try {
            this.out.flush();
        }
        catch (SocketException e) {
            if (DEBUG) {
                SEL.debug("Socket error on flush", (Throwable)e);
            }
        }
        catch (IOException e) {
            if (DEBUG) {
                SEL.debug("I/O error on flush", (Throwable)e);
            }
            SEL.warn("I/O error on flush: {}", (Object)e.getMessage());
        }
        try {
            if (!this.isSecure()) {
                this.client.shutdownOutput();
            }
        }
        catch (IOException e) {
            SEL.warn("I/O error on shutdownOutput: {}", (Object)e.getMessage());
        }
    }

    void setReadTimeout(int seconds) throws IOException {
        this.client.setSoTimeout(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendContinue() {
        if (!this.sentContinue) {
            try {
                try {
                    this.out.write(CONTINUE);
                    this.out.flush();
                }
                catch (IOException e) {
                    SEL.warn("I/O error while sending back 100 Continue: " + e.getMessage());
                    Object var3_2 = null;
                    this.sentContinue = true;
                }
                Object var3_1 = null;
                this.sentContinue = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sentContinue = true;
                throw throwable;
            }
        }
    }

    class OutputStreamWrapper
    extends OutputStream {
        OutputStreamWrapper() {
        }

        public void write(int b) throws IOException {
            if (!ServletHandlerImpl.this.continueDisallowed) {
                ServletHandlerImpl.this.continueDisallowed = true;
            }
            ServletHandlerImpl.this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (!ServletHandlerImpl.this.continueDisallowed) {
                ServletHandlerImpl.this.continueDisallowed = true;
            }
            ServletHandlerImpl.this.out.write(b, off, len);
        }
    }

    class InputStreamWrapper
    extends InputStream {
        InputStreamWrapper() {
        }

        public int read() throws IOException {
            if (ServletHandlerImpl.this.readptr < ServletHandlerImpl.this.read) {
                return ServletHandlerImpl.this.dataIn[ServletHandlerImpl.this.readptr++];
            }
            if (ServletHandlerImpl.this.expectedContinue && !ServletHandlerImpl.this.sentContinue) {
                if (ServletHandlerImpl.this.continueDisallowed) {
                    return -1;
                }
                ServletHandlerImpl.this.sendContinue();
            }
            return ServletHandlerImpl.this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (ServletHandlerImpl.this.readptr < ServletHandlerImpl.this.read) {
                if (len > ServletHandlerImpl.this.read - ServletHandlerImpl.this.readptr) {
                    len = ServletHandlerImpl.this.read - ServletHandlerImpl.this.readptr;
                }
                System.arraycopy(ServletHandlerImpl.this.dataIn, ServletHandlerImpl.this.readptr, b, off, len);
                ServletHandlerImpl.this.readptr += len;
                return len;
            }
            if (len == 0) {
                return 0;
            }
            if (ServletHandlerImpl.this.expectedContinue && !ServletHandlerImpl.this.sentContinue) {
                if (ServletHandlerImpl.this.continueDisallowed) {
                    return -1;
                }
                ServletHandlerImpl.this.sendContinue();
            }
            return ServletHandlerImpl.this.in.read(b, off, len);
        }
    }
}

