/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.Servlet;
import com.day.j2ee.config.ServletMapping;
import com.day.j2ee.servletengine.PathMap;
import com.day.j2ee.servletengine.URLPath;
import java.util.HashMap;
import java.util.Map;

class ServletMap {
    private final Map exactMappings = new HashMap();
    private final Map extensionMap = new HashMap();
    private final PathMap pathMappings = new PathMap();

    ServletMap() {
    }

    public void put(ServletMapping mapping, Servlet servlet) throws IllegalArgumentException {
        String pattern = mapping.getUrlPattern();
        if (pattern.equals("/")) {
            this.exactMappings.put(pattern, servlet);
        } else if (pattern.startsWith("*.")) {
            String extension = pattern.substring(2);
            this.extensionMap.put(extension, servlet);
        } else if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            this.pathMappings.insert(prefix, servlet);
        } else {
            this.exactMappings.put(pattern, servlet);
        }
    }

    public Servlet map(URLPath urlPath) {
        String relativePath = urlPath.getRemaining();
        Servlet config = (Servlet)this.exactMappings.get(relativePath);
        if (config != null) {
            urlPath.setServletPath(relativePath);
        } else {
            config = (Servlet)this.pathMappings.map(urlPath);
            if (config == null) {
                String extension = urlPath.getExtension();
                if (extension != null && (config = (Servlet)this.extensionMap.get(extension)) != null) {
                    urlPath.setServletPath(relativePath);
                }
                if (config == null && (config = (Servlet)this.exactMappings.get("/")) != null) {
                    urlPath.setServletPath(relativePath);
                }
            }
        }
        return config;
    }
}

