/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class SingleKeyStoreSpi
extends KeyStoreSpi {
    private final KeyStore keyStore;
    final String alias;

    public SingleKeyStoreSpi(KeyStore keyStore, String alias) {
        this.keyStore = keyStore;
        this.alias = alias;
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return this.keyStore.getKey(alias, password);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        try {
            return this.keyStore.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    public Certificate engineGetCertificate(String alias) {
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    public Date engineGetCreationDate(String alias) {
        try {
            return this.keyStore.getCreationDate(alias);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
    }

    public Enumeration engineAliases() {
        return new Enumeration(){
            private boolean done;

            public boolean hasMoreElements() {
                return !this.done;
            }

            public Object nextElement() {
                if (!this.done) {
                    this.done = true;
                    return SingleKeyStoreSpi.this.alias;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public boolean engineContainsAlias(String alias) {
        try {
            return this.keyStore.containsAlias(alias);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public int engineSize() {
        try {
            return this.keyStore.size();
        }
        catch (KeyStoreException e) {
            return 0;
        }
    }

    public boolean engineIsKeyEntry(String alias) {
        try {
            return this.keyStore.isKeyEntry(alias);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public boolean engineIsCertificateEntry(String alias) {
        try {
            return this.keyStore.isCertificateEntry(alias);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public String engineGetCertificateAlias(Certificate cert) {
        try {
            return this.keyStore.getCertificateAlias(cert);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }
}

