/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.Cookie3;
import com.day.util.Text;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Util
extends com.day.j2ee.server.Util
implements Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final int BEFORE_NAME = 0;
    private static final int INSIDE_NAME = 1;
    private static final int ESC_NAME = 2;
    private static final int BEFORE_EQU = 3;
    private static final int BEFORE_VALUE = 4;
    private static final int INSIDE_VALUE = 5;
    private static final int ESC_VALUE = 6;
    private static final int AFTER_VALUE = 6;
    private static final int BEFORE_SEP = 7;
    private static final SimpleDateFormat RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final SimpleDateFormat RFC1036 = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
    private static final SimpleDateFormat ASCTIME = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
    static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String tspecials = ",; ";
    private static final String tspecials2 = "()<>@,;:\\\"/[]?={} \t";
    private static final String SEPARATORS = "\t \"'(),:;<=>?@[\\]{}";
    private static final ThreadLocal RFC1123_TL;
    private static final String QBADFORMAT = "Quality value must be in the format: ( \"0\" [ \".\" 0*3DIGIT ] ) | ( \"1\" [ \".\" 0*3(\"0\") ] ): ";

    public static void parseQueryString(byte[] data, String encoding, Map map, boolean prependNew, int maxcount) throws IllegalArgumentException, UnsupportedEncodingException {
        Util.parseNVPairString(data, encoding, map, '&', false, prependNew, maxcount);
    }

    private static void parseNVPairString(byte[] data, String encoding, Map map, char separator, boolean allowSpaces, boolean prependNew, int maxcount) throws IllegalArgumentException, UnsupportedEncodingException {
        ByteArrayOutputStream keyBuffer = new ByteArrayOutputStream(256);
        ByteArrayOutputStream valueBuffer = new ByteArrayOutputStream(256);
        char[] chCode = new char[2];
        int state = 0;
        int subState = 0;
        int count = 0;
        block14: for (int i = 0; i < data.length; ++i) {
            char ch = (char)data[i];
            switch (state) {
                case 0: {
                    if (ch == ' ') continue block14;
                    if (ch == '%') {
                        state = 2;
                        subState = 0;
                        continue block14;
                    }
                    if (ch == '+' && !allowSpaces) {
                        keyBuffer.write(32);
                        state = 1;
                        continue block14;
                    }
                    keyBuffer.write(ch);
                    state = 1;
                    continue block14;
                }
                case 1: {
                    String key;
                    if (ch == '=') {
                        state = 4;
                        continue block14;
                    }
                    if (ch == '+' && !allowSpaces) {
                        keyBuffer.write(32);
                        continue block14;
                    }
                    if (ch == '%') {
                        state = 2;
                        subState = 0;
                        continue block14;
                    }
                    if (ch == '&') {
                        key = keyBuffer.toString(encoding);
                        if (count++ == maxcount) {
                            SEL.warn("Too many name/value pairs, stopped processing after " + maxcount + " entries");
                            return;
                        }
                        Util.addNVPair(map, key, "", prependNew);
                        keyBuffer.reset();
                        valueBuffer.reset();
                        state = 0;
                        continue block14;
                    }
                    keyBuffer.write(ch);
                    continue block14;
                }
                case 2: {
                    chCode[subState++] = ch;
                    if (subState != chCode.length) continue block14;
                    String code = new String(chCode);
                    try {
                        keyBuffer.write(Integer.parseInt(code, 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Bad escape sequence: %" + code);
                    }
                    state = 1;
                    continue block14;
                }
                case 3: {
                    if (ch != '=') continue block14;
                    state = 4;
                    continue block14;
                }
                case 4: {
                    String value;
                    String key;
                    if (ch == ' ') continue block14;
                    if (ch == '%') {
                        state = 6;
                        subState = 0;
                        continue block14;
                    }
                    if (ch == '+' && !allowSpaces) {
                        valueBuffer.write(32);
                        state = 5;
                        continue block14;
                    }
                    if (ch == separator) {
                        key = keyBuffer.toString(encoding);
                        value = valueBuffer.toString(encoding);
                        if (count++ == maxcount) {
                            SEL.warn("Too many name/value pairs, stopped processing after " + maxcount + " entries");
                            return;
                        }
                        Util.addNVPair(map, key, value, prependNew);
                        keyBuffer.reset();
                        valueBuffer.reset();
                        state = 0;
                        continue block14;
                    }
                    valueBuffer.write(ch);
                    state = 5;
                    continue block14;
                }
                case 5: {
                    String value;
                    String key;
                    if (ch == separator) {
                        key = keyBuffer.toString(encoding);
                        value = valueBuffer.toString(encoding);
                        if (count++ == maxcount) {
                            SEL.warn("Too many name/value pairs, stopped processing after " + maxcount + " entries");
                            return;
                        }
                        Util.addNVPair(map, key, value, prependNew);
                        keyBuffer.reset();
                        valueBuffer.reset();
                        state = 0;
                        continue block14;
                    }
                    if (ch == '+' && !allowSpaces) {
                        valueBuffer.write(32);
                        continue block14;
                    }
                    if (ch == '%') {
                        state = 6;
                        subState = 0;
                        continue block14;
                    }
                    valueBuffer.write(ch);
                    continue block14;
                }
                case 6: {
                    chCode[subState++] = ch;
                    if (subState != chCode.length) continue block14;
                    String code = new String(chCode);
                    try {
                        valueBuffer.write(Integer.parseInt(code, 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Bad escape sequence: %" + code);
                    }
                    state = 5;
                    continue block14;
                }
                case 7: {
                    if (ch != separator) continue block14;
                    state = 0;
                }
            }
        }
        if (keyBuffer.size() > 0) {
            String key = keyBuffer.toString(encoding);
            String value = valueBuffer.toString(encoding);
            if (count++ == maxcount) {
                SEL.warn("Too many name/value pairs, stopped processing after " + maxcount + " entries");
                return;
            }
            Util.addNVPair(map, key, value, prependNew);
        }
    }

    private static void addNVPair(Map map, String key, String value, boolean prependNew) {
        String[] values = (String[])map.get(key);
        if (values == null) {
            values = new String[1];
        } else {
            String[] valuesT = new String[values.length + 1];
            System.arraycopy(values, 0, valuesT, prependNew ? 1 : 0, values.length);
            values = valuesT;
        }
        map.put(key, values);
        values[prependNew ? 0 : values.length - 1] = value;
    }

    public static boolean cookieIsHttpOnly(Cookie cookie) {
        return cookie instanceof Cookie3 && ((Cookie3)cookie).getHttpOnly();
    }

    public static String getCookieHeaderName(Cookie cookie) {
        int version = cookie.getVersion();
        if (version == 1) {
            return "Set-Cookie";
        }
        return "Set-Cookie";
    }

    public static String getCookieHeaderValue(Cookie cookie) {
        StringBuffer buf = new StringBuffer(256);
        int version = cookie.getVersion();
        buf.append(cookie.getName());
        buf.append("=");
        Util.maybeQuote(version, buf, cookie.getValue());
        if (version == 1) {
            buf.append("; Version=1");
            if (cookie.getComment() != null) {
                buf.append("; Comment=");
                Util.maybeQuote(version, buf, cookie.getComment());
            }
        }
        if (cookie.getDomain() != null) {
            buf.append("; Domain=");
            Util.maybeQuote(version, buf, cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (version == 0) {
                long expiryDate = System.currentTimeMillis() + (long)cookie.getMaxAge() * 1000L;
                buf.append("; Expires=");
                buf.append(Util.dateToString(new Date(expiryDate)));
            } else {
                buf.append("; MaxAge=");
                buf.append(cookie.getMaxAge());
            }
        }
        if (cookie.getPath() != null) {
            buf.append("; Path=");
            Util.maybeQuote(version, buf, cookie.getPath());
        }
        if (cookie.getSecure()) {
            buf.append("; Secure");
        }
        return buf.toString();
    }

    private static void maybeQuote(int version, StringBuffer buf, String value) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else {
            if (Util.containsCTL(value, version)) {
                throw new IllegalArgumentException("Control character in cookie value, consider BASE64 encoding your value");
            }
            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                buf.append('\"');
                buf.append(Util.escapeDoubleQuotes(value, 1, value.length() - 1));
                buf.append('\"');
            } else if (version == 0 && !Util.isToken(value)) {
                buf.append('\"');
                buf.append(Util.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else if (version == 1 && !Util.isToken2(value)) {
                buf.append('\"');
                buf.append(Util.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else {
                buf.append(value);
            }
        }
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException("Invalid escape character in cookie value.");
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private static String unescapeDoubleQuotes(String s) {
        int src;
        if (s.indexOf(34) == -1) {
            return s;
        }
        char[] ch = s.toCharArray();
        int end = ch.length;
        int dest = src;
        for (src = 0; src < end; ++src) {
            if (ch[src] == '\\' && src < end && ch[src + 1] == '\"') {
                ++src;
            }
            ch[dest] = ch[src];
            ++dest;
        }
        return new String(ch, 0, dest);
    }

    private static boolean containsCTL(String value, int version) {
        if (value == null) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' || c == '\t') continue;
            return true;
        }
        return false;
    }

    private static boolean isToken(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    private static boolean isToken2(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (tspecials2.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static final void parseCookies(byte[] bytes, List cookies) {
        if (bytes.length == 0) {
            return;
        }
        cookie = null;
        version = 0;
        pos = 0;
        while (pos < bytes.length) {
            block22: {
                block21: {
                    isSpecial = false;
                    isQuoted = false;
                    while (pos < bytes.length && (Util.isSeparator(bytes[pos]) || Util.isWhiteSpace(bytes[pos]))) {
                        ++pos;
                    }
                    if (pos >= bytes.length) {
                        return;
                    }
                    if (bytes[pos] == 36) {
                        isSpecial = true;
                    }
                    valueStart = nameStart = ++pos;
                    valueEnd = nameStart;
                    for (pos = nameEnd = Util.getTokenEndPosition(bytes, pos, bytes.length); pos < bytes.length && Util.isWhiteSpace(bytes[pos]); ++pos) {
                    }
                    if (pos >= bytes.length || bytes[pos] != 61) break block21;
                    while (++pos < bytes.length && Util.isWhiteSpace(bytes[pos])) {
                    }
                    if (pos >= bytes.length) {
                        return;
                    }
                    switch (bytes[pos]) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = Util.getQuotedValueEndPosition(bytes, valueStart, bytes.length);
                            if (pos >= bytes.length) {
                                return;
                            }
                            break block22;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block22;
                        }
                        default: {
                            if (Util.isSeparator(bytes[pos])) ** GOTO lbl42
                            valueStart = pos;
                            pos = valueEnd = Util.getTokenEndPosition(bytes, valueStart, bytes.length);
                            break block22;
lbl42:
                            // 1 sources

                            Util.SEL.warn("Invalid cookie. Value not a token or quoted value");
                            while (pos < bytes.length && bytes[pos] != 59 && bytes[pos] != 44) {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < bytes.length && Util.isWhiteSpace(bytes[pos])) {
                ++pos;
            }
            while (pos < bytes.length && bytes[pos] != 59 && bytes[pos] != 44) {
                ++pos;
            }
            ++pos;
            if (isSpecial) {
                isSpecial = false;
                s = new String(bytes, nameStart, nameEnd - nameStart);
                if (s.equals("Version") && cookie == null) {
                    if (bytes[valueStart] != 49 || valueEnd != valueStart + 1) continue;
                    version = 1;
                    continue;
                }
                if (cookie == null) continue;
                if (s.equals("Domain")) {
                    cookie.setDomain(new String(bytes, valueStart, valueEnd - valueStart));
                    continue;
                }
                if (s.equals("Path")) {
                    cookie.setPath(new String(bytes, valueStart, valueEnd - valueStart));
                    continue;
                }
                if (s.equals("Port")) continue;
                Util.SEL.warn("Unknown Special Cookie");
                continue;
            }
            cookie = new Cookie(new String(bytes, nameStart, nameEnd - nameStart), "");
            cookies.add(cookie);
            cookie.setVersion(version);
            if (valueStart == -1) continue;
            value = new String(bytes, valueStart, valueEnd - valueStart);
            if (isQuoted) {
                value = Util.unescapeDoubleQuotes(value);
            }
            cookie.setValue(value);
        }
    }

    private static final int getTokenEndPosition(byte[] bytes, int off, int end) {
        int pos;
        for (pos = off; pos < end && !Util.isSeparator(bytes[pos]); ++pos) {
        }
        return pos > end ? end : pos;
    }

    private static final int getQuotedValueEndPosition(byte[] bytes, int off, int end) {
        int pos = off;
        while (pos < end) {
            if (bytes[pos] == 34) {
                return pos;
            }
            if (bytes[pos] == 92 && pos < end - 1) {
                pos += 2;
                continue;
            }
            ++pos;
        }
        return end;
    }

    private static final boolean isSeparator(byte c) {
        if (c > 0 && c < 126) {
            return SEPARATORS.indexOf(c) != -1;
        }
        return false;
    }

    private static final boolean isWhiteSpace(byte c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(String dateString) throws IllegalArgumentException {
        SimpleDateFormat simpleDateFormat = RFC1123;
        synchronized (simpleDateFormat) {
            try {
                return RFC1123.parse(dateString);
            }
            catch (ParseException e) {
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        simpleDateFormat = RFC1036;
        synchronized (simpleDateFormat) {
            try {
                return RFC1036.parse(dateString);
            }
            catch (ParseException e) {
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        simpleDateFormat = ASCTIME;
        synchronized (simpleDateFormat) {
            try {
                return ASCTIME.parse(dateString);
            }
            catch (ParseException e) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("invalid date");
    }

    public static String dateToString(Date date) {
        return ((SimpleDateFormat)RFC1123_TL.get()).format(date);
    }

    public static void spool(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[32768];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    public static void spool(Reader reader, Writer writer) throws IOException {
        int len;
        char[] buf = new char[32768];
        while ((len = reader.read(buf)) != -1) {
            writer.write(buf, 0, len);
        }
    }

    public static Throwable getRootCause(ServletException e) {
        ServletException current = e;
        while (current.getRootCause() != null) {
            Throwable t = current.getRootCause();
            if (t instanceof ServletException) {
                current = (ServletException)t;
                continue;
            }
            return t;
        }
        return current;
    }

    public static LanguageTag[] parseAcceptLanguage(String s) throws IllegalArgumentException {
        String[] sections = Text.split(s, 44);
        ArrayList<LanguageTag> list = new ArrayList<LanguageTag>();
        for (int i = 0; i < sections.length; ++i) {
            String section;
            String tag = section = sections[i].trim();
            int q = 1000;
            int sep = section.indexOf(59);
            if (sep != -1) {
                int qidx = section.indexOf("q=", sep + 1);
                if (qidx != -1) {
                    q = Util.parseQualityValue(section.substring(qidx + 2).trim());
                }
                tag = section.substring(0, sep).trim();
            }
            if ("*".equals(tag)) continue;
            list.add(new LanguageTag(tag, q));
        }
        Object[] result = new LanguageTag[list.size()];
        list.toArray(result);
        Arrays.sort(result);
        return result;
    }

    public static int parseQualityValue(String s) {
        int q;
        int i;
        int n1 = s.length();
        int n2 = 0;
        int sep = s.indexOf(46);
        if (sep != -1) {
            n1 = sep;
            n2 = s.length() - sep - 1;
        }
        if (n1 != 1 || n2 > 3) {
            throw new IllegalArgumentException(QBADFORMAT + s);
        }
        char ch = s.charAt(0);
        if (ch != '0' && ch != '1') {
            throw new IllegalArgumentException(QBADFORMAT + s);
        }
        int q1 = ch - 48;
        int q2 = 0;
        for (i = 0; i < n2; ++i) {
            ch = s.charAt(sep + i + 1);
            if (ch < '0' || ch > '9') {
                throw new IllegalArgumentException(QBADFORMAT + s);
            }
            q2 = q2 * 10 + (ch - 48);
        }
        if (q2 != 0) {
            for (i = n2; i < 3; ++i) {
                q2 *= 10;
            }
        }
        if ((q = q1 * 1000 + q2) > 1000) {
            throw new IllegalArgumentException(QBADFORMAT + s);
        }
        return q;
    }

    static {
        RFC1123.setTimeZone(GMT);
        RFC1036.setTimeZone(GMT);
        ASCTIME.setTimeZone(GMT);
        RFC1123_TL = new ThreadLocal(){

            public Object initialValue() {
                SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                fmt.setTimeZone(GMT);
                return fmt;
            }
        };
    }

    static class LanguageTag
    implements Comparable {
        public final String tag;
        public final String primary;
        public final String subtag;
        public final int q;

        LanguageTag(String tag, int q) {
            this.tag = tag;
            this.q = q;
            int sep = tag.indexOf(45);
            if (sep != -1) {
                this.primary = tag.substring(0, sep);
                this.subtag = tag.substring(sep + 1);
            } else {
                this.primary = tag;
                this.subtag = "";
            }
        }

        public int compareTo(Object o) {
            return ((LanguageTag)o).q - this.q;
        }

        public String toString() {
            return this.tag;
        }
    }
}

