/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.DefaultSerializable;
import com.day.j2ee.config.Dispatcher;
import com.day.j2ee.config.ErrorPage;
import com.day.j2ee.config.FilterMapping;
import com.day.j2ee.config.MimeMapping;
import com.day.j2ee.config.Param;
import com.day.j2ee.config.ResourceRef;
import com.day.j2ee.config.ServletMapping;
import com.day.j2ee.config.WebXml;
import com.day.j2ee.config.WebXmlReader;
import com.day.j2ee.config.WelcomeFileList;
import com.day.j2ee.deploy.DeployException;
import com.day.j2ee.deploy.StartupFailedException;
import com.day.j2ee.jndi.JavaObjectFactory;
import com.day.j2ee.server.Server;
import com.day.j2ee.server.ZipExtractor;
import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.EventMulticaster;
import com.day.j2ee.servletengine.FilterChainImpl;
import com.day.j2ee.servletengine.FilterMap;
import com.day.j2ee.servletengine.FilterRuntimeEnvironment;
import com.day.j2ee.servletengine.JspRuntimeEnvironment;
import com.day.j2ee.servletengine.RequestDispatcherImpl;
import com.day.j2ee.servletengine.ResourceURLStreamHandler;
import com.day.j2ee.servletengine.ServletContainer;
import com.day.j2ee.servletengine.ServletEngine;
import com.day.j2ee.servletengine.ServletMap;
import com.day.j2ee.servletengine.ServletRuntimeEnvironment;
import com.day.j2ee.servletengine.ServletWrapper;
import com.day.j2ee.servletengine.URLPath;
import com.day.j2ee.servletengine.Util;
import com.day.util.IteratorEnumeration;
import com.day.util.PatternFileFilter;
import com.day.util.Text;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplication
implements ServletContext,
com.day.j2ee.deploy.WebApplication,
Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final String WEB_INF_FOLDER_NAME = "WEB-INF";
    private static final String DEFAULT_WEB_XML = "etc/web.xml";
    private Logger logger;
    private boolean trace;
    private ServletContainer container;
    private File webInf;
    private ClassLoader parentLoader;
    private ClassLoader loader;
    private WebXml webXml;
    private final ServletMap servletMap = new ServletMap();
    private final FilterMap filterMap = new FilterMap();
    private final Map errorStatusMap = new HashMap();
    private final Map errorThrowableMap = new HashMap();
    private final Map attributes = new HashMap();
    private final Map loadedServlets = new HashMap();
    private final Map loadedFilters = new HashMap();
    private final ServletWrapper fileServlet = new FileServlet();
    String[] welcomeFiles;
    private String label;
    private final String context;
    private File file;
    private File directory;
    private File tmp;
    private static final int NOT_STARTED = 0;
    private static final int STARTING = 1;
    private static final int STARTED = 2;
    private static final int STOPPING = 3;
    private int state;
    private final Object stateMonitor = new Object();
    private final com.day.j2ee.config.WebApplication config;
    private boolean internal;
    private final EventMulticaster multicaster = new EventMulticaster();
    private Properties jndiEnv;
    private Context javaCtx;
    private Integer defaultTimeout;
    static /* synthetic */ Class class$java$lang$Object;

    WebApplication(com.day.j2ee.config.WebApplication config) {
        this(config, false);
    }

    WebApplication(com.day.j2ee.config.WebApplication config, boolean internal) {
        this.config = config;
        this.context = config.getContext();
        this.internal = internal;
    }

    public WebApplication(String context) {
        this.config = null;
        this.context = context;
        this.logger = SEL;
        this.webXml = new WebXml(WebXml.Version.V2_4);
    }

    void init(ClassLoader parentLoader, ServletContainer container) throws IOException, ConfigException {
        File defaultWebXml;
        this.parentLoader = parentLoader;
        this.container = container;
        if (this.config == null) {
            return;
        }
        String flatPath = this.context.replace('/', '_');
        File path = Server.getAbsolutePath(this.config.getPath()).getCanonicalFile();
        if (!path.exists()) {
            throw new IOException("web application path " + path + " not found");
        }
        if (path.isDirectory()) {
            this.file = null;
            this.directory = path;
        } else {
            this.file = path;
            this.directory = new File(container.getRuntimeFolder(), flatPath);
            if (this.directory.exists() && this.directory.lastModified() < this.file.lastModified() && !Util.rmdir(this.directory)) {
                this.directory = new File(container.getTempFolder(), Long.toHexString(System.currentTimeMillis()));
            }
        }
        this.tmp = new File(container.getTempFolder(), flatPath);
        this.tmp.mkdirs();
        Util.clean(this.tmp);
        if (this.parentLoader == null) {
            this.parentLoader = ClassLoader.getSystemClassLoader();
        }
        if (this.file != null) {
            this.extractWAR();
        }
        this.webInf = new File(this.directory, WEB_INF_FOLDER_NAME);
        WebXmlReader reader = new WebXmlReader();
        if (!this.isInternal() && (defaultWebXml = Server.getAbsolutePath(DEFAULT_WEB_XML)).exists()) {
            reader.read(defaultWebXml);
        }
        reader.read(new File(this.webInf, "web.xml"));
        this.webXml = reader.getWebXml();
        this.setupLogger();
        this.setupMappings();
        this.setupLoader();
        this.setupWelcomeFiles();
        try {
            this.jndiEnv = ServletEngine.DEFAULT_ENVIRONMENT;
            InitialContext ctx = new InitialContext(this.jndiEnv);
            this.javaCtx = ctx.createSubcontext(container.getLabel() + "/" + this.getJndiName());
            this.javaCtx.createSubcontext("comp").createSubcontext("env");
        }
        catch (NamingException e) {
            throw new IOException("Unable to create JNDI subcontext: " + e.getMessage());
        }
        this.attributes.put("javax.servlet.context.tempdir", this.tmp);
    }

    private void reinit() {
        this.setupLoader();
    }

    private void setupLogger() {
        String appName = this.getLabel().replace('.', '_');
        this.logger = LoggerFactory.getLogger((String)("webapp-" + appName));
        this.trace = this.logger.isTraceEnabled();
    }

    public void addServlet(Servlet servlet, String name, String urlPattern) {
        ServletMapping mapping = new ServletMapping();
        mapping.setUrlPattern(urlPattern);
        com.day.j2ee.config.Servlet config = new com.day.j2ee.config.Servlet();
        config.setServletName(name);
        this.servletMap.put(mapping, config);
        ServletRuntimeEnvironment sre = new ServletRuntimeEnvironment(this, config, servlet);
        this.loadedServlets.put(config, sre);
    }

    private void setupMappings() throws IllegalArgumentException {
        DefaultSerializable mapping;
        Iterator iter = this.webXml.getServletMappings().iterator();
        while (iter.hasNext()) {
            mapping = (ServletMapping)iter.next();
            com.day.j2ee.config.Servlet servlet = this.webXml.getServlet(((ServletMapping)mapping).getServletName());
            if (servlet == null) {
                throw new IllegalArgumentException("servlet " + ((ServletMapping)mapping).getServletName() + " not defined");
            }
            this.servletMap.put((ServletMapping)mapping, servlet);
        }
        iter = this.webXml.getFilterMappings().iterator();
        while (iter.hasNext()) {
            mapping = (FilterMapping)iter.next();
            com.day.j2ee.config.Filter filter = this.webXml.getFilter(((FilterMapping)mapping).getFilterName());
            if (filter == null) {
                throw new IllegalArgumentException("filter " + ((FilterMapping)mapping).getFilterName() + " not defined");
            }
            this.filterMap.put((FilterMapping)mapping, filter);
        }
        iter = this.webXml.getErrorPages().iterator();
        while (iter.hasNext()) {
            ErrorPage page = (ErrorPage)iter.next();
            if (page.getErrorCode() != null) {
                this.errorStatusMap.put(page.getErrorCode(), page);
                continue;
            }
            this.errorThrowableMap.put(page.getExceptionType(), page);
        }
    }

    private void setupLoader() {
        File mfFile;
        ArrayList<URL> urlList = new ArrayList<URL>();
        File classes = new File(this.webInf, "classes");
        try {
            urlList.add(classes.toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.logger.warn("Unable to add WEB-INF/classes to loader", (Throwable)e);
        }
        File[] libs = new File(this.webInf, "lib").listFiles(new PatternFileFilter("*.jar"));
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                try {
                    urlList.add(libs[i].toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    this.logger.warn("Unable to add WEB-INF/lib/" + libs[i], (Throwable)e);
                }
            }
        }
        if ((mfFile = new File(this.directory, "META-INF/MANIFEST.MF".replace('/', File.separatorChar))).exists()) {
            try {
                this.populateManifestClassPath(mfFile, this.directory, urlList);
            }
            catch (IOException e) {
                this.logger.warn("Unable to load manifest file", (Throwable)e);
            }
        }
        URL[] urls = new URL[urlList.size()];
        urlList.toArray(urls);
        this.loader = new URLClassLoader(urls, this.parentLoader);
        if (this.logger.isInfoEnabled()) {
            this.logger.debug("Classpath of web application:");
            for (int i = 0; i < urls.length; ++i) {
                this.logger.debug(" - {}", (Object)WebApplication.toFilename(urls[i]));
            }
        }
    }

    private void setupWelcomeFiles() {
        WelcomeFileList welcomeFileList = this.webXml.getWelcomeFileList();
        if (welcomeFileList != null) {
            List welcomeFiles = welcomeFileList.getWelcomeFiles();
            this.welcomeFiles = new String[welcomeFiles.size()];
            welcomeFiles.toArray(this.welcomeFiles);
        } else {
            this.welcomeFiles = new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupListeners() {
        Object o = null;
        try {
            o = this.enter();
            Iterator iter = this.webXml.getListeners().iterator();
            while (iter.hasNext()) {
                Object obj;
                Class<?> clazz;
                com.day.j2ee.config.EventListener listener = (com.day.j2ee.config.EventListener)iter.next();
                try {
                    clazz = this.getLoader().loadClass(listener.getListenerClass());
                }
                catch (ClassNotFoundException e) {
                    this.logger.error("Listener class not found {}", (Object)listener.getListenerClass());
                    continue;
                }
                catch (Throwable e) {
                    this.logger.error("Unexpected error while loading listener class {}", (Object)listener.getListenerClass(), (Object)e);
                    continue;
                }
                try {
                    obj = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    this.logger.error("Unable to instantiate listener {}: {}", (Object)listener.getListenerClass(), (Object)e.getMessage());
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.logger.error("Unable to access listener {}: {}", (Object)listener.getListenerClass(), (Object)e.getMessage());
                    continue;
                }
                catch (Throwable e) {
                    this.logger.error("Unexpected error while instantiating listener {}", (Object)listener.getListenerClass(), (Object)e);
                    continue;
                }
                boolean added = this.multicaster.addListener(obj);
                if (added) continue;
                this.logger.warn("Listener {} does not expose any listener interface", (Object)listener.getListenerClass());
            }
        }
        finally {
            this.exit(o);
        }
    }

    public void addEventListener(EventListener listener) {
        this.multicaster.addListener(listener);
    }

    private void registerResourceRefs() {
        Iterator iter = this.webXml.getResourceRefs().iterator();
        while (iter.hasNext()) {
            ResourceRef resourceRef = (ResourceRef)iter.next();
            String refName = resourceRef.getName();
            try {
                LinkRef link = new LinkRef(this.container.resolvePath(refName));
                this.javaCtx.bind("comp/env/" + refName, (Object)link);
            }
            catch (NamingException e) {
                this.logger.warn("Unable to bind referenced resource {}: {}", (Object)refName, (Object)e.getMessage());
            }
        }
    }

    private void unregisterResourceRefs() {
        Iterator iter = this.webXml.getResourceRefs().iterator();
        while (iter.hasNext()) {
            ResourceRef resourceRef = (ResourceRef)iter.next();
            try {
                this.javaCtx.unbind("comp/env/" + resourceRef.getName());
            }
            catch (NamingException e) {
                this.logger.warn("Unable to unbind reference resource {}", (Object)resourceRef.getName(), (Object)e);
            }
        }
    }

    private String getJndiName() {
        return "webapp_" + this.context.replace('/', '_');
    }

    private void populateManifestClassPath(File mfFile, File parentDir, List urlList) throws IOException {
        Manifest mf = this.loadManifest(mfFile);
        String cpValue = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (cpValue != null) {
            String[] cpEntries = Text.split(cpValue, 32);
            for (int i = 0; i < cpEntries.length; ++i) {
                File cpEntry = new File(cpEntries[i].replace('/', File.separatorChar));
                if (!cpEntry.isAbsolute()) {
                    cpEntry = new File(parentDir, cpEntry.getPath());
                }
                try {
                    urlList.add(cpEntry.getCanonicalFile().toURI().toURL());
                    continue;
                }
                catch (IOException e) {
                    this.logger.warn("Unable to add '{}' to loader", (Object)cpEntries[i], (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletWrapper getServlet(com.day.j2ee.config.Servlet config) {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state != 2) {
                return null;
            }
            ServletRuntimeEnvironment sre = (ServletRuntimeEnvironment)this.loadedServlets.get(config);
            if (sre == null) {
                sre = this.createRuntimeEnvironment(config);
                this.loadedServlets.put(config, sre);
            }
            try {
                if (sre.getServlet() != null) {
                    return sre;
                }
            }
            catch (ServletException e) {
                this.log(MessageFormat.format("Servlet ''{0}'' threw exception", config.getServletName()), e);
            }
            return null;
        }
    }

    private ServletRuntimeEnvironment createRuntimeEnvironment(com.day.j2ee.config.Servlet config) {
        if (config.getJspFile() != null) {
            return new JspRuntimeEnvironment(this, config);
        }
        return new ServletRuntimeEnvironment(this, config);
    }

    private Filter getFilter(com.day.j2ee.config.Filter config) {
        FilterRuntimeEnvironment env = (FilterRuntimeEnvironment)this.loadedFilters.get(config);
        if (env != null) {
            return env.getFilter();
        }
        return null;
    }

    private void extractWAR() throws IOException {
        File src = this.file;
        File dst = this.directory;
        if (!dst.exists() || src.lastModified() > dst.lastModified()) {
            Util.clean(dst);
            ZipExtractor.extract(src, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest loadManifest(File mfFile) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(mfFile));
            Manifest manifest = new Manifest(in);
            return manifest;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public RequestDispatcherImpl createRequestDispatcher(String relativePath) {
        String fullPath = this.getContextPath() + relativePath;
        return new RequestDispatcherImpl(this.container, fullPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws StartupFailedException {
        WebApplication webApplication = this;
        synchronized (webApplication) {
            if (!this.setState(0, 1)) {
                return;
            }
            int newState = 0;
            try {
                this.logger.debug("Start web application");
                Iterator iter = this.loadedServlets.values().iterator();
                while (iter.hasNext()) {
                    ServletRuntimeEnvironment sre = (ServletRuntimeEnvironment)iter.next();
                    try {
                        sre.init();
                    }
                    catch (ServletException e) {
                        this.log(MessageFormat.format("Servlet ''{0}'' threw exception", sre.getServletName()), e);
                    }
                }
                if (this.webInf != null) {
                    this.reinit();
                    this.registerResourceRefs();
                    this.setupListeners();
                    try {
                        this.contextInitialized(new ServletContextEvent(this));
                    }
                    catch (RuntimeException e) {
                        throw new StartupFailedException("A context listener threw an unchecked exception.", e);
                    }
                    this.loadFilters();
                    this.loadStartupServlets();
                }
                newState = 2;
            }
            finally {
                this.setState(1, newState);
            }
        }
    }

    private void loadFilters() {
        Iterator iter = this.webXml.getFilters().iterator();
        while (iter.hasNext()) {
            com.day.j2ee.config.Filter config = (com.day.j2ee.config.Filter)iter.next();
            try {
                FilterRuntimeEnvironment env = new FilterRuntimeEnvironment(this, config);
                env.start();
                this.loadedFilters.put(config, env);
            }
            catch (ServletException e) {
                this.log(MessageFormat.format("Filter ''{0}'' threw exception", config.getFilterName()), e);
            }
        }
    }

    private void loadStartupServlets() {
        com.day.j2ee.config.Servlet servlet;
        TreeMap<Integer, ArrayList<com.day.j2ee.config.Servlet>> startupServlets = new TreeMap<Integer, ArrayList<com.day.j2ee.config.Servlet>>();
        Iterator<Object> iter = this.webXml.getServlets().iterator();
        while (iter.hasNext()) {
            servlet = (com.day.j2ee.config.Servlet)iter.next();
            Integer level = servlet.getLoadOnStartupInt();
            if (level == null || level < 0) continue;
            ArrayList<com.day.j2ee.config.Servlet> levelServlets = (ArrayList<com.day.j2ee.config.Servlet>)startupServlets.get(level);
            if (levelServlets == null) {
                levelServlets = new ArrayList<com.day.j2ee.config.Servlet>();
                startupServlets.put(level, levelServlets);
            }
            levelServlets.add(servlet);
        }
        iter = startupServlets.values().iterator();
        while (iter.hasNext()) {
            List levelServlets = (List)iter.next();
            Iterator iter2 = levelServlets.iterator();
            while (iter2.hasNext()) {
                servlet = (com.day.j2ee.config.Servlet)iter2.next();
                try {
                    ServletRuntimeEnvironment env = this.createRuntimeEnvironment(servlet);
                    this.loadedServlets.put(servlet, env);
                    env.init();
                }
                catch (ServletException e) {
                    this.log("Startup servlet unavailable: " + servlet.getServletName(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.setState(2, 3)) {
            return;
        }
        try {
            WebApplication webApplication = this;
            synchronized (webApplication) {
                this.logger.debug("Stop + application");
                Iterator iter = this.loadedServlets.values().iterator();
                while (iter.hasNext()) {
                    ServletRuntimeEnvironment sre = (ServletRuntimeEnvironment)iter.next();
                    sre.destroy();
                }
                iter = this.loadedFilters.values().iterator();
                while (iter.hasNext()) {
                    FilterRuntimeEnvironment fre = (FilterRuntimeEnvironment)iter.next();
                    fre.stop();
                }
                this.container.getSessionManager().invalidateSessions(this);
                this.contextDestroyed(new ServletContextEvent(this));
                this.attributes.clear();
                WeakReference<ClassLoader> ref = new WeakReference<ClassLoader>(this.loader);
                this.loadedServlets.clear();
                this.loadedFilters.clear();
                this.multicaster.clear();
                this.loader = null;
                Thread.yield();
                System.gc();
                ClassLoader loader = (ClassLoader)ref.get();
                if (loader != null && !this.isInternal()) {
                    String[] activeThreads = WebApplication.getActiveThreads(loader);
                    for (int i = 0; i < activeThreads.length; ++i) {
                        this.logger.warn("Thread still active after stop request: '" + activeThreads[i] + "'");
                    }
                }
                if (this.webInf != null) {
                    this.unregisterResourceRefs();
                }
            }
        }
        finally {
            this.setState(3, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setState(int oldState, int newState) {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state != oldState) {
                return false;
            }
            this.state = newState;
            return true;
        }
    }

    private static String[] getActiveThreads(ClassLoader cl) {
        ArrayList<String> list = new ArrayList<String>();
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null) {
            g = g.getParent();
        }
        Thread[] threads = new Thread[g.activeCount() * 2];
        int activeCount = g.enumerate(threads);
        for (int i = 0; i < activeCount; ++i) {
            Thread thread = threads[i];
            if (thread.getContextClassLoader() != cl || !thread.isAlive()) continue;
            list.add(thread.getName());
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public void setRunOnStartup(String runOnStartup) {
        this.config.setRunOnStartup(runOnStartup);
    }

    public String getLabel() {
        if (this.label == null) {
            if (this.webXml != null && this.webXml.getDisplayName() != null) {
                this.label = this.webXml.getDisplayName();
            } else {
                this.label = this.context;
                if (this.label.startsWith("/")) {
                    this.label = this.label.substring(1);
                }
            }
        }
        return this.label;
    }

    public String getContext() {
        return this.context;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isStarted() {
        return this.state == 2;
    }

    String getRunOnStartup() {
        return this.config == null ? "true" : this.config.getRunOnStartup();
    }

    public void undeploy() throws DeployException {
        if (this.isInternal()) {
            throw new DeployException("Internal applications may not be undeployed.");
        }
        this.container.removeApplication(this);
    }

    public void saveConfig() {
        this.configChanged();
    }

    public void configChanged() {
        this.container.configChanged();
    }

    void cleanup() {
        if (this.file != null && this.directory.exists()) {
            long lastModified = this.directory.lastModified();
            if (!Util.rmdir(this.directory)) {
                this.logger.warn("Unable to remove all files in: " + this.directory);
                this.directory.setLastModified(lastModified);
            }
        }
        if (this.javaCtx != null) {
            try {
                InitialContext ctx = new InitialContext(this.jndiEnv);
                ctx.destroySubcontext(this.container.getLabel() + "/" + this.getJndiName());
            }
            catch (NamingException e) {
                this.logger.warn("Unable to destroy subcontext: " + e.getMessage());
            }
        }
    }

    public ServletWrapper map(URLPath urlPath) {
        com.day.j2ee.config.Servlet config = this.servletMap.map(urlPath);
        if (config != null) {
            return this.getServlet(config);
        }
        urlPath.setServletPath(urlPath.getRemaining());
        return this.fileServlet;
    }

    public String getContextPath() {
        return this.context.equals("/") ? "" : this.context;
    }

    public ServletContext getContext(String uripath) {
        if (this.trace) {
            this.logger.trace("getContext({})", (Object)uripath);
        }
        return this.container.map(new URLPath(uripath));
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String file) {
        String extension;
        MimeMapping mapping;
        if (this.trace) {
            this.logger.trace("getMimeType({})", (Object)file);
        }
        String mimeType = null;
        int index = file.lastIndexOf(46);
        if (index != -1 && (mapping = this.webXml.getMimeMapping(extension = file.substring(index + 1))) != null) {
            mimeType = mapping.getMimeType();
        }
        return mimeType;
    }

    public URL getResource(String path) throws MalformedURLException {
        File resource;
        if (this.trace) {
            this.logger.trace("getResource({})", (Object)path);
        }
        if ((resource = this.getFileResource(path, true)) == null) {
            return null;
        }
        return WebApplication.fileToURL(resource);
    }

    File getFileResource(String path, boolean allowWebInf) throws MalformedURLException {
        File resource;
        if (!(path = path.replace(File.separatorChar, '/')).startsWith("/")) {
            throw new MalformedURLException("path must begin with a '/'");
        }
        String osPath = path.substring(1).replace('/', File.separatorChar);
        try {
            resource = new File(this.directory, osPath).getCanonicalFile();
        }
        catch (IOException e) {
            this.logger.warn("Unable to get canonical file for {}", (Object)path, (Object)e);
            return null;
        }
        if (!resource.exists()) {
            this.logger.debug("Resource {} does not exist", (Object)resource.getPath());
            return null;
        }
        if (!resource.isFile()) {
            this.logger.debug("Resource {} is not a file", (Object)resource.getPath());
            return null;
        }
        if (!resource.canRead()) {
            this.logger.debug("Resource {} is not readable", (Object)resource.getPath());
            return null;
        }
        if (!WebApplication.isAncestorOf(this.directory, resource)) {
            this.logger.debug("Resource {} lies outside document root", (Object)resource.getPath());
            return null;
        }
        if (!allowWebInf && WebApplication.isAncestorOf(this.webInf, resource)) {
            this.logger.debug("Resource {} lies inside WEB-INF folder", (Object)resource.getPath());
            return null;
        }
        return resource;
    }

    static URL fileToURL(File file) throws MalformedURLException {
        URL u = file.toURI().toURL();
        return new URL("file", null, -1, u.getFile(), new ResourceURLStreamHandler());
    }

    private static boolean isAncestorOf(File directory, File file) {
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!directory.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public InputStream getResourceAsStream(String path) {
        if (this.trace) {
            this.logger.trace("getResourceAsStream({})", (Object)path);
        }
        path = path.replace(File.separatorChar, '/');
        try {
            URL url = this.getResource(path);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        String osPath;
        File parent;
        String[] names;
        if (this.trace) {
            this.logger.trace("getResourcePaths({})", (Object)path);
        }
        if (!path.startsWith("/")) {
            this.logger.warn("path not starting with a '/', ignored");
            return null;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((names = (parent = new File(this.directory, osPath = path.substring(1).replace('/', File.separatorChar))).list()) == null) {
            names = new String[]{};
        }
        HashSet<String> entries = new HashSet<String>();
        for (int i = 0; i < names.length; ++i) {
            if (new File(parent, names[i]).isDirectory()) {
                entries.add(path + names[i] + "/");
                continue;
            }
            entries.add(path + names[i]);
        }
        return entries;
    }

    public RequestDispatcher getRequestDispatcher(String relativePath) {
        if (this.trace) {
            this.logger.trace("getRequestDispatcher({})", (Object)relativePath);
        }
        return this.createRequestDispatcher(relativePath);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        com.day.j2ee.config.Servlet config;
        if (this.trace) {
            this.logger.trace("getNamedDispatcher({})", (Object)name);
        }
        if ((config = this.webXml.getServlet(name)) == null) {
            return null;
        }
        ServletWrapper servlet = this.getServlet(config);
        if (servlet == null) {
            return null;
        }
        return new RequestDispatcherImpl(this.container, this, servlet);
    }

    public Servlet getServlet(String name) throws ServletException {
        if (this.trace) {
            this.logger.trace("getServlet({})", (Object)name);
        }
        return null;
    }

    public Enumeration getServlets() {
        if (this.trace) {
            this.logger.trace("getServlets");
        }
        return new Vector().elements();
    }

    public Enumeration getServletNames() {
        if (this.trace) {
            this.logger.trace("getServletNames");
        }
        return new Vector().elements();
    }

    public String getServletContextName() {
        if (this.trace) {
            this.logger.trace("getServletContextName");
        }
        return this.webXml.getDisplayName();
    }

    public void log(String msg) {
        this.logger.info("log({})", (Object)msg);
    }

    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }

    public void log(String message, Throwable throwable) {
        if (this.trace) {
            this.logger.trace("log({},{})", (Object)message, (Object)throwable);
        }
        this.logger.error(message, throwable);
        while (throwable instanceof ServletException && (throwable = ((ServletException)throwable).getRootCause()) != null) {
            this.logger.error("Root cause", throwable);
        }
    }

    public String getRealPath(String path) {
        String osPath;
        if (this.trace) {
            this.logger.trace("getRealPath({})", (Object)path);
        }
        if ((osPath = path.replace('/', File.separatorChar)).startsWith(File.separator)) {
            osPath = osPath.substring(1);
        }
        return new File(this.directory, osPath).getPath();
    }

    public String getServerInfo() {
        if (this.trace) {
            this.logger.trace("getServerInfo");
        }
        return ServletEngine.getVersion().getServerHeader();
    }

    public String getInitParameter(String name) {
        Param contextParam;
        if (this.trace) {
            this.logger.trace("getInitParameter({})", (Object)name);
        }
        if ((contextParam = this.webXml.getContextParam(name)) != null) {
            return contextParam.getParamValue();
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        if (this.trace) {
            this.logger.trace("getInitParameterNames");
        }
        return new IteratorEnumeration(this.webXml.contextParamNames());
    }

    public Object getAttribute(String name) {
        if (this.trace) {
            this.logger.trace("getAttribute", (Object)name);
        }
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        if (this.trace) {
            this.logger.trace("getAttributeNames");
        }
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        if (this.trace) {
            this.logger.trace("getAttribute({},{})", (Object)name, value);
        }
        if (name.equals("javax.servlet.context.tempdir")) {
            this.logger.warn("attribute setting of '{}' ignored", (Object)name);
            return;
        }
        if (value == null) {
            this.removeAttribute(name);
        } else {
            Object old = this.attributes.put(name, value);
            if (old != null) {
                this.contextAttributeReplaced(new ServletContextAttributeEvent(this, name, old));
            } else {
                this.contextAttributeAdded(new ServletContextAttributeEvent(this, name, value));
            }
        }
    }

    public void removeAttribute(String name) {
        if (this.trace) {
            this.logger.trace("removeAttribute({})", (Object)name);
        }
        if (name.equals("javax.servlet.context.tempdir")) {
            this.logger.warn("attribute removal of '{}' ignored", (Object)name);
            return;
        }
        Object value = this.attributes.remove(name);
        if (value != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent(this, name, value);
            this.contextAttributeRemoved(event);
        }
    }

    public Integer getDefaultTimeout() {
        if (this.defaultTimeout == null && this.webXml.getSessionConfig() != null) {
            this.defaultTimeout = this.webXml.getSessionConfig().getSessionTimeout();
        }
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(int defaultTimeout) {
        this.defaultTimeout = new Integer(defaultTimeout);
    }

    public boolean getHttpOnlyFlag() {
        if (this.webXml.getSessionConfig() != null && this.webXml.getSessionConfig().getCookieConfig() != null) {
            Boolean httpOnly = this.webXml.getSessionConfig().getCookieConfig().getHttpOnly();
            return httpOnly == null ? true : httpOnly;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.contextInitialized(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.contextDestroyed(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextAttributeAdded(ServletContextAttributeEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.attributeAdded(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextAttributeReplaced(ServletContextAttributeEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.attributeReplaced(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextAttributeRemoved(ServletContextAttributeEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.attributeRemoved(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.sessionCreated(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.sessionDestroyed(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionAttributeAdded(HttpSessionBindingEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.attributeAdded(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionAttributeReplaced(HttpSessionBindingEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.attributeReplaced(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionAttributeRemoved(HttpSessionBindingEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.attributeRemoved(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInitialized(ServletRequest request) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.requestInitialized(new ServletRequestEvent(this, request));
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequest request) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.requestDestroyed(new ServletRequestEvent(this, request));
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAttributeAdded(ServletRequestAttributeEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.attributeAdded(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAttributeReplaced(ServletRequestAttributeEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.attributeReplaced(event);
        }
        finally {
            this.exit(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAttributeRemoved(ServletRequestAttributeEvent event) {
        Object o = null;
        try {
            o = this.enter();
            this.multicaster.attributeRemoved(event);
        }
        finally {
            this.exit(o);
        }
    }

    private static final String toFilename(URL url) {
        String filename = url.getFile();
        if ((filename = filename.replace('/', File.separatorChar)).startsWith("\\")) {
            filename = filename.substring(1);
        }
        return filename;
    }

    Logger getLogger() {
        return this.logger;
    }

    ClassLoader getLoader() {
        return this.loader;
    }

    com.day.j2ee.config.WebApplication getConfig() {
        return this.config;
    }

    Object enter() {
        if (this.loader == null) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        JavaObjectFactory.pushContext(this.javaCtx);
        return cl;
    }

    void exit(Object o) {
        if (o == null) {
            return;
        }
        JavaObjectFactory.popContext();
        ClassLoader cl = (ClassLoader)o;
        if (cl != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    FilterChain createFilterChain(String path, String servletName, FilterChain last, Dispatcher dispatcher) {
        com.day.j2ee.config.Filter[] configs = this.filterMap.map(path, servletName, dispatcher);
        if (configs == null) {
            return null;
        }
        Filter[] filters = new Filter[configs.length];
        int length = 0;
        for (int i = 0; i < configs.length; ++i) {
            Filter filter = this.getFilter(configs[i]);
            if (filter == null) continue;
            filters[length++] = filter;
        }
        if (length == 0) {
            return null;
        }
        return new FilterChainImpl(filters, length, last);
    }

    public ErrorPage getErrorPage(int status) {
        if (this.errorStatusMap.isEmpty()) {
            return null;
        }
        return (ErrorPage)this.errorStatusMap.get(new Integer(status));
    }

    public ErrorPage getErrorPage(Throwable t) {
        if (this.errorThrowableMap.isEmpty()) {
            return null;
        }
        Class<?> c = t.getClass();
        do {
            String name;
            ErrorPage errorPage;
            if ((errorPage = (ErrorPage)this.errorThrowableMap.get(name = c.getName())) == null) continue;
            return errorPage;
        } while ((c = c.getSuperclass()) != null && !c.equals(class$java$lang$Object == null ? WebApplication.class$("java.lang.Object") : class$java$lang$Object));
        return null;
    }

    class FileServlet
    implements ServletWrapper,
    Constants {
        FileServlet() {
        }

        protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            String path = this.getServletPath(req);
            if (path != null) {
                File resource;
                if (path.endsWith("/") && WebApplication.this.welcomeFiles != null) {
                    for (int i = 0; i < WebApplication.this.welcomeFiles.length; ++i) {
                        String welcomeFile = path + WebApplication.this.welcomeFiles[i];
                        if (WebApplication.this.getFileResource(welcomeFile, false) == null) continue;
                        req.getRequestDispatcher(welcomeFile).forward(req, res);
                        return;
                    }
                }
                if ((resource = WebApplication.this.getFileResource(path, false)) != null) {
                    this.spool(WebApplication.fileToURL(resource), res);
                    return;
                }
            }
            if (!res.isCommitted()) {
                res.sendError(404);
            }
        }

        private String getServletPath(HttpServletRequest req) {
            if (req.getAttribute("javax.servlet.include.request_uri") != null) {
                return (String)req.getAttribute("javax.servlet.include.servlet_path");
            }
            return req.getServletPath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void spool(URL url, HttpServletResponse resp) throws IOException {
            URLConnection connection = url.openConnection();
            InputStream in = null;
            try {
                String contentType;
                int contentLength = connection.getContentLength();
                if (contentLength != -1) {
                    resp.setContentLength(contentLength);
                }
                if ((contentType = WebApplication.this.getMimeType(url.getFile())) == null) {
                    contentType = connection.getContentType();
                }
                if (contentType != null) {
                    resp.setContentType(contentType);
                }
                in = connection.getInputStream();
                try {
                    Util.spool(in, resp.getOutputStream());
                }
                catch (IllegalStateException e) {
                    Util.spool(new InputStreamReader(in), resp.getWriter());
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        public String getServletName() {
            return null;
        }

        public void service(ServletRequest req, ServletResponse res) throws IOException, ServletException {
            HttpServletResponse response;
            HttpServletRequest request;
            try {
                request = (HttpServletRequest)req;
                response = (HttpServletResponse)res;
            }
            catch (ClassCastException e) {
                throw new ServletException("non-HTTP request or response");
            }
            this.service(request, response);
        }
    }
}

