/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

public final class Condition {
    private boolean condition;
    private final boolean alertable;

    public Condition(boolean initialState, boolean alertable) {
        this.condition = initialState;
        this.alertable = alertable;
    }

    public Condition(boolean initialState) {
        this(initialState, true);
    }

    public Condition() {
        this(false, true);
    }

    public final synchronized void waitUntilTrue() throws InterruptedException {
        if (!this.alertable) {
            throw new IllegalStateException("Condition not alertable");
        }
        while (!this.condition) {
            this.wait();
        }
    }

    public final synchronized void waitUntilFalse() throws InterruptedException {
        if (!this.alertable) {
            throw new IllegalStateException("Condition not alertable");
        }
        while (this.condition) {
            this.wait();
        }
    }

    public final synchronized void setTrue() {
        this.condition = true;
        if (this.alertable) {
            this.notifyAll();
        }
    }

    public final synchronized void setFalse() {
        this.condition = false;
        if (this.alertable) {
            this.notifyAll();
        }
    }

    public final synchronized boolean isTrue() {
        return this.condition;
    }

    public final synchronized boolean isFalse() {
        return !this.isTrue();
    }

    public final synchronized boolean trySetTrue() {
        if (!this.condition) {
            this.condition = true;
            if (this.alertable) {
                this.notifyAll();
            }
            return true;
        }
        return false;
    }

    public final synchronized boolean trySetFalse() {
        if (this.condition) {
            this.condition = false;
            if (this.alertable) {
                this.notifyAll();
            }
            return true;
        }
        return false;
    }
}

