/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

public final class Lock {
    private Thread owner;
    private int locks;

    public final synchronized void acquire() throws InterruptedException {
        if (this.owner != Thread.currentThread()) {
            while (this.owner != null) {
                this.wait();
            }
            this.owner = Thread.currentThread();
        }
        ++this.locks;
    }

    public final synchronized boolean release() {
        if (--this.locks == 0) {
            this.owner = null;
            this.notify();
            return true;
        }
        return false;
    }

    public final synchronized boolean tryAcquire() {
        if (this.owner != Thread.currentThread()) {
            if (this.owner != null) {
                return false;
            }
            this.owner = Thread.currentThread();
        }
        ++this.locks;
        return true;
    }

    public final synchronized void waitUntilReleased() throws InterruptedException {
        while (this.owner != null) {
            this.wait();
        }
    }
}

