/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import com.day.util.MacBinaryDecoderOutputStream;
import com.day.util.MultipartInputStreamHandler;
import com.day.util.UploadedFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class MultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    private static final String NO_FILE = "unknown";
    private static final String CONTENT_DISPO_HEADER = "content-disposition";
    private static final String CONTENT_TYPE_HEADER = "content-type";
    private HttpServletRequest req;
    private File dir;
    private int maxSize;
    private Hashtable parameters = new Hashtable();
    private Hashtable files = new Hashtable();

    public MultipartRequest(HttpServletRequest request, File saveDirectory) throws IOException {
        this(request, saveDirectory, 0x100000);
    }

    public MultipartRequest(HttpServletRequest request, File saveDirectory, int maxPostSize) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (maxPostSize <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        this.req = request;
        this.dir = saveDirectory;
        this.maxSize = maxPostSize;
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!this.dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + saveDirectory);
        }
        this.readRequest();
    }

    public MultipartRequest(ServletRequest request, File saveDirectory) throws IOException {
        this((HttpServletRequest)request, saveDirectory);
    }

    public MultipartRequest(ServletRequest request, File saveDirectory, int maxPostSize) throws IOException {
        this((HttpServletRequest)request, saveDirectory, maxPostSize);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getParameter(String name) {
        try {
            Vector values = (Vector)this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            String value = (String)values.elementAt(values.size() - 1);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getParameterValues(String name) {
        try {
            Vector values = (Vector)this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            Object[] valuesArray = new String[values.size()];
            values.copyInto(valuesArray);
            return valuesArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFilesystemName(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getFilesystemName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContentType(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getContentType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void readRequest() throws IOException {
        int length = this.req.getContentLength();
        if (length > this.maxSize) {
            throw new IOException("Posted content length of " + length + " exceeds limit of " + this.maxSize);
        }
        String type = null;
        String type1 = this.req.getHeader("Content-Type");
        String type2 = this.req.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        String boundary = this.extractBoundary(type);
        if (boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        MultipartInputStreamHandler in = new MultipartInputStreamHandler(this.req.getInputStream(), length);
        String line = in.readLine();
        if (line == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!line.startsWith(boundary)) {
            throw new IOException("Corrupt form data: no leading boundary");
        }
        boolean done = false;
        while (!done) {
            done = this.readNextPart(in, boundary);
        }
    }

    protected boolean readNextPart(MultipartInputStreamHandler in, String boundary) throws IOException {
        String line = in.readLine();
        if (line == null) {
            return true;
        }
        if (line.length() == 0) {
            return true;
        }
        Map headers = this.readHeaders(in, line);
        String dispoLine = (String)headers.get(CONTENT_DISPO_HEADER);
        if (dispoLine == null) {
            throw new IOException("No content disposition header!");
        }
        String[] dispInfo = this.extractDispositionInfo(dispoLine);
        String name = dispInfo[1];
        String filename = dispInfo[2];
        String contentTypeLine = (String)headers.get(CONTENT_TYPE_HEADER);
        String contentType = "application/octet-stream";
        if (contentTypeLine != null) {
            contentType = this.extractContentType(contentTypeLine);
        }
        if (filename == null) {
            Vector<String> existingValues;
            String value = this.readParameter(in, boundary);
            if (value.equals("")) {
                value = null;
            }
            if ((existingValues = (Vector<String>)this.parameters.get(name)) == null) {
                existingValues = new Vector<String>();
                this.parameters.put(name, existingValues);
            }
            existingValues.addElement(value);
        } else {
            File f = this.readAndSaveFile(in, boundary, filename, contentType);
            if (filename.equals(NO_FILE)) {
                this.files.put(name, new UploadedFile(null, null));
            } else {
                this.files.put(name, new UploadedFile(f, contentType));
            }
        }
        return false;
    }

    protected Map readHeaders(MultipartInputStreamHandler in, String line) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        while (line != null && line.length() > 0) {
            int colon = line.indexOf(58);
            if (colon == -1) {
                throw new IOException("Invalid header line: " + line);
            }
            headers.put(line.substring(0, colon).toLowerCase(), line);
            line = in.readLine();
        }
        return headers;
    }

    protected String readParameter(MultipartInputStreamHandler in, String boundary) throws IOException {
        String line;
        StringBuffer sbuf = new StringBuffer();
        while ((line = in.readLine()) != null && !line.startsWith(boundary)) {
            sbuf.append(line + "\r\n");
        }
        if (sbuf.length() == 0) {
            return null;
        }
        sbuf.setLength(sbuf.length() - 2);
        return sbuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File readAndSaveFile(MultipartInputStreamHandler in, String boundary, String filename, String contentType) throws IOException {
        File f = null;
        OutputStream out = null;
        if (filename.equals(NO_FILE)) {
            out = new ByteArrayOutputStream();
        } else if (contentType.equals("application/x-macbinary")) {
            f = File.createTempFile("multipart", null, this.dir);
            out = new MacBinaryDecoderOutputStream(new BufferedOutputStream(new FileOutputStream(f), 8192));
        } else {
            f = File.createTempFile("multipart", null, this.dir);
            out = new BufferedOutputStream(new FileOutputStream(f), 8192);
        }
        byte[] bbuf = new byte[102400];
        try {
            String line;
            int result;
            boolean rnflag = false;
            while (!((result = in.readLine(bbuf, 0, bbuf.length)) == -1 || result > 2 && bbuf[0] == 45 && bbuf[1] == 45 && (line = new String(bbuf, 0, result, "ISO-8859-1")).startsWith(boundary))) {
                if (rnflag) {
                    out.write(13);
                    out.write(10);
                    rnflag = false;
                }
                if (result >= 2 && bbuf[result - 2] == 13 && bbuf[result - 1] == 10) {
                    out.write(bbuf, 0, result - 2);
                    rnflag = true;
                    continue;
                }
                out.write(bbuf, 0, result);
            }
            Object var12_11 = null;
            if (out == null) return f;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            out.close();
            return f;
        }
        catch (IOException e) {}
        return f;
    }

    private String extractBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        boundary = "--" + boundary;
        return boundary;
    }

    private String[] extractDispositionInfo(String line) throws IOException {
        String[] retval = new String[3];
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition:");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line.substring(start + 20, end).trim();
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String name = origline.substring(start + 6, end);
        String filename = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
            if (filename.equals("")) {
                filename = NO_FILE;
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        return retval;
    }

    private String extractContentType(String line) throws IOException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-type:")) {
            contentType = line.substring("content-type:".length()).trim();
        } else if (line.length() != 0) {
            throw new IOException("Malformed line after disposition: " + origline);
        }
        return contentType;
    }
}

