/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.util.LinkedList;

public final class Queue {
    private final LinkedList list = new LinkedList();
    private boolean closed;
    private final boolean unique;

    public Queue() {
        this(true);
    }

    public Queue(boolean unique) {
        this.unique = unique;
    }

    public final synchronized void enqueue(Object o) {
        if (!this.unique || !this.list.contains(o)) {
            this.list.addLast(o);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object dequeue() throws InterruptedException {
        while (this.list.isEmpty()) {
            if (this.closed) {
                Thread.currentThread().interrupt();
            }
            this.wait();
        }
        Object o = this.list.removeFirst();
        if (this.list.isEmpty()) {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                this.list.notifyAll();
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object dequeue(long timeout) throws InterruptedException {
        if (timeout == 0L) {
            return this.dequeue();
        }
        long current = System.currentTimeMillis();
        while (this.list.isEmpty()) {
            if (this.closed) {
                Thread.currentThread().interrupt();
            }
            this.wait(timeout);
            if (!this.list.isEmpty()) break;
            long now = System.currentTimeMillis();
            if (now - current < timeout) continue;
            return null;
        }
        Object o = this.list.removeFirst();
        if (this.list.isEmpty()) {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                this.list.notifyAll();
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            this.waitUntilEmpty();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Queue queue = this;
        synchronized (queue) {
            this.closed = true;
            this.notifyAll();
        }
    }

    public final synchronized boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitUntilEmpty() throws InterruptedException {
        while (!this.list.isEmpty()) {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                this.list.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean remove(Object o) {
        if (this.list.remove(o)) {
            if (this.list.isEmpty()) {
                LinkedList linkedList = this.list;
                synchronized (linkedList) {
                    this.list.notify();
                }
            }
            return true;
        }
        return false;
    }

    public final int size() {
        return this.list.size();
    }
}

