/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.security.MessageDigest;
import java.security.SecureRandom;

public class UUID {
    private final byte[] bytes;
    private String string;
    private final int version;
    public static final char[] hexDigits = "0123456789abcdef".toCharArray();
    private static volatile SecureRandom numberGenerator = null;

    public UUID(String string) {
        this.string = string;
        this.bytes = new byte[16];
        int j = 0;
        for (int i = 0; i < 36; i += 2) {
            this.bytes[j++] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
            if (i != 6 && i != 11 && i != 16 && i != 21) continue;
            ++i;
        }
        this.version = this.bytes[7] >> 4 & 0xF;
    }

    public UUID(byte[] bytes) {
        this.bytes = new byte[16];
        System.arraycopy(bytes, 0, this.bytes, 0, Math.min(16, bytes.length));
        this.version = bytes[7] >> 4 & 0xF;
    }

    public UUID(long[] longs) {
        int i;
        long hi = longs[0];
        long lo = longs[1];
        this.bytes = new byte[16];
        for (i = 7; i >= 0; --i) {
            this.bytes[i] = (byte)(hi & 0xFFL);
            hi >>= 8;
        }
        for (i = 7; i >= 0; --i) {
            this.bytes[8 + i] = (byte)(lo & 0xFFL);
            lo >>= 8;
        }
        this.version = this.bytes[7] >> 4 & 0xF;
    }

    public UUID(String name, String namespace) {
        this.version = 3;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(namespace.getBytes());
            md5.update(name.getBytes());
            this.bytes = md5.digest();
            this.bytes[7] = (byte)(this.bytes[7] & 0xF | (byte)(this.version << 4));
            this.bytes[8] = (byte)(this.bytes[7] & 0x3F | 0x80);
            return;
        }
        catch (Exception exc) {
            throw new InternalError("MD5 not available");
        }
    }

    public UUID() {
        this.version = 4;
        this.bytes = UUID.randomUUID();
    }

    private static byte[] randomUUID() {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return randomBytes;
    }

    public UUID(byte[] node, long time, short clock) {
        int i;
        this.version = 1;
        this.bytes = new byte[16];
        long t = time;
        for (i = 0; i < 8; ++i) {
            this.bytes[i] = (byte)(t & 0xFFL);
            t >>= 8;
        }
        this.bytes[7] = (byte)(this.bytes[7] | (byte)(this.version << 4));
        this.bytes[8] = (byte)(clock >> 8 & 0x3F | 0x80);
        this.bytes[9] = (byte)(clock & 0xFF);
        for (i = 0; i < 6; ++i) {
            this.bytes[10 + i] = node[i];
        }
    }

    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object toUUID) {
        if (this == toUUID) {
            return true;
        }
        try {
            UUID uuid = (UUID)toUUID;
            if (this.bytes == uuid.bytes) {
                return true;
            }
            for (int i = 0; i < 16; ++i) {
                if (this.bytes[i] == uuid.bytes[i]) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        if (this.string == null) {
            char[] chars = new char[36];
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                chars[j++] = hexDigits[this.bytes[i] >> 4 & 0xF];
                chars[j++] = hexDigits[this.bytes[i] & 0xF];
                if (i != 3 && i != 5 && i != 7 && i != 9) continue;
                chars[j++] = 45;
            }
            this.string = new String(chars);
        }
        return this.string;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

