/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.tools.exec.relation;

import com.dimajix.common.ExceptionUtils;
import com.dimajix.flowman.execution.Context;
import com.dimajix.flowman.execution.NoSuchRelationException;
import com.dimajix.flowman.execution.Operation;
import com.dimajix.flowman.execution.Session;
import com.dimajix.flowman.execution.Status;
import com.dimajix.flowman.model.Project;
import com.dimajix.flowman.model.Relation;
import com.dimajix.flowman.model.package;
import com.dimajix.flowman.tools.exec.Command;
import java.io.Serializable;
import org.kohsuke.args4j.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.SetLike;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0003\u0006\u0001/!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0016\u0001A\u0003%!\u0005C\u0004\f\u0001\u0001\u0007I\u0011A\u0016\t\u000fe\u0002\u0001\u0019!C\u0001u!1\u0011\t\u0001Q!\n1BQa\u0015\u0001\u0005BQCQ!\u001c\u0001\u0005\n9\u0014a\"\u00138ta\u0016\u001cGoQ8n[\u0006tGM\u0003\u0002\f\u0019\u0005A!/\u001a7bi&|gN\u0003\u0002\u000e\u001d\u0005!Q\r_3d\u0015\ty\u0001#A\u0003u_>d7O\u0003\u0002\u0012%\u00059a\r\\8x[\u0006t'BA\n\u0015\u0003\u001d!\u0017.\\1kSbT\u0011!F\u0001\u0004G>l7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000e\u000e\u00031I!a\u0007\u0007\u0003\u000f\r{W.\\1oI\u00061A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011AC\u0001\u0007Y><w-\u001a:\u0016\u0003\t\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000bMdg\r\u000e6\u000b\u0003\u001d\n1a\u001c:h\u0013\tICE\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!+\u0005a\u0003CA\u00177\u001d\tqC\u0007\u0005\u00020e5\t\u0001G\u0003\u00022-\u00051AH]8pizR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\na\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011QGM\u0001\re\u0016d\u0017\r^5p]~#S-\u001d\u000b\u0003w}\u0002\"\u0001P\u001f\u000e\u0003IJ!A\u0010\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001\u0016\t\t\u00111\u0001-\u0003\rAH%M\u0001\ne\u0016d\u0017\r^5p]\u0002B\u0003BB\"L\u00196s\u0005+\u0015\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000ba!\u0019:hgRR'B\u0001%'\u0003\u001dYw\u000e[:vW\u0016L!AS#\u0003\u0011\u0005\u0013x-^7f]R\f\u0001B]3rk&\u0014X\rZ\r\u0002\u0003\u0005)Qo]1hK\u0006\nq*A\u000fta\u0016\u001c\u0017NZ5fg\u0002\u0012X\r\\1uS>t\u0007\u0005^8!S:\u001c\b/Z2u\u0003\u001diW\r^1WCJ\f\u0013AU\u0001\u000byI,G.\u0019;j_:t\u0014aB3yK\u000e,H/\u001a\u000b\u0005+n\u0003\u0007\u000e\u0005\u0002W36\tqK\u0003\u0002Y!\u0005IQ\r_3dkRLwN\\\u0005\u00035^\u0013aa\u0015;biV\u001c\b\"\u0002/\b\u0001\u0004i\u0016aB:fgNLwN\u001c\t\u0003-zK!aX,\u0003\u000fM+7o]5p]\")\u0011m\u0002a\u0001E\u00069\u0001O]8kK\u000e$\bCA2g\u001b\u0005!'BA3\u0011\u0003\u0015iw\u000eZ3m\u0013\t9GMA\u0004Qe>TWm\u0019;\t\u000b%<\u0001\u0019\u00016\u0002\u000f\r|g\u000e^3yiB\u0011ak[\u0005\u0003Y^\u0013qaQ8oi\u0016DH/A\tqe&tG\u000fR3qK:$WM\\2jKN$2aO8t\u0011\u0015Y\u0001\u00021\u0001q!\t\u0019\u0017/\u0003\u0002sI\nA!+\u001a7bi&|g\u000eC\u0003u\u0011\u0001\u0007Q/\u0001\u0002paB\u0011aK^\u0005\u0003o^\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8")
public class InspectCommand
extends Command {
    private final Logger logger = LoggerFactory.getLogger(InspectCommand.class);
    @Argument(required=true, usage="specifies relation to inspect", metaVar="<relation>")
    private String relation = "";

    private Logger logger() {
        return this.logger;
    }

    public String relation() {
        return this.relation;
    }

    public void relation_$eq(String x$1) {
        this.relation = x$1;
    }

    @Override
    public Status execute(Session session, Project project, Context context) {
        Status.FAILED$ fAILED$;
        try {
            Relation relation = context.getRelation(package.RelationIdentifier$.MODULE$.apply(this.relation()), context.getRelation$default$2());
            Predef$.MODULE$.println((Object)"Relation:");
            Predef$.MODULE$.println((Object)new StringBuilder(10).append("    name: ").append(relation.name()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(10).append("    kind: ").append(relation.kind()).toString());
            this.printDependencies(relation, (Operation)Operation.CREATE$.MODULE$);
            this.printDependencies(relation, (Operation)Operation.READ$.MODULE$);
            this.printDependencies(relation, (Operation)Operation.WRITE$.MODULE$);
            fAILED$ = Status.SUCCESS$.MODULE$;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NoSuchRelationException) {
                NoSuchRelationException noSuchRelationException = (NoSuchRelationException)throwable2;
                this.logger().error(new StringBuilder(26).append("Cannot resolve relation '").append(noSuchRelationException.relation()).append("'").toString());
                fAILED$ = Status.FAILED$.MODULE$;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logger().error(new StringBuilder(23).append("Error inspecting '").append(this.relation()).append("':\n  ").append(ExceptionUtils.reasons((Throwable)e)).toString());
                fAILED$ = Status.FAILED$.MODULE$;
            }
            throw throwable;
        }
        return fAILED$;
    }

    private void printDependencies(Relation relation, Operation op) {
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("  Requires - ").append(op).append(":").toString());
        ((IterableLike)((SetLike)relation.requires(op, relation.requires$default$2()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.text(), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)p -> {
            Predef$.MODULE$.println((Object)new StringBuilder(4).append("    ").append(p).toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("  Provides - ").append(op).append(":").toString());
        ((IterableLike)((SetLike)relation.provides(op, relation.provides$default$2()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.text(), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)p -> {
            Predef$.MODULE$.println((Object)new StringBuilder(4).append("    ").append(p).toString());
            return BoxedUnit.UNIT;
        });
    }
}

